<?php

/*
 
 File: prefs.php3
 $Author: chuck $
 $Revision: 2.10.2.16 $
 $Date: 2000/06/21 19:21:52 $
 
 IMP: Copyright 1999, 2000 Charles J. Hagenbuch <chuck@horde.org>
 
 You should have received a copy of the GNU Public
 License along with this package; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 
 */

$need_horde_db = 1;
require '../lib/horde.lib';
require './lib/imp.lib';              /* IMPlib is the IMP function library  */
require './config/defaults.php3';     /* Defaults configuration file */
require './config/lang.php3';

/* Html styles configuration */
require '../config/html.php3';
require './config/html.php3';

$language = select_lang();
require './lib/postconf.php3';

require "./locale/$language/prefs.lang";
require './locale/local/prefs.lang';
require './config/lang.php3';

error_reporting($default->error_level);  /* set error level from imp.lib   */

/* Adjust the form element sizes for the appropriate screen size */
if ($_html['screen_size'] == 'small') {
  $_html['smresize'] = 0.7;
  $_html['bgresize'] = 0.5;
} else if ($_html['screen_size'] == 'large') {
  $_html['smresize'] = 1;
  $_html['bgresize'] = 1;
}
$_html['compose_headers_size'] = $_html['compose_headers_size'] * $_html['smresize'];
$_html['compose_attach_size'] = $_html['compose_attach_size'] * $_html['smresize'];
$_html['compose_body_cols'] = $_html['compose_body_cols'] * $_html['smresize'];
$_html['compose_body_rows'] = $_html['compose_body_rows'] * $_html['bgresize'];

/* retrieve authentication information from session */
page_open(array('sess' => 'HordeSession'));
page_close();
if (!isset($imp) || !is_object($imp)) { header('Location: ' . $sess->url('login.php3?reason=logout')); exit; }
$imp->unpickle();


$errormsg = '';
$include_refresh = false;
/* Run through the action handlers */
if (isset($actionID)) {
	switch($actionID) {
	case NO_ACTION:
		break;
    
	case UPDATE_PREFS:
		$updated = true;
		if (isset($signature) && ($signature != $old_signature)) {
			if (!(imp_set_signature(addslashes($signature), $imp->user, $imp->server))) {
				$errormsg .= $lang->signature_error;
				$updated = false;
			}
		}
    
		if (isset($new_lang) && ($new_lang != $old_lang)) {
			if (!(imp_set_lang($new_lang, $imp->user, $imp->server))) {
				$errormsg .= $lang->language_error;
			}
			$imp->setLang($new_lang);
			$language = $new_lang;
			include "./locale/$language/prefs.lang";
                        include './config/lang.php3';
			$include_refresh = true;
		}
    
		if (isset($from) && ($from != $old_from)) {
			if (!(imp_set_from($from, $imp->user, $imp->server))) {
				$errormsg .= $lang->from_error;
				$updated = false;
			}
		}
    
		if (isset($fullname) && ($fullname != $old_fullname)) {
			// filter for existing quotes
			if (substr($fullname, 0, 1) == '"' && substr($fullname, -1) == '"') {
				$fullname = substr($fullname, 1, -1);
			}
			// filter for illegal characters
			$quoted = imap_rfc822_write_address('', '', $fullname);
			$quoted = substr($quoted, 0, strlen($quoted)-4);
			if (!(imp_set_fullname(addslashes($quoted), $imp->user, $imp->server))) {
				$errormsg .= $lang->fullname_error;
				$updated = false;
			}
		}
		break;
	}
}

$langs = '<select name="new_lang">';
while (list($key, $val) = each($lang->lang)) {
	if ($key == $language) $sel = ' SELECTED';
	else $sel = '';
	$langs .= "<option value=\"$key\"$sel>$val</option>\n";
}
$langs .= '</select>';

$title = $lang->prefs_title;
$sidebar = false;

require "$default->include_dir/doctype.inc";
if ($include_refresh) include "$default->include_dir/mailbox/refresh_toolbar-javascript.inc";
require "$default->include_dir/generic-header.inc";
require "$default->include_dir/prefs/begin.inc";
require "$default->include_dir/prefs/signature.inc";
if ($default->user_change_fullname) include "$default->include_dir/prefs/fullname.inc";
if ($default->user_change_from) include "$default->include_dir/prefs/from.inc";
if ($default->user_change_language) include "$default->include_dir/prefs/lang.inc";
require "$default->include_dir/prefs/end.inc";
require "$default->include_dir/generic-footer.inc";

?>
