#
#  File: imp.spec
#  $Author: bjn $
#  $Revision: 1.1.2.2 $
#  $Date: 2000/05/30 22:45:25 $
#
#  This is the SPEC file for the IMP RPM/SRPM
#

Summary: The Internet Messaging Program: webmail access to IMAP/POP3 accounts.
Name: imp
# Hopefully this dash-vs-underscore hack can go away after pre:
Version: 2.2.0_pre12
%define dashversion 2.2.0-pre12
Release: 1
Copyright: GPL
Group: Applications/Horde
Source: ftp://ftp.horde.org/pub/imp/tarballs/imp-%{dashversion}.tar.gz
Vendor: The Horde Project
URL: http://www.horde.org/
Packager: Brent J. Nordquist <bjn@horde.org>
BuildArchitectures: noarch
BuildRoot: /tmp/imp-root
Prefix: /home/httpd/html
Requires: php-imap >= 3.0.16
Requires: horde = 1.2.0_pre12
Prereq: /usr/bin/perl

%description
IMP is the Internet Messaging Program, one of the Horde components.
It provides webmail access to IMAP and POP3 accounts.

The Horde Project writes web applications in PHP and releases them under
the GNU Public License.  For more information (including help with IMP)
please visit http://www.horde.org/.

%prep
%setup -q -n %{name}-%{dashversion}

%build
# bootstrap for -pre12:
[ -f packaging/redhat/imp.conf ] || cat <<_EOF_ >packaging/redhat/imp.conf
<Directory "/home/httpd/html/horde/imp/config">
    order deny,allow
    deny from all
</Directory>
_EOF_

%install
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/etc/httpd/conf
cp -p packaging/redhat/imp.conf $RPM_BUILD_ROOT/etc/httpd/conf
mkdir -p $RPM_BUILD_ROOT/home/httpd/html/horde/imp
cp -pR * $RPM_BUILD_ROOT/home/httpd/html/horde/imp

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT

%pre

%post
grep -i 'Include.*imp.conf$' /etc/httpd/conf/httpd.conf >/dev/null 2>&1
if [ $? -eq 0 ]; then
	perl -pi -e 's/^#+// if (/Include.*imp.conf$/i);' /etc/httpd/conf/httpd.conf
else
	echo "Include /etc/httpd/conf/imp.conf" >>/etc/httpd/conf/httpd.conf
fi
cat <<_EOF2_

IMPORTANT:  You must now configure IMP.  The following will do this:

# cd /home/httpd/html/horde
# sh install.sh
(visit http://yoursite/horde/setup.php3 in a browser)
# sh secure.sh

(See /home/httpd/html/horde/imp/docs/INSTALL for more information.)

_EOF2_

%preun

%postun
perl -pi -e 's/^/#/ if (/^Include.*imp.conf$/i);' /etc/httpd/conf/httpd.conf

%files
%defattr(-,root,root)
# Include top level with %dir so not all files are sucked in
%dir /home/httpd/html/horde/imp
# Include top-level files by hand
/home/httpd/html/horde/imp/*.php3
# Include these dirs so that all files _will_ get sucked in
/home/httpd/html/horde/imp/graphics
/home/httpd/html/horde/imp/lib
/home/httpd/html/horde/imp/locale
/home/httpd/html/horde/imp/scripts
/home/httpd/html/horde/imp/templates
# Mark documentation files with %doc and %docdir
%doc /home/httpd/html/horde/imp/COPYING
%doc /home/httpd/html/horde/imp/README
%docdir /home/httpd/html/horde/imp/docs
/home/httpd/html/horde/imp/docs
# Mark configuration files with %config and use secure permissions
# (note that .dist files are considered software; don't mark %config)
%attr(550,nobody,nobody) %dir /home/httpd/html/horde/imp/config
/home/httpd/html/horde/imp/config/README
/home/httpd/html/horde/imp/config/*.dist
%defattr(440,nobody,nobody)
%config /home/httpd/html/horde/imp/config/*.html
%config /home/httpd/html/horde/imp/config/*.php3
%config /home/httpd/html/horde/imp/config/*.txt
# Apache horde.conf file
%config /etc/httpd/conf/imp.conf

%changelog
* Tue May 30 2000 Brent J. Nordquist <bjn@horde.org>
- 2.2.0-pre12 release 1:
- RPM sets %{version} and %{release}; don't need to %define them manually
- reworded Summary and %description
- hack around version "2.2.0-pre12" for now (RPM version can't have a dash)
- new Source: location on ftp.horde.org
- added URL: and Packager:
- no Requires: Horde (we rely on "horde" RPM)
- added Requires: for php-imap and horde
- %install: copy with -p to preserve timestamps
- %install: no need to touch *.lib files (they're distributed now)
- /etc/httpd/conf/imp.conf Horde Apache config (Include'd from httpd.conf)
- don't remove build root in %post; that runs after RPM installation
- print message after RPM install:  configure IMP
- documentation now marked with %doc tag (goes to /usr/doc)
- config files now marked with %config tag (preserved on upgrade/uninstall)
- secure permissions for config directory (local users can't snoop)
- other minor style changes

* Mon Aug 02 1999 Dale Lovelace <dale@redhat.com>
- up to 1.0.10

* Fri Jul 09 1999 Dale Lovelace <dale@redhat.com>
- up to 1.0.9

* Thu Jul 08 1999 Dale Lovelace <dale@redhat.com>
- Up to 1.0.8
- Clean up build root

* Mon May 24 1999 Dale Lovelace <dale@redhat.com>
- Take out my wacky HORDE/config/modules file
- Made the RPM noarch
- added %defattr(-,nobody,nobody)

* Tue May 18 1999 Dale Lovelace <dale@redhat.com>
- Add new Summary: and %description from Mike Hardy <mike@itsprojects.com>

* Tue May 04 1999 Dale Lovelace <dale@redhat.com>
- Make relocatable prefix=/home/httpd/html
- Run install.sh to set perm's etc.
- Add horde/config dir files as %config

* Fri Apr 30 1999 Dale Lovelace <dale@redhat.com> 
- Build first RPM

