<?php

/*
  
  File: message.php3
  $Author: chuck $
  $Revision: 2.23.2.46 $
  $Date: 2000/05/25 04:03:28 $
  
  IMP: Copyright 1998, 1999, 2000 Charles J. Hagenbuch <chuck@horde.org>
  
  You should have received a copy of the GNU Public
  License along with this package; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.
  
*/

/* these need to be up here so we can use the constants we define in functions. strange but true */
require '../lib/horde.lib';
require './lib/imp.lib';           /* IMPlib is the IMP function library */

function messageRange ($arr, $index, $offset, $beginIndex) {
	$count = 200; // maybe make this configurable later
 	$half = $count/2;
	
	if ($index < $half)
		$start = 0;
	else if (($index + $count) >= count($arr))
		$start = max(0, count($arr) - $count);
	else
		$start = $index - $half;
	
	$end = min($start + $count, count($arr));
	$new = array();
	for ($i = $start; $i < $end; $i++) {
		$new[] = $arr[$i];
	}
	$offset = $start;
	$beginIndex = $index - $start - 1;
	return $new;
} // messageRange()

function buildAddressString ($array, $color) {
	global $default, $sess, $lang;
	
	$string = '';
	while (list(,$ob) = each($array)) {
		$addr = '';
		if (isset($ob->personal)) $addr .= htmlSpecialChars(decode_mime_string($ob->personal));
		$inner = '';
		if (isset($ob->mailbox) || isset($ob->host)) {
			if (isset($ob->mailbox)) $inner .= $ob->mailbox;
			$inner .= '@';
			if (isset($ob->host)) $inner .= $ob->host;
		}
		if (!empty($addr) && !empty($inner)) $addr .= ' <' . $inner . '>';
		else $addr .= $inner;
		
		if (!empty($string)) $string .= ', ';
		
		if ($default->minimum_popups) {
			$string .= '<a href="' . $sess->url('compose.php3?actionID=' . COMPOSE . '&to=' . urlencode($addr)) . '" ';
		} else {
			$string .= '<a href="javascript:open_compose_win(\'actionID=' . COMPOSE . '&to=' . urlencode($addr) . '\')" ';
		}
		$string .= 'onMouseOver="status=\'' . $lang->compose . '\'; return true;" onMouseOut="status=\'\';">' . htmlSpecialChars($addr) . '</a>';
		
		if ($default->user_use_addressbook && $default->use_db) {
			$string .= '<a onMouseOver="status=\'' . $lang->add_to_contacts . '\'; return true;" onMouseOut="status=\'\';" href="javascript:open_add_contact_win(\'actionID=' . ADD_CONTACT_OBJECT . '&object=' . urlencode(serialize($ob)) . '\');">' . '<img src="' . $default->graphics_url . '/addressbook-' . $color . '.gif" border=0 align="absmiddle" hspace=2 alt="' . $lang->add_to_contacts . '"></a>';
		}
    
	} // end while
    
	return $string;
} // buildAddressString()

function buildMessage ($attachments, $msg) {
	global $imp, $index, $default, $lang, $textparts, $images, $atc;
	$j = 0;
	
	reset($attachments);
	while (list($ref, $mime) = each($attachments)) {
		if (!$mime->header) {
			mimeParse($mime);
			if ($mime->type == TYPETEXT && 
				($mime->SUBTYPE == 'plain' || $mime->SUBTYPE == 'enriched')
				&& $mime->bytes > 0
				// display only limited size parts inline
				&& $default->text_inline_size == 0 || $mime->size <= $default->text_inline_size
				&& ($mime->encoding == ENC7BIT || $mime->encoding == ENC8BIT || $mime->encoding == ENCQUOTEDPRINTABLE || $mime->encoding == ENCBASE64)
				&& ($textparts == 0 || $default->text_parts_inline)) {
	
				/* Safe to display, it is text */
				/* get and format the main body part */
				$tmsg = @imap_fetchbody($imp->stream, $index, $ref, FT_UID);
	
				/* If it's a quoted-printable document, translate it into the right charset */
				if ($mime->encoding == ENCQUOTEDPRINTABLE) {
					$tmsg = imap_qprint($tmsg);
				} elseif ($mime->encoding == ENCBASE64) {
					$tmsg = imap_base64($tmsg);
				}
	
				if (strlen($tmsg) > 0) {
					$tmsg = str_replace('</A>', '</a>', $tmsg); // make sure that the original message doesn't contain any capital /A tags, so we can assume we generated them
					$tmsg = str_replace('<A', '<a', $tmsg);     // ditto for open <A tags
					$tmsg = preg_replace('|(\w+)://([^\s"<]*)([\w#?/&=])|', '<A href="\1://\2\3" target="_blank">\1://\2\3</A>', $tmsg);
					$tmsg = preg_replace('|[Mm][Aa][Ii][Ll][Tt][Oo]:(\s?)([\w+-=%&:_.~@]+[#\w+]*)|', '<A href="javascript:open_compose_win(\'actionID=33&to=\2\');">mailto:\1\2</A>', $tmsg);
					$tmsg = htmlspecialchars($tmsg);
					$tmsg = str_replace('&lt;A href=&quot;', '<a href="', $tmsg);
					$tmsg = str_replace('&quot; target=&quot;_blank&quot;&gt;', '" target="_blank">', $tmsg);
					$tmsg = str_replace('&quot;&gt;','">', $tmsg);
					$tmsg = str_replace('\');&quot;&gt;', '\');">', $tmsg);
					$tmsg = str_replace('&lt;/A&gt;', '</a>', $tmsg); // only reconvert capital /A tags - the ones we generated
				}
				$charset = $mime->charset;
	
				if (strtolower($charset) == 'windows-1251') {
					$tmsg = convert_cyr_string($tmsg, 'w', 'k');
				}
	
				$tmsg = '<pre>' . wrap(wrap_message($tmsg)) . '</pre>';
	
				if ($textparts > 0) {
					$msg = $msg . '</td></tr><tr><td></td></tr><tr><td bgcolor="' . $default->text_bg . '">' . $tmsg;
				} else {
					$msg = $tmsg;
				}
				if ($default->inline_in_parts_list) {
					$atc .= mimeSummary($mime);
				}
				$textparts++;
	
				/* It may not be text directly, but if its configured to be displayed inline, inline it */
			} elseif (!empty($mime->conf['view']) && !empty($mime->conf['inline']) &&
					  ($mime->encoding == ENC7BIT || $mime->encoding == ENC8BIT || $mime->encoding == ENCQUOTEDPRINTABLE || $mime->encoding == ENCBASE64)
					  && isset($mime->conf['view_function'])
					  && $mime->disposition == 'inline') {
				if ($textparts > 0) {
					/* If this MIME-type is configured to override other things for display, do it */
					if (isset($mime->conf['override_text']) && $mime->conf['override_text']) {
						$msg = '';
					} else {
						$msg = $msg . '</td></tr><tr><td></td></tr><tr><td bgcolor="' . $default->text_bg . '">';
					}
				}
	
				$func = $mime->conf['view_function'];
				if ($mime->SUBTYPE == 'html')
					$msg .= $func($mime);
				else
					$msg .= '<pre>' . $func($mime) . '</pre>';
				$textparts++;
				
				/* add it as an attachment link to download if this type is downloadable */
				if (!empty($mime->conf['download']) && $default->inline_in_parts_list) {
					$atc .= mimeSummary($mime);
				}
			} else {
				if ($mime->ifid) $images[$mime->id] = $ref;
				$atc .= mimeSummary($mime);
			}
		} // end if()
	} // end while()
	return $msg;
}

function wrap ($text, $wrap = 80, $break = "\n") {
	$paras = explode("\n", $text);
  
	$result = array();
	$i = 0;
	while ($i < count($paras)) {
		if (strlen($paras[$i]) <= $wrap) {
			$result[] = $paras[$i];
			$i++;
		} else {
			$result[] = substr($paras[$i], 0, $wrap);
			$new = trim(substr($paras[$i], $wrap, strlen($paras[$i]) - $wrap));
			if ($new != '') $paras[$i] = $new;
			else $i++;
		}
	}
	return implode($break, $result);
}


require './lib/mimetypes.lib';     /* Mime handling routes */
require './config/defaults.php3';  /* Defaults configuration file */
require './config/html.php3';
require './config/mime.php3';
$language = select_lang();
require './lib/postconf.php3';
require "./locale/$language/message.lang";
require './locale/local/message.lang';
require './config/lang.php3';

$this_client = new WebClient;
error_reporting($default->error_level);

page_open(array('sess' => 'HordeSession'));
if (!isset($imp) || !is_object($imp)) {
  page_close();
  header('Location: ' . $sess->url('login.php3?reason=logout'));
  exit;
}
$imp->unpickle();
$imp->authenticate();
$sorted = explode(':', $imp->msgl);
if ($array_index == count($sorted)-1 || $array_index == 0 || (isset($actionID) && ($actionID == DELETE_MESSAGES || $actionID == MOVE_MESSAGES || $actionID == COPY_MESSAGES) && $array_index == count($sorted)-2)) {
  $sorted = messageRange(imap_sort($imp->stream, $imp->sortby, $imp->sortdir, SE_UID), $array_index + $imp->offset + 1, &$offset, &$array_index);
  $imp->msgl = implode(':', $sorted);
  $imp->offset = $offset;
  $imp->pickle();
}
$msgindex = $array_index + $imp->offset;

if (isset($actionID)) {
  switch ($actionID) {
  case NO_ACTION:
    break;
    
  case DELETE_MESSAGES:
    if ($index && $imp->mailbox) {
      if (!(@imap_delete($imp->stream, imap_msgno($imp->stream, $index)))) {
	$errormsg = $lang->delete_error;
	$array_index++;
	$msgindex++;
	$index = $sorted[$array_index];
      } else {
	if ($imp->servtype == 'pop3') {
	  // expunge the mailbox to actually delete the message, and then recalculate the message list
	  imap_expunge($imp->stream);
	  $sorted = messageRange(imap_sort($imp->stream, $imp->sortby, $imp->sortdir, SE_UID), $array_index + $imp->offset + 1, &$offset, &$array_index);
	  $imp->msgl = implode(':', $sorted);
	  $imp->offset = $offset;
	  $imp->pickle();
	  $index = $sorted[$array_index];
	  $msgindex = $array_index + $imp->offset;
	} else {
	  $array_index++;
	  $msgindex++;
	  $index = $sorted[$array_index];
	}
      }
    }
    break;
    
  case MOVE_MESSAGES:
    if (isset($index) && isset($targetMbox) && $index && $targetMbox) {
      if (!(@imap_mail_copy($imp->stream, $index, $targetMbox, CP_UID|CP_MOVE))) {
	$status_string = $lang->move_error;
	$status_color = 'red';
      } else {
	$plural = false;
	$status_string = $lang->success2($imp->label, $targetMbox, 'moved', 1, $plural);
	$status_color = 'green';
	$array_index++;
	$msgindex++;
	$index = $sorted[$array_index];
      }
    }
    if (!isset($status_string)) {
      $plural = false;
      $status_string = $lang->move_error;
      $status_color = 'red';
    }  
    break;
    
  case COPY_MESSAGES:
    if (isset($index) && isset($targetMbox) && $targetMbox && $index) {
      if (!@imap_mail_copy($imp->stream, $index, $targetMbox, CP_UID)) {
	$status_string = $lang->copy_error;
	$status_color = 'red';
      } else {
	$plural = false;
	$status_string = $lang->success2($imp->label, $targetMbox, 'copied', 1, $plural);
	$status_color = 'green';
	$array_index++;
	$msgindex++;
	$index = $sorted[$array_index];
      }
    }
    if (!isset($status_string)) {
      $plural = false;
      $status_string = $lang->copy_error;
      $status_color = 'red';
    }
    break;
  }
}
page_close();

if ($default->user_use_folders) {
  $options = mailbox_list(true);
}

/* parse MIME header info */
$num_parts = 1;
if ($structure = @imap_fetchstructure($imp->stream, $index, FT_UID)) {
  if (isset($structure->parts) && is_array($structure->parts))
    $num_parts = count($structure->parts);
} else {
  header('Location: ' . $sess->url('mailbox.php3'));
  exit;
}

require "$default->include_dir/doctype.inc";

$bodypart = 1;
$textparts = 0;
$atc = '';
$msg = '&nbsp;';
$attachments = MimeParseStructure($structure);
$msg = buildMessage($attachments, $msg);
// handle multipart/related images. this should ideally go somewhere else, but it works here
if (!empty($images)) {
  while (list($img, $id) = each($images)) {
    if (strlen($img) > 0) {
      if ($img[0] == '<') $img = substr($img, 1);
      if ($img[strlen($img)-1] == '>') $img = substr($img, 0, strlen($img)-1);
      $msg = str_replace("cid:$img", $sess->url('view.php3?actionID=' . VIEW_ATTACH) . '&index=' . $index . '&mailbox=' . urlencode($imp->mailbox) . '&bodypart=' . $id, $msg);
    }
  }
}

if ($default->view_message_source) {
  if (!isset($atc)) $atc = '';
  $mime = new mime_part_data;
  $mime->set_type_full('message/source');
  $atc .= '<tr><td>' . $mime->img_tag() . '</td><td></td><td><font size="2" face="' . $default->font->face . '">' . "<a href=\"javascript:view('" . VIEW_SOURCE . "', 0);\">" . $lang->source . '</a></font></td><td colspan="3">&nbsp;</td></tr>';
}

$h = @imap_header($imp->stream, imap_msgno($imp->stream, $index));

if (isset($h->date))     { $dat = htmlspecialchars(chop($h->date)); }
if (isset($h->to))       { $to  = buildAddressString($h->to, 'red'); }
if (isset($h->from))     { $frm = buildAddressString($h->from, 'blue'); }
if (isset($h->cc))       { $cc  = buildAddressString($h->cc, 'yellow'); }
if (isset($h->bcc))      { $bcc = buildAddressString($h->bcc, 'yellow'); }
if (isset($h->reply_to)) { $rep = buildAddressString($h->reply_to, 'blue'); }
if ((isset($h->subject)) && (strlen($h->subject) != 0)) {
  $sub = htmlspecialchars(decode_mime_string(chop($h->subject)));
} else {
  $sub = $lang->no_subject;
}

$msg_index = $array_index + 1;
$num_msgs = imap_num_msg($imp->stream);

$title = "$imp->label: $sub";
$sidebar = false;
require "$default->include_dir/generic-header.inc";

$prev_index = $array_index - 1;
$next_index = $array_index + 1;

if (isset($sorted[$prev_index])) $prev = $sorted[$prev_index];
else $prev = -1;

if (isset($sorted[$next_index])) $next = $sorted[$next_index];
else $next = -1;

if ($msg_index != count($sorted)) {
   $del_target = 'message.php3';
   $del_ident  = 'index';
} else {
   $del_target = 'mailbox.php3';
   $del_ident  = 'indices';
}

if (!$default->minimum_popups && !$this_client->rather_not_popup) {
  include './lib/js/open_compose_win.js';
}
require './lib/js/open_contacts.js';
require "$default->include_dir/message/navbar_aux_top.inc";
require "$default->include_dir/message/navbar.inc";
require "$default->include_dir/message/headers.inc";
require "$default->include_dir/message/message.inc";
require "$default->include_dir/message/navbar.inc";
require "$default->include_dir/message/navbar_aux_bottom.inc";
require "$default->include_dir/message/javascript.inc";

if (isset($status_string)) {
  status($status_string, $status_color);
}

require "$default->include_dir/generic-footer.inc";
?>
