<?php

/*
  
  File: contacts.php3
  $Author: chuck $
  $Revision: 2.8.2.12 $
  $Date: 2000/05/25 04:03:26 $
  
  IMP: Copyright 1999, 2000 Charles J. Hagenbuch <chuck@horde.org>
  
  You should have received a copy of the GNU Public
  License along with this package; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.
  
*/


$need_horde_db = 1;
require '../lib/horde.lib';
require './lib/imp.lib';              /* IMPlib is the IMP function library  */
require '../config/horde.php3';
require './config/defaults.php3';     /* Defaults Configuration File */
if ($default->use_ldap_search) include './config/ldap.php3';
require './config/html.php3';
$language = select_lang();
require './lib/postconf.php3';
require "./locale/$language/contacts.lang";
require './locale/local/contacts.lang';
$help_file = 'contacts.help';
require "./locale/defines/$help_file";
/* Setup the this_client object */
$this_client = new WebClient;

error_reporting($default->error_level);  /* set error level from imp.lib   */

/* retrieve authentication information from session */
page_open(array('sess' => 'HordeSession'));
page_close();
if (!isset($imp) || !is_object($imp)) { echo '<script language="JavaScript">window.close()</script>'; exit; }
$imp->unpickle();
/* proceed only with a valid login */

/* doctype */
require "$default->include_dir/doctype.inc";


/* Run through the action handlers */
if (isset($actionID)) {
	if (strcspn($actionID, '0123456789')) { $actionID = $actions[$actionID]; }
	
	switch($actionID) {
    case NO_ACTION:
		break;
 
    case DELETE_ADDR:
		if ($new_address) {
			if (!(imp_delete_address($new_address, $imp->user, $imp->server))) {
				$errormsg = $lang->error_delete_address;
			}
		}
		$new_address = '';
		break;
		
    case ADD_CONTACT:
		if ($imp && $index && $bodypart) {
			$imp->authenticate();
			$h = imap_header($imp->stream, imap_msgno($imp->stream, $index));
			if (isset($h->reply_toaddress)) { $new_address = chop(htmlspecialchars($h->reply_toaddress)); }
			elseif (isset($h->fromaddress)) { $new_address = chop(htmlspecialchars($h->fromaddress )); }
			else $new_address = '';
		}
		break;
		
    case ADD_ADDR:
		if (!empty($new_address) && !empty($new_nickname) && !empty($new_fullname)) {
			// escape/quote special characters as necessary
			$nickname = addslashes($new_nickname);
			$clean_nickname = imap_rfc822_write_address('', '', $nickname);
			$clean_nickname = substr($clean_nickname, 0, strlen($clean_nickname)-4);
			$fullname = addslashes($new_fullname);
			$clean_fullname = imap_rfc822_write_address('', '', $fullname);
			$clean_fullname = substr($clean_fullname, 0, strlen($clean_fullname)-4);
			$clean_address = addslashes($new_address);
			
			$errormsg = '';
			if ($clean_address != $new_address)   $errormsg .= $lang->error_address_chars;
			if (!(imp_add_address($clean_address, $clean_nickname, $clean_fullname, $imp->user, $imp->server))) {
				$errormsg .= $lang->error_create_address;
			}
		}
		$new_address = '';
		break;
      
    case UPDATE_ADDR:
		if ($old_address && $new_address && $new_nickname && $new_fullname) {
			if (!(imp_update_address($old_address, $new_address, $new_nickname, $new_fullname, $imp->user, $imp->server))) {
				$errormsg = $lang->error_update_address;
			}
		}
		$new_address = '';
		break;
	}
}


$title = $lang->addressbook_title;
$sidebar = false;
require("$default->include_dir/contacts/header.inc");

if (!isset($new_address)) { $new_address = ''; }


$addresses = imp_get_addresses($imp->user, $imp->server);

$options = '';
if (isset($addresses) && is_array($addresses)) {
	for ($i = 0; $i < count($addresses); $i++) {
		if (is_array($addresses[$i]) && sizeof($addresses[$i] > 1)) {
			$options .= '    <option value="' . $addresses[$i][0] . '">' . $addresses[$i][1] . ' &lt;' . $addresses[$i][0] . "&gt;\n";
		}
	}
}

if ($default->use_db) {
	if ($default->user_use_addressbook == true) {
		require("$default->include_dir/contacts/addr-php3.inc");
		if ($default->use_ldap_search) {
			require("$default->include_dir/contacts/ldap-php3.inc");
		}
	} else {
		if ($default->use_ldap_search) {
			require("$default->include_dir/contacts/ldap-php3.inc");
		}
	}
} else {
	if ($default->use_ldap_search) {
		require("$default->include_dir/contacts/ldap-php3.inc");
	}
}

require "$default->include_dir/generic-footer.inc";
require "$default->include_dir/contacts/javascript.inc";

?>
