<?php
/*
  
  File: view.php3
  $Author: chuck $
  $Revision: 2.8.2.11 $
  $Date: 2000/02/05 17:21:28 $
  
  IMP: Copyright 1998, 1999, 2000 Charles J. Hagenbuch <chuck@horde.org>
  
  You should have received a copy of the GNU Public
  License along with this package; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.
  
*/

$need_horde_db = 0;
$db_lib_loaded = 0;
if (!defined("HORDE_LIB")) include '../lib/horde.lib';
require './lib/imp.lib';           /* IMPlib is the IMP function library  */
require './lib/mimetypes.lib';     /* Mime functions */
require './config/defaults.php3';  /* Defaults configuration file */
require './config/html.php3';
require './config/mime.php3';

$language = select_lang();
$lang = new HordeLocaleLang();
$this_client = new WebClient;

error_reporting($default->error_level);  /* set error level from imp.lib   */
set_time_limit($default->max_execution_time);

if ($this_client->workaround_broken_ie_download) {
  page_open(array('sess' => 'HordeSessionCached'));
} else {
  page_open(array('sess' => 'HordeSession'));
}
  
page_close();
if (!isset($imp) || !is_object($imp)) header("Location: login.php3?reason=logout");
$imp->unpickle();
$imp->authenticate();

$structure = imap_fetchstructure($imp->stream, $index, FT_UID);
$attachments = MimeParseStructure($structure);
if (!isset($actionID)) $actionID = NO_ACTION;
if (($actionID != SAVE_MESSAGE) && ($actionID != VIEW_SOURCE)) {
  $mime = $attachments[$bodypart];
  mimeParse($mime);
}

/* Run through action handlers */
switch ($actionID) {
 case NO_ACTION:
   break;
   
 case DOWNLOAD_ATTACH:
   header('Content-Disposition: attachment; filename="' . $mime->name . '"');
   header('Content-Type: application/RFC822');    /* This should force a save file dialog...  */
   break;
   
 case VIEW_ATTACH:
   header("Content-Disposition: inline; filename=$mime->name");
   if (isset($mime->conf['view_function'])) {
     header('Content-Type: text/html');
     $title = 'MIME Attachment View';
     include "$default->include_dir/generic-header.inc";
     $func = $mime->conf['view_function'];
     echo $func($mime);
     include "$default->include_dir/generic-footer.inc";
     exit;
   }
   
   if ($mime->TYPE == 'image') {
     header("Content-Type: image/$mime->SUBTYPE");
   } else {
     // FIXME: this is wrong - need to catch other things first (audio, video, etc)
     header('Content-Type: text/plain');
   }
   header('Content-Disposition: inline; filename="' . $mime->name . '"');
   break;
   
 case VIEW_SOURCE:
   $msg = imap_fetchheader($imp->stream, $index, FT_UID) . "\n" . imap_body($imp->stream, $index, FT_UID);
   header('Content-Type: text/plain');
   header('Content-Disposition: inline; filename="Message Source"');
   header('Content-Length: ' . strlen($msg));
   echo $msg;
   exit; 
   break;
   
 case SAVE_MESSAGE:
   $h = imap_header($imp->stream, imap_msgno($imp->stream, $index));
   if (!empty($h->subject))
     $name = preg_replace('|\W|', '_', trim(decode_mime_string($h->subject)));
   else
     $name = 'message';
   
   $from = trim(decode_mime_string(isset($h->fromaddress) ? $h->fromaddress : ''));
   $body  = 'From ' . $from . "\n";
   $body .= imap_fetchheader($imp->stream, $index, FT_PREFETCHTEXT | FT_UID);
   $body .= imap_body ($imp->stream, $index, FT_UID);
   
   header('Content-Disposition: attachment; filename="' . $name . '"');
   header('Content-Type: application/RFC822');
   break;
}

if ($actionID != SAVE_MESSAGE) {
  $body = imap_fetchbody($imp->stream, $index, $bodypart, FT_UID);
  
  if ($mime->encoding == ENCBASE64)
    $body = imap_base64($body);
  else if ($mime->encoding == ENCQUOTEDPRINTABLE && ($qprint_msg = imap_qprint($body)))
    $body = $qprint_msg;
}

header('Content-Length: ' . strlen($body));
echo $body;

?>
