#!/usr/bin/perl
#
# Copyright 1999 Jason Orcutt
# Copyright 1999 Ivan E. Moore II 
# Original work by Jason
# Ivan just finished it up
#

# Unbuffer the output
$| = 1;

$DEBIAN = 'false';

if (-s "/etc/imp") {
  $DEBIAN = 'true';
} else {
  $DEBIAN = 'false';
}
local( $IMP_SETUP_VER )        = '2.0';

# Hash keys of configuration file info 
local( %CONFIG_INFO, %IMAPServers );


# Autodetect some of the options.
$CONFIG_INFO{ 'SERVER_NAME' }         = autodetect_hostname();
if ($DEBIAN eq "true") {
  $CONFIG_INFO{ 'INSTALLED_PATH' }      = '/usr/share/horde/imp';
  $CONFIG_INFO{ 'INSTALLED_HORDE_PATH' }      = '/usr/share/horde';
  $etc = "/etc/imp";
  $scripts = '/usr/share/doc/imp/examples';
} else {
  $CONFIG_INFO{ 'INSTALLED_PATH' }      = autodetect_installed_path();
  $CONFIG_INFO{ 'INSTALLED_HORDE_PATH' }      = autodetect_installed_horde_path();
  $etc = "$CONFIG_INFO{ 'INSTALLED_PATH' }/config";
  $scripts = "$CONFIG_INFO{ 'INSTALLED_PATH' }/config/scripts";
}
$CONFIG_INFO{ 'SERVER_HOSTNAME' }  = autodetect_hostname();
$CONFIG_INFO{ 'SERVER_FROM' } = $CONFIG_INFO{ 'SERVER_HOSTNAME' };
$CONFIG_INFO{ 'LANGUAGE' } = 'en';
$CONFIG_INFO{ 'LANGUAGE_FULL' } = 'English';
$CONFIG_INFO{ 'SENDMAIL' } = '/usr/sbin/sendmail';
$CONFIG_INFO{ 'ISPELL' } = '/usr/bin/ispell';
$CONFIG_INFO{ 'MSWORDVIEW' } = '/usr/bin/mswordview';
$CONFIG_INFO{ 'MSWORD_FLAGS' } = '-n';
$CONFIG_INFO{ 'TAR' } = '/bin/tar';

$CONFIG_INFO{ 'SERVER_PORT' } = 143;
$CONFIG_INFO{ 'FOLDERS' } = 'mail/';
$CONFIG_INFO{ 'CHANGE_FOLDER' } = 'true';
$CONFIG_INFO{ 'IMAP_SUBSCRIBE' } = 'true';
$CONFIG_INFO{ 'CHANGE_SERVER' } = 'true';
$CONFIG_INFO{ 'CHANGE_FROM' } = 'true';
$CONFIG_INFO{ 'CHANGE_FULLNAME' } = 'true';
$CONFIG_INFO{ 'USE_ADDRESSBOOK' } = 'true';
$CONFIG_INFO{ 'NEWMAIL_POPUP' } = 'true';
$CONFIG_INFO{ 'TRAILER' } = 'true';
$CONFIG_INFO{ 'LDAP_SEARCH' } = 'false';
$CONFIG_INFO{ 'USE_DB' } = 'true';
  if (-s "/usr/bin/mysql") {
      $CONFIG_INFO{ 'DB_TYPE' } = 'mysql';
      $CONFIG_INFO{ 'DB_WHERE' } = '/usr/bin/mysql';
      $CONFIG_INFO{ 'DB_OWNER' } = 'root';
      $CONFIG_INFO{ 'DB_OWNER_PASS' } = 'none';
      $CONFIG_INFO{ 'DB_OWNER_PASSWORD' } = 'not set';
      $CONFIG_INFO{ 'DB_USERNAME' } = 'hordemgr';
      $CONFIG_INFO{ 'DB_PASSWORD' } = 'hordemgr';
  } else {
    if (-s "/usr/local/bin/mysql") {
       $CONFIG_INFO{ 'DB_TYPE' } = 'mysql';
       $CONFIG_INFO{ 'DB_WHERE' } = '/usr/local/bin/mysql';
       $CONFIG_INFO{ 'DB_OWNER' } = 'root';
       $CONFIG_INFO{ 'DB_OWNER_PASS' } = 'none';
       $CONFIG_INFO{ 'DB_OWNER_PASSWORD' } = 'not set';
       $CONFIG_INFO{ 'DB_USERNAME' } = 'hordemgr';
       $CONFIG_INFO{ 'DB_PASSWORD' } = 'hordemgr';
    } else {
        if (-s "/usr/bin/psql") {
          $CONFIG_INFO{ 'DB_TYPE' } = 'postgres';
          if ($DEBIAN eq "true") {
            $CONFIG_INFO{ 'DB_USERNAME' } = 'hordemgr';
            $CONFIG_INFO{ 'DB_PASSWORD' } = '';
          } else {
            $CONFIG_INFO{ 'DB_USERNAME' } = 'hordemgr';
            $CONFIG_INFO{ 'DB_PASSWORD' } = '';
          }
          $CONFIG_INFO{ 'DB_WHERE' } = '/usr/bin/psql';
          $CONFIG_INFO{ 'DB_OWNER' } = 'postgres';
          $CONFIG_INFO{ 'DB_OWNER_PASS' } = 'none';
          $CONFIG_INFO{ 'DB_OWNER_PASSWORD' } = 'not set';
        } else {
          if (-s "/usr/local/bin/psql") {
            $CONFIG_INFO{ 'DB_TYPE' } = 'postgres';
            if ($DEBIAN eq "true") {
              $CONFIG_INFO{ 'DB_USERNAME' } = 'hordemgr';
              $CONFIG_INFO{ 'DB_PASSWORD' } = '';
            } else {
              $CONFIG_INFO{ 'DB_USERNAME' } = 'nobody';
              $CONFIG_INFO{ 'DB_PASSWORD' } = '';
            }
            $CONFIG_INFO{ 'DB_WHERE' } = '/usr/local/bin/psql';
            $CONFIG_INFO{ 'DB_OWNER' } = 'hordemgr';
            $CONFIG_INFO{ 'DB_OWNER_PASS' } = 'none';
            $CONFIG_INFO{ 'DB_OWNER_PASSWORD' } = 'not set';
          } else {
            $CONFIG_INFO{ 'DB_TYPE' } = 'dummy';
            $CONFIG_INFO{ 'DB_WHERE' } = '';
            $CONFIG_INFO{ 'DB_OWNER' } = '';
            $CONFIG_INFO{ 'DB_OWNER_PASS' } = '';
            $CONFIG_INFO{ 'DB_OWNER_PASSWORD' } = '';
            $CONFIG_INFO{ 'DB_USERNAME' } = 'hordemgr';
            $CONFIG_INFO{ 'DB_PASSWORD' } = 'hordemgr';
          }
        }
  } 

  }

$db_where = $CONFIG_INFO{ 'DB_WHERE' };
$db_owner = $CONFIG_INFO{ 'DB_OWNER' };
$db_pass = $CONFIG_INFO{ 'DB_OWNER_PASS' };
$CONFIG_INFO{ 'DB_NAME' } = 'horde';
$CONFIG_INFO{ 'DB_SERVER' } = 'localhost';
$CONFIG_INFO{ 'DB_PORT' } = '';
$CONFIG_INFO{ 'ROOT_URL' } = '/imp';
$CONFIG_INFO{ 'DB_BUILT' } = 'not built';

# Mainline logic
create_config();
exit();

#### - Library of functions - ####

sub autodetect_hostname {
   local $hostname;
   if ($DEBIAN eq "true") {
     chomp( $hostname = `hostname --fqdn` );
   } else {
     chomp( $hostname = `hostname` );
   }
   return $hostname;
}

sub autodetect_installed_path {
   local $mypath, @temp;
   chomp( $mypath = `pwd` ); 
   # Peel the contrib off of the path
   @temp = split( '/', $mypath ); pop( @temp );
   $mypath = join( '/', @temp );
   @temp = split( '/', $mypath ); pop( @temp );
   $mypath = join( '/', @temp );
   return $mypath;
}
 
sub autodetect_installed_horde_path {
   local $mypath, @temp;
   chomp( $mypath = `pwd` );
   # Peel the contrib off of the path
   @temp = split( '/', $mypath ); pop( @temp );
   $mypath = join( '/', @temp );
   @temp = split( '/', $mypath ); pop( @temp );
   $mypath = join( '/', @temp );
   @temp = split( '/', $mypath ); pop( @temp );
   $mypath = join( '/', @temp );
   return $mypath;
}


sub config_title_bar {
   local $sub_menu = shift;
   print 'IMP Setup - Version : ' . $IMP_SETUP_VER . ' Configuration Menu.' . "\n";
   if ( $sub_menu ) { print $sub_menu . "\n"; }
   print '-' x 50 . "\n\n";
}

sub menu_option {
   local $opt_num       = shift;
   local $text          = shift;
   print ' ' . $opt_num . ') ' . $text . "\n";
}

sub command_prompt {
   local $prompt        = shift;
   local $command;
   if ( ! $prompt ) {
         print "\n\n" . 'Command : ';
   } else {
         print "\n\n" . $prompt;
   }
   $command = <STDIN>;
   $command =~ s/\n//g;
   $command =~ s/\r//g;
   return $command;
}

sub set_value {
   local $prompt        = shift;
   local $input_val     = shift;
   local $help_text     = shift;
   local $temp, $new_val;
   local $prompt_out;
   if ( $help_text ne '' ) {
      $prompt_out = $prompt . ' [ ' . $$input_val . ' ] ' . "\n" . $help_text . "\n: ";
   } else {
      $prompt_out = $prompt . ' [ ' . $$input_val . ' ] : ';
   }
   $temp = command_prompt( $prompt_out );
   if ( $temp ) {
      $$input_val = $temp;
      return $$input_val;
   } else {
      return $$input_val;
   }
}

sub build_db {

     if ($CONFIG_INFO{ 'DB_TYPE' } =~ 'postgres') {

       $com1 = "$db_where -d imp -c '\\dt'";
       $com2 = 'su - '; 
       $com4 = ' -c "';
       $com3 = '" | grep imp_addr > /tmp/imptemp.txt';
       system("$com2$db_owner$com4$com1$com3");
       $main::imptemp = `cat /tmp/imptemp.txt`;
       if (! ($imptemp = ~ m/.*imp_addr*/m))
       {
         print "Attempting to auto-config PostgreSQL for you...\n";
         system("su - $db_owner -c '$db_where template1 < $scripts/pgsql_create.sql'");
       } else {
       print "Postgres seems to be already configured\n";
       }
     system("rm /tmp/imptemp.txt >>/dev/null 2>&1");
     }

     if ($CONFIG_INFO{ 'DB_TYPE' } =~ 'mysql') {
       print "Attempting to auto-config MySQL for you...\n";
       if ($CONFIG_INFO{ 'DB_OWNER_PASS' } eq "none") {
         system("$db_where < $scripts/mysql_create.sql ");
      } else {
system("$db_where --password=$db_pass < $scripts/mysql_create.sql ");
       }
     }
    $CONFIG_INFO{ 'DB_BUILT' } = 'built';
    print "\n\nDone...hopefully it worked..if not you will have to
do it yourself...if you can help with getting this to work for
everyone please let us know.
";
    if ($DEBIAN eq "true") {
        if ($CONFIG_INFO{ 'DB_TYPE' } =~ 'postgres') {
         system("/etc/init.d/postgres restart >> /dev/null 2>&1");
      } else {
        if ($CONFIG_INFO{ 'DB_TYPE' } =~ 'mysql') {
         system("/etc/init.d/mysql restart >> /dev/null 2>&1");
        }
      }
    }
    system("sleep 10");
}

sub write_config {

## converting certan items to make sure..this will change later ##


    &setfile('defaults.php3',
'<?php',
"

/* the session file (dbm file) */
\$default->session_file = './lib/sessions';

/* For debugging purposes */
\$default->error_level               = 15;

/* The longest that things like file uploads and slow functions should be
 * allowed to run. 0 means run until termination (forever if infinite loop).
 * NOTE: you can't set this to 0 if safe_mode is on. */
\$default->max_execution_time        = 0;

/* Server Specific Configuration */
\$default->localhost                 = \'$CONFIG_INFO{ 'SERVER_NAME' }\';

/* Imap Server Default */
\$default->server                    = \'$CONFIG_INFO{ 'SERVER_HOSTNAME' }\';
\$default->from_server               = \'$CONFIG_INFO{ 'SERVER_FROM' }\';
\$default->port                      = $CONFIG_INFO{ 'SERVER_PORT' };
\$default->servtype                  = 'imap';

/* Web server configuration */
\$default->root_url                  = '$CONFIG_INFO{ 'ROOT_URL' }';
\$default->include_dir               = './templates';
\$default->graphics_url              = \$default->root_url . '/graphics';

/* Folder configuration */
\$default->folders                   = '$CONFIG_INFO{ 'FOLDERS' }';
\$default->use_imap_subscribe        = $CONFIG_INFO{ 'IMAP_SUBSCRIBE' };
\$default->show_dotfiles             = false;
\$default->sent_mail                 = 'sent-mail';
\$default->save_sent_mail            = true;
\$default->postponed                 = 'postponed-msgs';

/* Ldap searching */
\$default->use_ldap_search           = $CONFIG_INFO{ 'LDAP_SEARCH' };

/* user is presented with an list of available imap servers */
\$default->use_server_list           = false;

/* User changable items */
\$default->user_change_server        = $CONFIG_INFO{ 'CHANGE_SERVER' };
\$default->user_change_port          = true;
\$default->user_change_servtype      = true;
\$default->user_change_folder        = $CONFIG_INFO{ 'CHANGE_FOLDER' };
\$default->user_change_from          = $CONFIG_INFO{ 'CHANGE_FROM' };
\$default->user_change_fullname      = $CONFIG_INFO{ 'CHANGE_FULLNAME' };
\$default->user_use_addressbook      = $CONFIG_INFO{ 'USE_ADDRESSBOOK' };
\$default->user_use_folders          = true;

/* New mail configuration */
/* Refresh between check for new mail */
\$default->refresh_delay                  = 300;
\$default->newmail_popup                  = $CONFIG_INFO{ 'NEWMAIL_POPUP' };

/* Cookie configuration */
\$default->session_enabled           = false;
\$default->session_timeout           = 300;
\$default->cookie_timeout            = 10000;

/* Path to sendmail */
\$default->path_to_sendmail          = '$CONFIG_INFO{ 'SENDMAIL' }';

/* Ispell setup */
\$default->path_to_ispell            = '$CONFIG_INFO{ 'ISPELL' }';

/* Mswordview setup */
\$default->path_to_mswordview        = '$CONFIG_INFO{ 'MSWORDVIEW' } $CONFIG_INFO{ 'MSWORD_FLAGS' }';

/* path to tar so that tarballs can be listed */
\$default->path_to_tar               = '$CONFIG_INFO{ 'TAR' }';

/* SSL Configuration block */
\$default->secure                    = true;

/* Cyrus configuration block */
\$default->personal_folders          = '';
// cyrus configs may look like this:
// \$default->personal_folders       = 'INBOX.';

/* Default Language */
\$default->language                  = '$CONFIG_INFO{ 'LANGUAGE' }';

\$default->append_header             = true;
\$default->append_trailer            = $CONFIG_INFO{ 'TRAILER' };

\$default->text_parts_inline         = true;

/* database config */
\$default->use_db                    = $CONFIG_INFO{ 'USE_DB' };
\$default->db_user_name              = '$CONFIG_INFO{ 'DB_USERNAME' }';
\$default->db_password               = '$CONFIG_INFO{ 'DB_PASSWORD' }';
\$default->db_name                   = '$CONFIG_INFO{ 'DB_NAME' }';
\$default->db_server_name            = '$CONFIG_INFO{ 'DB_SERVER' }';
\$default->db_pref_table             = 'imp_pref';
\$default->db_address_table          = 'imp_addr';
\$default->db_connect_string         = '';
\$default->db_server_port            = '$CONFIG_INFO{ 'DB_PORT' }';
\$default->db_server_options         = '';
\$default->db_server_tty             = '';

?>
"); 

for $f (@files) {
    open(N,">$etc/$f.postinstnew") || die "Error creating $etc/$f.postinstnew: $!\n";
    print(N $filecontents{$f}) || die "Error writing $etc/$f.postinstnew: $!\n";
    close(N) || die "Error closing $etc/$f.postinstnew: $!\n";
}

while (defined($f= pop(@files))) {
    rename("$etc/$f.postinstnew","$etc/$f") || die "Error installing $etc/$f: $!\n";
}


while (defined($f= pop(@files))) {
    rename("$etc/$f.postinstnew","$etc/$f") || die "Error installing $etc/$f: $!\n";
}

  if ($DEBIAN eq "true") {
    system("chown -R www-data.root $etc >> /dev/null 2>&1");
  }
  system("chmod 555 $etc/defaults.php3");
  if ($CONFIG_INFO{ 'USE_DB' } eq "true") {
    $buildopts = "--with-$CONFIG_INFO{ 'DB_TYPE' }";
  } else {
    $buildopts = '';
  }
 
  system("cd $CONFIG_INFO{ 'INSTALLED_HORDE_PATH' }/lib/src ; ./buildlib.pl $buildopts >> /dev/null 2>&1");
  system("cd $CONFIG_INFO{ 'INSTALLED_PATH' }/lib/src ; ./buildlib.pl $buildopts >> /dev/null 2>&1");

  system("chmod 000 $CONFIG_INFO{ 'INSTALLED_PATH' }/setup.php3 >> /dev/null 2>&1");
  system("chmod 555 $CONFIG_INFO{ 'INSTALLED_PATH' }/lib/*.lib >> /dev/null 2>&1");

}

sub setfile {
    local ($filename,$value1,$value2,$d) = @_;
    chop($d=`date`);
    $v=
"$value1\
$value2";
    push(@files,$filename);
    $filecontents{$filename}=$v;
}

sub reswarn {
    print STDERR "$_[0]\n";
    return 0;
}


sub create_config {
   local( $command );

   for( ;; ) { #Inifinity loop watch out.
   clear_screen();
   config_title_bar();
   menu_option( '1', 'Required    Options' );
   menu_option( '2', 'IMAP Server Options' );
   menu_option( '3', 'Database    Options' );
   menu_option( '4', 'Other       Options' );
print "\n";
   menu_option( '9', 'Exit without writing configuration.' );
   menu_option( '0', 'Exit and save configuration.' );
   $command = command_prompt();
   if ( $command eq '0' ) { write_config();        exit();  }
   if ( $command eq '1' ) { required_options();             }
   if ( $command eq '2' ) { imap_servers();                 }
   if ( $command eq '3' ) { database_options();             }
   if ( $command eq '4' ) { other_options();                }
   if ( $command eq '9' ) { exit();}
   }

}

sub imap_servers () {
   local $command;
   clear_screen();

   config_title_bar( 'IMAP Server Configuration.' );

print "Current IMAP Server Settings:
=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

          IMAP Server   :  $CONFIG_INFO{ 'SERVER_HOSTNAME' }
          IMAP Port     :  $CONFIG_INFO{ 'SERVER_PORT' }
          Folders Root  :  $CONFIG_INFO{ 'FOLDERS' }


";

print "
 1) Change Settings \n";

   menu_option( '0', 'Back to main menu.' );
   $command = command_prompt();
   if ( $command eq '0' ) { return; }
   if ( $command eq '1' ) {

   set_value( 'Server Hostname',             \$CONFIG_INFO{ 'SERVER_HOSTNAME' },
      'The dns or ip for the IMAP server i.e. 127.0.0.1 or localhost or 172.101.01.100'
   );
   set_value( 'Server_port',                 \$CONFIG_INFO{ 'SERVER_PORT' },
      'The imap port to connect to on the server. i.e. 143'
   );
   set_value( 'IMAP folder root',            \$CONFIG_INFO{ 'FOLDERS' },
      '"Folders" is where your mail folders live relatvie to your home directory.' . "\n" .
      'If your mail folders are in $HOME/Mail, then all you need to enter is Mail/.' . "\n" .
      '(remember that unix is case-sensitive).');
  imap_servers();
 }
}

sub required_options {
   local $command;
   clear_screen();
   config_title_bar( 'Required Options.' );
   menu_option( '1', 'Local Server Name   : '        . $CONFIG_INFO{ 'SERVER_NAME' } );
   menu_option( '2', 'Installed Path      : '        . $CONFIG_INFO{ 'INSTALLED_PATH' } );
   menu_option( '3', 'IMP Root URL        : '        . $CONFIG_INFO{ 'ROOT_URL' } );

   menu_option( '4', 'From Server         : '        . $CONFIG_INFO{ 'SERVER_FROM' } );
   menu_option( '5', 'Default Language    : '        . $CONFIG_INFO{ 'LANGUAGE_FULL' } );
   menu_option( '6', 'Path To sendmail    : '        . $CONFIG_INFO{ 'SENDMAIL' } );
   menu_option( '7', 'Path To ispell      : '        . $CONFIG_INFO{ 'ISPELL' } );
   menu_option( '8', 'Path To mswordview  : '        . $CONFIG_INFO{ 'MSWORDVIEW' } );
   menu_option( '9', 'mswordview Flags    : '        . $CONFIG_INFO{ 'MSWORD_FLAGS' } );
   menu_option( 'a', 'Path To tar         : '        . $CONFIG_INFO{ 'TAR' } );



   menu_option( '0', 'Back to main menu.' );
   $command = command_prompt();

   if ( $command eq '0' ) { return; }
   if ( $command eq '1' ) {
      set_value( 'Server Name',    \$CONFIG_INFO{ 'SERVER_NAME' }, 'The actual server name for this machine.'  );
   }
   if ( $command eq '2' ) {
      set_value( 'Installed Path',  \$CONFIG_INFO{ 'INSTALLED_PATH' }, 'Where is IMP located?  eg.. /home/httpd/horde/imp' );
      if ($DEBIAN eq "false") {
        $etc = "$CONFIG_INFO{ 'INSTALLED_PATH' }/config";
      }
   }
   if ( $command eq '3' ) {
      set_value( 'IMP Root URL',  \$CONFIG_INFO{ 'ROOT_URL' }, 'Where is IMP located in the web tree?  eg.. /imp' );
   }
   if ( $command eq '4' ) {
     set_value( 'From Server',    \$CONFIG_INFO{ 'SERVER_FROM' }, 'Where Mail Appears From.'  );
   }
   if ( $command eq '5' ) {
     print "\n\nAvailable Languages:\n\n
   1) Czech
   2) Danish
   3) German
   4) English
   5) Spanish
   6) French
   7) Dutch
   8) Belgium Dutch
   9) Norwegian
   a) Brazilian Portuguese
   b) Russian
   c) Slovak
   d) Swedish
\nPlease Select the corrosponding number:\n";

     set_value( 'Default Language',    \$language, 'What do you want the default language to be?'  );

     if ($language eq '1') {
       $CONFIG_INFO{ 'LANGUAGE' } = 'cs';
       $CONFIG_INFO{ 'LANGUAGE_FULL' } = 'Czech';
     }
     if ($language eq '2') {
       $CONFIG_INFO{ 'LANGUAGE' } = 'da';
       $CONFIG_INFO{ 'LANGUAGE_FULL' } = 'Danish';
     }
     if ($language eq '3') {
       $CONFIG_INFO{ 'LANGUAGE' } = 'de';
       $CONFIG_INFO{ 'LANGUAGE_FULL' } = 'German';
     }
     if ($language eq '4') {
       $CONFIG_INFO{ 'LANGUAGE' } = 'en';
       $CONFIG_INFO{ 'LANGUAGE_FULL' } = 'English';
     }
     if ($language eq '5') {
       $CONFIG_INFO{ 'LANGUAGE' } = 'es';
       $CONFIG_INFO{ 'LANGUAGE_FULL' } = 'Spanish';
     }
     if ($language eq '6') {
       $CONFIG_INFO{ 'LANGUAGE' } = 'fr';
       $CONFIG_INFO{ 'LANGUAGE_FULL' } = 'French';
     }
     if ($language eq '7') {
       $CONFIG_INFO{ 'LANGUAGE' } = 'nl';
       $CONFIG_INFO{ 'LANGUAGE_FULL' } = 'Dutch';
     }
     if ($language eq '8') {
       $CONFIG_INFO{ 'LANGUAGE' } = 'nl-BE';
       $CONFIG_INFO{ 'LANGUAGE_FULL' } = 'Belgium Dutch';
     }
     if ($language eq '9') {
       $CONFIG_INFO{ 'LANGUAGE' } = 'no';
       $CONFIG_INFO{ 'LANGUAGE_FULL' } = 'Norwegian';
     }
     if ($language eq 'a') {
       $CONFIG_INFO{ 'LANGUAGE' } = 'pt-BR';
       $CONFIG_INFO{ 'LANGUAGE_FULL' } = 'Brazilian Portuguese';
     }
     if ($language eq 'b') {
       $CONFIG_INFO{ 'LANGUAGE' } = 'ru';
       $CONFIG_INFO{ 'LANGUAGE_FULL' } = 'Russian';
     }
     if ($language eq 'c') {
       $CONFIG_INFO{ 'LANGUAGE' } = 'sk';
       $CONFIG_INFO{ 'LANGUAGE_FULL' } = 'Slovak';
     }       
     if ($language eq 'd') {
       $CONFIG_INFO{ 'LANGUAGE' } = 'sv';
       $CONFIG_INFO{ 'LANGUAGE_FULL' } = 'Swedish';
     }



   }
   if ( $command eq '6' ) {
     set_value( 'Path To sendmail',    \$CONFIG_INFO{ 'SENDMAIL' }, 'What is the path to sendmail?'  );
   }
   if ( $command eq '7' ) {
     set_value( 'Path To ispell',    \$CONFIG_INFO{ 'ISPELL' }, 'What is the path to ispell?'  );
   }
   if ( $command eq '8' ) {
     set_value( 'Path To mswordview',    \$CONFIG_INFO{ 'MSWORDVIEW' }, 'What is the path to mswordview?'  );
   }
   if ( $command eq '9' ) {
     set_value( 'mswordview Flags',    \$CONFIG_INFO{ 'MSWORD_FLAGS' }, 'What flags do we need to pass to mswordview for your system?'  );
   }
   if ( $command eq 'a' ) {
     set_value( 'Path To tar',    \$CONFIG_INFO{ 'TAR' }, 'What is the path to tar?'  );
   }

   required_options();

}

sub database_options {
   local $command;
   clear_screen();
   config_title_bar( 'Database Options.' );
   menu_option( '1', 'Use a Database      : '        . $CONFIG_INFO{ 'USE_DB' } );
   menu_option( '2', 'Database Username   : '        . $CONFIG_INFO{ 'DB_USERNAME' } );
   menu_option( '3', 'Database Password   : '        . $CONFIG_INFO{ 'DB_PASSWORD' } );
   menu_option( '4', 'Database Name       : '        . $CONFIG_INFO{ 'DB_NAME' } );
   menu_option( '5', 'Database Server     : '        . $CONFIG_INFO{ 'DB_SERVER' } );
   menu_option( '6', 'Database Port       : '        . $CONFIG_INFO{ 'DB_PORT' } );
   menu_option( '7', 'Database Type       : '        . $CONFIG_INFO{ 'DB_TYPE' } );
   menu_option( '8', 'Location of DB      : '        . $CONFIG_INFO{ 'DB_WHERE' } );
   menu_option( '9', 'Database Owner      : '        . $CONFIG_INFO{ 'DB_OWNER' } );
   menu_option( 'a', 'Database Owner Pass : '        . $CONFIG_INFO{ 'DB_OWNER_PASSWORD' } );
   menu_option( 'b', 'Build IMP Database  : '        . $CONFIG_INFO{ 'DB_BUILT' } );
print "\n";
   menu_option( '0', 'Back to main menu.' );
   $command = command_prompt();

   if ( $command eq '0' ) { return; }
   if ( $command eq 'b' ) { build_db(); }
   if ( $command eq '1' ) {
      set_value( 'Use Database',    \$use_db, 'Do you wish to use a database?'  );
      if (($use_db =~ 'y') || ($use_db =~ 'yes') || ($use_db =~ 'Y') || ($use_db =~ 'YES') || ($use_db =~ 'true') || ($use_db =~ 'TRUE')) {      
            $CONFIG_INFO{ 'USE_DB' } = "true";
      } else {
            $CONFIG_INFO{ 'USE_DB' } = "false";
      }

   }
   if ( $command eq '2' ) {
      set_value( 'Database Username',  \$CONFIG_INFO{ 'DB_USERNAME' }, 'What is the name of your database username?  eg.. impmgr, nobody, www-data' );
   }
   if ( $command eq '3' ) {
      set_value( 'Database Password',  \$CONFIG_INFO{ 'DB_PASSWORD' }, 'What is the password your database requires?' );
   }
   if ( $command eq '4' ) {
      set_value( 'Database Name',  \$CONFIG_INFO{ 'DB_NAME' }, 'What is the name of the database that contains the IMP tables?..default is imp.' );  
   }
   if ( $command eq '5' ) {
      set_value( 'Database Server',  \$CONFIG_INFO{ 'DB_SERVER' }, 'What is the name of the database server? ' );  
   }
   if ( $command eq '6' ) {
      set_value( 'Database Port',  \$CONFIG_INFO{ 'DB_PORT' }, 'What port is your database running on?' );  
   }
   if ( $command eq '7' ) {
      set_value( 'Database Type',  \$CONFIG_INFO{ 'DB_TYPE' }, 'What type of database are you running? eg...mysql, postgres, oracle, informix, sybase' );  

      if ($CONFIG_INFO{ 'DB_TYPE' } =~ 'postgres') {

         $CONFIG_INFO{ 'DB_WHERE' } = '/usr/bin/psql';
         $CONFIG_INFO{ 'DB_OWNER' } = 'postgres';
         $CONFIG_INFO{ 'DB_OWNER_PASS' } = 'none';
         $CONFIG_INFO{ 'DB_OWNER_PASSWORD' } = 'not set';
         $CONFIG_INFO{ 'DB_NAME' } = 'imp';
         if ($DEBIAN eq "true") {
           $CONFIG_INFO{ 'DB_USERNAME' } = 'www-data';
         } else {
           $CONFIG_INFO{ 'DB_USERNAME' } = 'nobody';
         }
         $CONFIG_INFO{ 'DB_PASSWORD' } = '';
         $CONFIG_INFO{ 'USE_DB' } = 'true';
         $db_where = $CONFIG_INFO{ 'DB_WHERE' };
         $db_owner = $CONFIG_INFO{ 'DB_OWNER' };
         $db_pass = $CONFIG_INFO{ 'DB_OWNER_PASS' };



      } 
      if ($CONFIG_INFO{ 'DB_TYPE' } =~ 'mysql') {

         $CONFIG_INFO{ 'DB_WHERE' } = '/usr/bin/mysql';
         $CONFIG_INFO{ 'DB_OWNER' } = 'root';
         $CONFIG_INFO{ 'DB_OWNER_PASS' } = 'none';
         $CONFIG_INFO{ 'DB_OWNER_PASSWORD' } = 'not set';
         $db_where = $CONFIG_INFO{ 'DB_WHERE' };
         $db_owner = $CONFIG_INFO{ 'DB_OWNER' };
         $db_pass = $CONFIG_INFO{ 'DB_OWNER_PASS' };

      } 


   }
   if ( $command eq '8' ) {
      set_value( 'Location of DB',  \$CONFIG_INFO{ 'DB_WHERE' }, 'What is the path to your database executable? eg.. /usr/bin/mysql or /usr/bin/psql' );  
      $db_where = $CONFIG_INFO{ 'DB_WHERE' };
   }
   if ( $command eq '9' ) {
      set_value( 'Database Owner',  \$CONFIG_INFO{ 'DB_OWNER' }, 'What username do we need to use to setup the IMP database with?  eg..postgres uses postgres, mysql uses root' );
      print "\n";
      set_value( 'Database Owner Password', \$CONFIG_INFO{ 'DB_OWNER_PASS' }, 'What is this users password?  if there is no password type none' );
      if (! ($CONFIG_INFO{ 'DB_OWNER_PASS' } )) {
         $CONFIG_INFO{ 'DB_OWNER_PASS' } = 'none';
      }
      $CONFIG_INFO{ 'DB_OWNER_PASSWORD' } = 'set';
      $db_owner = $CONFIG_INFO{ 'DB_OWNER' };
      $db_pass = $CONFIG_INFO{ 'DB_OWNER_PASS' };

   }
   if ( $command eq 'a' ) {
      set_value( 'Database Owner Password', \$CONFIG_INFO{ 'DB_OWNER_PASS' }, 'What is this users password?  if there is no password type none' );
      if (! ($CONFIG_INFO{ 'DB_OWNER_PASS' } )) {
         $CONFIG_INFO{ 'DB_OWNER_PASS' } = 'none';
      }
         $CONFIG_INFO{ 'DB_OWNER_PASSWORD' } = 'set';
         $db_pass = $CONFIG_INFO{ 'DB_OWNER_PASS' };

   }

   database_options();

}

sub other_options {
   local $command;
   clear_screen();
   config_title_bar( 'Other Options.' );
   menu_option( '1', 'Allow Folder Change   : '        . $CONFIG_INFO{ 'CHANGE_FOLDER' } );
   menu_option( '2', 'Use IMAP Subscribe    : '        . $CONFIG_INFO{ 'IMAP_SUBSCRIBE' } );
   menu_option( '3', 'Allow Server Change   : '        . $CONFIG_INFO{ 'CHANGE_SERVER' } );
   menu_option( '4', 'Allow From Change     : '        . $CONFIG_INFO{ 'CHANGE_FROM' } );
   menu_option( '5', 'Allow Fullname Change : '        . $CONFIG_INFO{ 'CHANGE_FULLNAME' } );
   menu_option( '6', 'Use Addressbook       : '        . $CONFIG_INFO{ 'USE_ADDRESSBOOK' } );
   menu_option( '7', 'Use New Mail Popup    : '        . $CONFIG_INFO{ 'NEWMAIL_POPUP' } );
   menu_option( '8', 'Append Trailer        : '        . $CONFIG_INFO{ 'TRAILER' } );
   menu_option( '9', 'Use LDAP Search       : '        . $CONFIG_INFO{ 'LDAP_SEARCH' } );
print "\n";
   menu_option( '0', 'Back to main menu.' );
   $command = command_prompt();

   if ( $command eq '0' ) { return; }
   if ( $command eq '1' ) {
      set_value( 'Allow Folder Change',    \$change_folder, 'Allow the change of folder paths..eg mail/.'  );
      if (($change_folder =~ 'y') || ($change_folder =~ 'yes') || ($change_folder =~ 'Y') || ($change_folder =~ 'YES') || ($change_folder =~ 'true') || ($change_folder =~ 'TRUE')) {
            $CONFIG_INFO{ 'CHANGE_FOLDER' } = "true";
      } else {
            $CONFIG_INFO{ 'CHANGE_FOLDER' } = "false";
      }
   }
   if ( $command eq '2' ) {
      set_value( 'Use IMAP Subscribe',  \$imap_subscribe, 'Use IMAP Subscribe Feature?' );
      if (($imap_subscribe =~ 'y') || ($imap_subscribe =~ 'yes') || ($imap_subscribe =~ 'Y') || ($imap_subscribe =~ 'YES') || ($imap_subscribe =~ 'true') || ($imap_subscribe =~ 'TRUE')) {
            $CONFIG_INFO{ 'IMAP_SUBSCRIBE' } = "true";
      } else {
            $CONFIG_INFO{ 'IMAP_SUBSCRIBE' } = "false";
      }

   }
   if ( $command eq '3' ) {
      set_value( 'Allow Server Change',    \$change_server, 'Allow users to change what IMAP server they connect to?' );
     if (($change_server =~ 'y') || ($change_server =~ 'yes') || ($change_server =~ 'Y') || ($change_server =~ 'YES') || ($change_server =~ 'true') || ($change_server =~ 'TRUE')) {
            $CONFIG_INFO{ 'CHANGE_SERVER' } = "true";
      } else {
            $CONFIG_INFO{ 'CHANGE_SERVER' } = "false";
      }
   }
   if ( $command eq '4' ) {
      set_value( 'Allow From Change',    \$change_from, 'Allow users to change thier From: line?' );
     if (($change_from =~ 'y') || ($change_from =~ 'yes') || ($change_from =~ 'Y') || ($change_from =~ 'YES') || ($change_from =~ 'true') || ($change_from =~ 'TRUE')) {
            $CONFIG_INFO{ 'CHANGE_FROM' } = "true";
      } else {
            $CONFIG_INFO{ 'CHANGE_FROM' } = "false";
      }

   }
   if ( $command eq '5' ) {
      set_value( 'Allow Fullname Change',    \$change_fullname, 'Allow users to change their fullname?' );
     if (($change_fullname =~ 'y') || ($change_fullname =~ 'yes') || ($change_fullname =~ 'Y') || ($change_fullname =~ 'YES') || ($change_fullname =~ 'true') || ($change_fullname =~ 'TRUE')) {
            $CONFIG_INFO{ 'CHANGE_FULLNAME' } = "true";
      } else {
            $CONFIG_INFO{ 'CHANGE_FULLNAME' } = "false";
      }

   }
   if ( $command eq '6' ) {
      set_value( 'Use Addressbook',    \$use_addressbook, 'Use the addressbook features? (Requires a database)' );
     if (($use_addressbook =~ 'y') || ($use_addressbook =~ 'yes') || ($use_addressbook =~ 'Y') || ($use_addressbook =~ 'YES') || ($use_addressbook =~ 'true') || ($use_addressbook =~ 'TRUE')) {
            $CONFIG_INFO{ 'USE_ADDRESSBOOK' } = "true";
      } else {
            $CONFIG_INFO{ 'USE_ADDRESSBOOK' } = "false";
      }

   }
   if ( $command eq '7' ) {
      set_value( 'Use New Mail Popup',    \$newmail, 'Use the New Mail Popup feature?' );
     if (($newmail =~ 'y') || ($newmail =~ 'yes') || ($newmail =~ 'Y') || ($newmail =~ 'YES') || ($newmail =~ 'true') || ($newmail =~ 'TRUE')) {
            $CONFIG_INFO{ 'NEWMAIL_POPUP' } = "true";
      } else {
            $CONFIG_INFO{ 'NEWMAIL_POPUP' } = "false";
      }

   }
   if ( $command eq '8' ) {
      set_value( 'Append Trailer',    \$trailer, 'Append the trailer.txt file to outgoing messages?' );
     if (($trailer =~ 'y') || ($trailer =~ 'yes') || ($trailer =~ 'Y') || ($trailer =~ 'YES') || ($trailer =~ 'true') || ($trailer =~ 'TRUE')) {
            $CONFIG_INFO{ 'TRAILER' } = "true";
      } else {
            $CONFIG_INFO{ 'TRAILER' } = "false";
      }

   }
   if ( $command eq '9' ) {
      set_value( 'Use LDAP Search',    \$ldap_search, 'Use The LDAP Search feature?' );
     if (($ldap_search =~ 'y') || ($ldap_search =~ 'yes') || ($ldap_search =~ 'Y') || ($ldap_search =~ 'YES') || ($ldap_search =~ 'true') || ($ldap_search =~ 'TRUE')) {
            $CONFIG_INFO{ 'LDAP_SEARCH' } = "true";
      } else {
            $CONFIG_INFO{ 'LDAP_SEARCH' } = "false";
      }

   }

   other_options();

}





# Clear the screen
sub clear_screen() { system( "clear" ); }
