<?php

/*
 
 File: status.php3
 $Author: chuck $
 $Revision: 1.27 $
 $Date: 1999/01/13 21:13:02 $
 
 IMP: Copyright 1999 Charles J. Hagenbuch <chuck@horde.org>
 
 You should have received a copy of the GNU Public
 License along with this package; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 
 */

require( './lib/imp.lib' );
require( './config/defaults.php3' );
$language = select_lang();
require ("./locale/$language/status.lang");
require ('./locale/local/status.lang');

/* send headers to ensure that the page will reload correctly. */
caching_headers();

/* can we log in? */
$cookies = new ImpCookies();
$user    = $cookies->get_user();
$pass    = $cookies->get_password();
$server  = $cookies->get_server();
$port    = $cookies->get_port();
$folders = $cookies->get_folder();
if (!isset($mailbox)) $mailbox = 'INBOX';


$title = $lang->status_title;
$sidebar = true;

/* doctype */
require("$default->include_dir/doctype.inc");

/* if we can log in, do so and get the mail stats for this mailbox */
if (isset($default->refresh_delay) && isset($user) && $user != '') {
  /* make it refresh */
  $refresh = true;

  $mbox = validate_login($server, $port, $mailbox, $user, $pass);
  $mailinfo = imap_mailboxmsginfo($mbox);
  if($mailinfo) {
    $num_unread = $mailinfo->Unread;
    $num_recent = $mailinfo->Recent;
    $message = $lang->mailbox_status($message, $num_unread, $num_recent);

    /* If they want it, we can give them a "new mail" popup */
    if(isset($default->newmail_popup) && $default->newmail_popup) {
      if ($num_recent > 0) {
        echo "<script>onLoad=\"mail_popup()\";";
	echo 'alert("' . $lang->newmail_msg . '");</script>';
      }
    }
  }
}


require( "$default->include_dir/generic-header.inc" );
require( "$default->include_dir/status.php3-body.inc" );
require( "$default->include_dir/generic-footer.inc" );

?>
