<?php

/*
 
 File: prefs.php3
 $Author: chuck $
 $Revision: 1.43 $
 $Date: 1999/01/14 04:58:50 $
 
 IMP: Copyright 1999 Charles J. Hagenbuch <chuck@horde.org>
 
 You should have received a copy of the GNU Public
 License along with this package; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 
 */

require( './lib/imp.lib' );              /* IMPlib is the IMP function library  */
require( './config/defaults.php3' );     /* Defaults configuration file */
$language = select_lang();
require ("./locale/$language/prefs.lang");
require ('./locale/local/prefs.lang');

if ($default->ssl->enabled) { include( './lib/ssl.lib' ); }
$db = init_db();								  /* Init the database */
error_reporting($default->error_level);  /* set error level from imp.lib   */

/* send headers to ensure that the page will reload correctly. */
caching_headers();

/* retrieve authentication information from cookies */
$cookies = new ImpCookies();
$user    = $cookies->get_user();
$pass    = $cookies->get_password();
$server  = $cookies->get_server();
$port    = $cookies->get_port();
$folders = $cookies->get_folder();
$mailbox = '';

/* proceed only with a valid login */
$mbox = validate_login($server, $port, $mailbox, $user, $pass);
$errormsg = '';


/* Run through the action handlers */
if (isset($actionID)) {
   switch($actionID) {
    case NO_ACTION:
      break;
      
    case UPDATE_PREFS:
      if (isset($signature) && ($signature != $old_signature)) {
	 if (!(imp_set_signature($signature, $user, $server))) {
	    $errormsg .= $lang->signature_error;
	 }
      }
      
      if (isset($new_lang) && ($new_lang != $old_lang)) {
	 if (!(imp_set_lang($new_lang, $user, $server))) {
	    $errormsg .= $lang->language_error;
	 }
	 $cookies->set_lang($new_lang);
	 $language = $new_lang;
	 include("./locale/$language/prefs.lang");
      }
      
      if (isset($from) && ($from != $old_from)) {
	 if (!(imp_set_from($from,$user,$server))) {
	    $errormsg .= $lang->from_error;
	 }
      }
      
      if (isset($fullname) && ($fullname != $old_fullname)) {
	 if (!(imp_set_fullname($fullname,$user,$server))) {
	    $errormsg .= $lang->fullname_error;
	 }
      }
      break;
   }
}

$langs = '<select name="new_lang">';
while (list($key, $val) = each($default->lang)) {
   if ($key == $language) $sel = ' SELECTED';
   else $sel = '';
   $langs .= "<option value=\"$key\"$sel>$val</option>\n";
}
$langs .= '</select>';

$title = $lang->prefs_title;
$sidebar = false;

require( "$default->include_dir/doctype.inc" );
require( "$default->include_dir/generic-header.inc" );
require( "$default->include_dir/prefs.php3-begin.inc" );
require( "$default->include_dir/prefs.php3-signature.inc" );
if ($default->user_change_fullname) include( "$default->include_dir/prefs.php3-fullname.inc");
if ($default->user_change_from) include( "$default->include_dir/prefs.php3-from.inc" );
require( "$default->include_dir/prefs.php3-lang.inc" );
require( "$default->include_dir/prefs.php3-end.inc" );
require( "$default->include_dir/generic-footer.inc" );

?>
