<?php

/*
 
 File: lib/ifmx.lib.php3
 $Author: chuck $
 $Revision: 1.6 $
 $Date: 1998/12/17 21:39:13 $
 
 IMP: Copywrite 1998 Charles J. Hagenbuch <chuck@horde.org>
 
 You should have received a copy of the GNU Public

 License along with this package; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 
*/


/* This file is (c) 1998 Juraj Bednar. Any comments to <bednar@isternet.sk> */
/* STATE : This file _MAY_ work, it has been completely untested... */

/* Table Structure for Informix version:
   
   Preferences Table:
    field:     type:      description:
    user       text       joe@imap.doe.com format username
    sig        text       signature
    replyto    text       joe@doe.com address
    fullname   text       Joe Doe
    (possibly more to be added later)
 
   Address Table:
    field:     type:      description:
    user       text       joe@doe.com identifier of who this entry belongs to
    address    text       address@mail.server.com - the actual address
    nickname   text       any entered nickname - ie "bonnie".
    fullname   text       full name - "My Bonnie".
*/


/* Required Functions - funtions that are called by other files and therefore
 * must be present in all db.lib implementations
 */

function imp_check_prefs($user,$server) {
   global $default;
   /* Checks for the presence of a row in prefs table for user='$user@$server' */
   if (!($db=ifx_pconnect ($default->db_name, $default->db_user_name, $default->db_password))) { return false; }
   if (!($result = ifx_query($db, "select user from $default->db_pref_table where user='$user@$server'"))) { return false; }
   
   $row = ifx_fetch_row ($result, "NEXT");
   if ($row) 
     return true; 
   else
     return false;
}

function imp_get_signature ($user, $server) {
   global $default;
   
   /* post: returns the signature for the database key $user@$server
    (a string), or false on failure.
    */
   
   if (!($db=ifx_pconnect ($default->db_name, $default->db_user_name, $default->db_password))) { return false; }
   if (!($result = ifx_query($db, "select sig from $default->db_pref_table where user='$user@$server'"))) { return false; }
   
   $row = ifx_fetch_row ($result, "NEXT");
   if ($row) return $row[0]; 
   else
     return false;
}

function imp_set_signature ($signature, $user, $server) {
   global $default;
   
   /* post: sets the signature to $signature for the database key $user@$server
    returns true on success and false on failure
    */
   
   if (imp_check_prefs($user, $server)) {
      $sql = "update $default->db_pref_table set sig='$signature' where user='$user@$server'";
   } else {
      $sql = "insert into $default->db_pref_table (user, sig) values ('$user@$server', '$signature')";
   }
   
   if (!($db=ifx_pconnect ($default->db_name, $default->db_user_name, $default->db_password))) { return false; }
   if (!($result = ifx_query($db, $sql))) { return false; }
   
   return true;
}

function imp_set_fullname ($fullname, $user, $server) {
   global $default;
   
   /* post: sets the fullname to $fullname for the database key $user@$server
    returns true on success and false on failure
    */
   
   if (imp_check_prefs($user, $server)) {
      $sql = "update $default->db_pref_table set fullname='$fullname' where user='$user@$server'";
   } else {
      $sql = "insert into $default->db_pref_table (user, fullname) values ('$user@$server', '$fullname')";
   }
   
   if (!($db=ifx_pconnect ($default->db_name, $default->db_user_name, $default->db_password))) { return false; }
   if (!($result = ifx_query($db, $sql))) { return false; }
   
   return true;
}

function imp_set_from ($from, $user, $server) {
   global $default;
   
   /* post: sets the replyto to $from for the database key $user@$server
    returns true on success and false on failure
    */
   
   if (imp_check_prefs($user, $server)) {
      $sql = "update $default->db_pref_table set replyto='$from' where user='$user@$server'";
   } else {
      $sql = "insert into $default->db_pref_table (user, replyto) values ('$user@$server', '$from')";
   }
   
   if (!($db=ifx_pconnect ($default->db_name, $default->db_user_name, $default->db_password))) { return false; }
   if (!($result = ifx_query($db, $sql))) { return false; }
   
   return true;
}

function imp_get_addresses ($user, $server) {
   global $default;
   
   /* post: returns a 2d array of addresses where each
    element is an array in which element 0 is the address,
    element 1 is the nickname, and element 2 is the fullname.
    it returns false on failure.
    */
   
   if (!($db=ifx_pconnect ($default->db_name, $default->db_user_name, $default->db_password))) { return false; }
   if (!($result = ifx_query($db, "select address, nickname, fullname from $default->db_address_table where user='$user@$server' order by nickname"))) { return false; }
   
   if (($rowcount = ifx_affected_row($rid))==0) { return false; }
   
   for ($i=0; $i<$rowcount; $i++)
   {
      $return[$i] = ifx_fetch_row ($result, "NEXT"); 
   } 
   
   return($return);
}


function imp_delete_address ($address, $user, $server) {
   global $default;
   
   /* post: deletes $address from the addressbook of $user@$server
    returns true on success and false on failure
    */
   
   if (!($db=ifx_pconnect ($default->db_name, $default->db_user_name, $default->db_password))) { return false; }
   if (!($result = ifx_query($db, "delete from $default->db_address_table where user='$user@$server' and address='$address'"))) { return false; }
   
   return true;
}


function imp_add_address ($address, $nickname, $fullname, $user, $server) {
   global $default;
   
   /* post: adds $address, $nickname, $fullname to the addressbook for $user@$server
    returns true on success and false on failure
    */
   
   if (!($db=ifx_pconnect ($default->db_name, $default->db_user_name, $default->db_password))) { return false; }
   if (!($result = ifx_query($db, "insert into $default->db_address_table values ('$user@$server', '$address', '$nickname', '$fullname')"))) { return false; }
   
   return true;
}


function imp_update_address ($old_address, $address, $nickname, $fullname, $user, $server) {
   global $default;
   
   /* post: changes the entry for $old_address to $address, $nickname, $fullname.
    returns true on success and false on failure
    */
   
   if (!($db=ifx_pconnect ($default->db_name, $default->db_user_name, $default->db_password))) { return false; }
   if (!($result = ifx_query($db, "update $default->db_address_table set address='$address', nickname='$nickname', fullname='$fullname' where user='$user@$server' and address='$old_address'"))) { return false; }
   
   return true;
}


/* Support Functions - functions which are only used by routines in this file,
 * and which therefore can change from implementation to implementation.
 */

?>
