<?php

require( './lib/imp.lib' );
require( './config/ldap.php3' );
require( './config/defaults.php3' );
$language = select_lang();
require ("./locale/$language/ldap.search.lang");
require ('./locale/local/ldap.search.lang');

error_reporting(1);

$title            = '';
$sidebar          = false;

require( "$default->include_dir/generic-header.inc" );

?>

<script language="JavaScript">


function AlertMissingParent() {
   alert('<?php echo $lang->alert_no_compose; ?>');
}

var t_compose = typeof parent.opener.parent.impmain.document.compose;

if ( t_compose == "undefined" ) {
   AlertMissingParent(); 
}

function ClearSelection() {
   window.document.f_ldap_result.collect_results.value = "";
}


function AddSelection() {
   var prefix = "";
   
   for (i=0 ; i < document.f_ldap_result.addr_selection.length ; i++) {
      if ( document.f_ldap_result.addr_selection[i].selected) {
         if ( window.document.f_ldap_result.collect_results.value ) {
            prefix=", ";
         }
	 window.document.f_ldap_result.collect_results.value = window.document.f_ldap_result.collect_results.value + prefix + document.f_ldap_result.addr_selection[i].value;
      }
   }
}

function InsertLDAP() {
   
   var prefix = "";
   var t_parent = typeof parent.opener;
   
   var t_compose = typeof parent.opener.parent.impmain.document.compose;
   
   if ( t_compose != "undefined" ) {
      if ( parent.opener.parent.impmain.document.compose.to.value ) {
	 prefix = ", ";
      }
      parent.opener.parent.impmain.document.compose.to.value = parent.opener.parent.impmain.document.compose.to.value + prefix + window.document.f_ldap_result.collect_results.value
	window.document.f_ldap_result.collect_results.value = "";
   } else {
      AlertMissingParent();
   }
   
}

</script>

<?php

if ($ldap_options) {
   switch ($ldap_options) {
    case "$lang->begins":
      $str_prefix = '';
      $str_postfix = '*';
      break;
    case "$lang->contains":
      $str_prefix = '*';
      $str_postfix = '*';
      break;
    case "$lang->ends":
      $str_prefix = '*';
      $str_postfix = '';
      break;
    case "$lang->is_strict":
      $str_prefix = '';
      $str_postfix = '';
      break;
    case "$lang->sounds":
      $str_prefix = '';
      $str_postfix = '';
      $sounds = true;
      break;
    default:
      $str_prefix = '*';
      $str_postfix = '*';
      $text_array = explode(' ', $s_text);
   }

} else {
   $str_prefix = '';
   $str_postfix = '';
   $text_array = explode(' ', $s_text);
}


if ($attr_type) {
   switch ($attr_type) {
    case "$lang->uid":
      $str_search = 'uid';
      break;
    case "$lang->mail":
      $str_search = 'mail';
      break;
    case "$lang->sn":
      $str_search = 'sn';
      break;
    case "$lang->givenname":
      $str_search = 'givenname';
      break;
    case "$lang->ou":
      $str_search = 'ou';
      break;
    default:
      $str_search = 'cn';
   }
} else {
   $str_search = 'cn';
}

if (isset($ldap_serv) && $ldap_serv) $lserver = $LDAPServers[$ldap_serv];
else {
   echo $lang->no_ldap_server;
   exit;
}

$str_serv  = $lserver->server;
$str_root = $lserver->root;
$str_sn   = $lserver->sn;


$ds = ldap_connect($str_serv);

if ($ds) $r = ldap_bind($ds);
else {
   echo $lang->no_ldap_connection;
   exit;
}

if ($r) {
   $normerr = error_reporting();
   error_reporting(0);
   if (count($text_array) == 2 && ( $str_search == 'uid' || $str_search == 'cn' || $str_search == 'sn' || $str_search == 'givenname' ) ) {
      if  ( $str_search == 'cn' ) {
	 $filter = "(|(&($str_search=$text_array[0]*)(sn=$text_array[1]*))(&($str_search=$text_array[1]*)(sn=$text_array[0]*)))";
      } else {
	 $filter = "(|($($str_search=$text_array[0]*)(cn=$text_array[1]*))(&($str_search=$text_array[1]*)(cn=$text_array[0]*)))";
      }
   } elseif ( $sounds ) {
      if ( ! $ldap_options ) {
         $str_prefix = '*';
         $str_postfix = '*';
      }
      $filter = "$str_search~=$str_prefix$s_text$str_postfix";
   } else {
      $filter = "$str_search=$str_prefix$s_text$str_postfix";
   }
   $sr=ldap_search($ds,$str_root,$filter);
   $normerr = error_reporting ($normerr);
} else {
   echo $lang->no_ldap_bind;
   exit;
}

if ( $sr ) {
   $info = ldap_get_entries($ds, $sr);
} else {
   echo $lang->too_many_results;
   exit;
}

if ( count($info) >= 2 ) {
   
  
   $addr_list[0] = Array();
   $addr_list[1] = Array();
   $addr_list[2] = Array();
   while ( list( $key, $val ) = each( $info ) ) {
      if ( gettype($val) == 'array' ) {
	 
	 if ( $val[$str_sn][0] ) {
	    $addr_list[0][count($addr_list[0])] = $val[$str_sn][0].', ' .$val[givenname][0]. ' &lt;' .$val[mail][0]. '&gt;';
	 } else {
	    $addr_list[0][count($addr_list[0])] = '';
	 }
	 $addr_list[1][count($addr_list[1])] = $val[ou][0];
	 $addr_list[2][count($addr_list[2])] = $val[cn][0]. ' &lt;' .$val[mail][0]. '&gt;';
      }
   }
   asort($addr_list[0]);


   while ( list( $key_addr, $val_addr ) = each ( $addr_list[0] ) ) {
      if ( $addr_list[0][$key_addr] ) $not_empty = true ;
   }
   reset($addr_list[0]);

   if ( $not_empty ) {
      echo '<p>&nbsp;<p><center>';
      echo '<form name="f_ldap_result" action="insert_result" method="post" target="main">';
      echo '<select name="addr_selection">';
 
      while ( list( $key_addr, $val_addr ) = each ( $addr_list[0] ) ) {
         if ( $addr_list[0][$key_addr] ) {
   	    echo "\n<option value=\"" . $addr_list[2][$key_addr];
	    echo '" label="';
	    echo $addr_list[0][$key_addr];
	    echo '"';
	    echo '>';
	    echo $addr_list[0][$key_addr];
	    if ( $addr_list[1][$key_addr] ) {
	       echo " (" . $addr_list[1][$key_addr]. ")";
	    }
         }
      }
   
   
   
      echo "</SELECT>";
      echo "&nbsp;<INPUT type=\"button\" Value=\"" .$lang->ldap_add.  "\" onClick=\"AddSelection()\">";
      echo "<P>";
      echo "<INPUT type=\"button\" Value=\"" .$lang->ldap_clear. "\" onClick=\"ClearSelection()\">&nbsp;";
      echo "<INPUT type=\"text\" SIZE=\"50\" Name=\"collect_results\">";
      echo "&nbsp;<INPUT type=\"button\" Value=\"" .$lang->ldap_insert. "\" onClick=\"InsertLDAP()\">";
      echo "</FORM>";
      echo "</CENTER>";
   } else {
      echo $lang->ldap_no_results;
      exit;
   }
} else {
   echo $lang->ldap_no_results;
   exit;
}

if (isset($ds) && $ds) {
   ldap_close($ds);
}

require( "$default->include_dir/generic-footer.inc" );

?>
