#!/usr/local/bin/perl --
# Semiautomatic configuration script for IMP.
# Used after installation to configure IMP on a system, and can be run
# at any later time (though --force may be needed).
# This script was stolen from the smailconfig script so original copyright's
# are being maintained.
# Turned into the IMP configurator in January of 1999 by Ivan Moore
# 
# Copyright 1994 Ian Jackson.  There is NO WARRANTY.
# Copyright 1997 Soenke Lange
# Copyright 1998,1999 Ivan E. Moore II
# See imp/COPYING.
#
# To use this script, simpley run ./imp_setup.pl from this 
# directory. (the imp/contrib directory as the script is designed
# to work from this directory only!)
#
# On some systems you may have to run perl ./imp_setup.pl
#
# Please note you may have to modify the path to perl at the top
#


$|=1;

$etc='../';
$dbtype='dummy';
$syshostname=`hostname --fqdn`;
chop($syshostname=`hostname --fqdn`);
$imap_server="$syshostname";
$from_server="$syshostname";
$install_dir='../';
$tmproot='../';
$impmgr=`impmgr`;
$impmgr_passwd=`impmgr`;

if ($ARGV[0] eq '--force') { $force=1; shift; }

if (-s "$install_dir/config/defaults.php3") {
    if ($force) {
        print "Ignoring existing IMP configuration.\n";
    } else {
        print "IMP is already configured; I\'ll leave\n";
	print "the existing configuration untouched. \n\n";
	print "Use --force to ignore it.\n";
        exit(0);
    }
}

for (;;) {

    undef @files;



    &query(
"
=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
Welcome to the IMP WebMail Program Installation script

This does a basic installation and setup based off of answers
to a few questions.  This does not do everything that may need
to be done.  Some of the issues I am currently working through
are the database options.  Currently I can configure MySql
from this script and I am working on the other database servers.

Therefore, This will walk through basic settings and there
will be help files available in imp/lib/scripts for configuring
the database the rest of the way.
=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
Please answer the following questions...


Do you want to allow users to change what server they connect to?

	1)  Yes
	2)  No

Select a number from 1 to 2, from the list above.",
	'imp_server_type',
	'1',
	'm/^[12]$/');


    if ($imp_server_type == 2) {
                $imp_server='false';
    }

    if ($imp_server_type == 1) {
                $imp_server='true';
    }



    &query(
"
Allow users to change their from line?
	
	1) Yes
	2) No

Select a number from 1 to 2, from the list above.",
	'fromtype',
	'1',
	'm/^[12]$/');

    if ($fromtype == 1) {
                $fromline='true';
    }
    if ($fromtype == 2) {
                $fromline='false';
    }


    &query(
"
Allow users to change their fullname information?

	1) Yes
	2) No

Select a number from 1 to 2, from the list above.",
        'fullname_type',
        '1',
        'm/^[12]$/');

    if ($fullname_type == 1) {
                $fullname='true';
    }
    if ($fullname_type == 2) {
                $fullname='false';
    }



    &query(
"
Allow users to use the addressbook?

	1) Yes
	2) No

Select a number from 1 to 2, from the list above.",
        'addressbook_type',
        '1',
        'm/^[12]$/');

    if ($addressbook_type == 1) {
                $addressbook='true';
    }
    if ($addressbook_type == 2) {
                $addressbook='false';
    }



    &query(
"
Use the new New Mail Popup feature?

	1) Yes
	2) No

Select a number from 1 to 2, from the list above.",
        'newpopup_type',
        '1',
        'm/^[12]$/');

    if ($newpopup_type == 1) {
                $newpopup='true';
    }
    if ($newpopup_type == 2) {
                $newpopup='false';
    }


    &query(
"
Use the IMAP Subscribe option?

        1) Yes
        2) No

Select a number from 1 to 2, from the list above.",
        'imapsubscribetype',
        '1',
        'm/^[12]$/');

    if ($imapsubscribetype == 1) {
                $imapsubscribe='true';
    }
    if ($imapsubscribetype == 2) {
                $imapsubscribe='false';
    }

    &query(
"
Allow users to change which mail folder to use?
(what directory off of ~/ their mail folders are stored in)

        1) Yes
        2) No

Select a number from 1 to 2, from the list above.",
        'changefoldertype',
        '1',
        'm/^[12]$/');

    if ($changefoldertype == 1) {
                $changefolder='true';
    }
    if ($changefoldertype == 2) {
                $changefolder='false';
    }


    &query(
"
What do you want the default language set to?

        1) English
        2) Spanish
        3) German
        4) Danish
        5) French

Select a number from 1 to 5, from the list above.",
        'languagetype',
        '1',
        'm/^[12345]$/');

    if ($languagetype == 1) {
                $language='en';
		$languagename='English';
    }
    if ($languagetype == 2) {
                $language='es';
                $languagename='Spanish';
    }
    if ($languagetype == 3) {
                $language='de';
                $languagename='German';
    }
    if ($languagetype == 4) {
                $language='da';
                $languagename='Danish';
    }
    if ($languagetype == 5) {
                $language='fr';
                $languagename='French';
    }



    &query(
"


What server should be default for IMAP connections?

",
      'imap_server',
      '$syshostname',
      '1', 'e');

    &query(      
"


What port should we use to connect to the default IMAP server?
(143 is default)

",
      'imap_server_port',    
      '143',
      '1', 'e');


    &query(
"


What hostname do you want your users to appear to be coming from?
(meaning mail will appear to be coming from what server?)

",
      'from_server',
      "$syshostname",
      '1', 'e');




    &query(
"

IMP can be configured to use a database.  The purpose of this is so that you can use the addressbook and prefs options.  MySql was found on your system!  
This setup script can configure MySql for you (as long as you know the system
password for MySql).  Please note if you pick another database, you need
to make sure it's installed properly.  

Please chose a database type to use:

	1) Dummy.  No database.  (you won't be able to use addressbook or prefs)
	2) MySql.  
	3) PostgreSQL 
	4) Oracle  
	5) Informix 

Please note that I can only personally validate that the MySql server
works as I do not use the other 3 database's personally.  If someone
who does would let me know what their results are that would help with
the configuration process.  

Select a number from 1 to 5, from the list above.",
           'configtype',
	    '1',
           'm/^[12345]$/');

    if ($configtype == 1) {
                $dbtype='dummy';
    }

    if ($configtype == 2) {
                $dbtype='mysql';

    &query(
"
Do you have MySql installed and in your path?

        1) Yes
        2) No

Select a number from 1 to 2, from the list above.",
        'mysql_yes',
        '1',
        'm/^[12]$/');

    if ($mysql_yes == 1) {


         &query(
"

What is your MySql password (so that we may configure it for IMP)?
This install script will later attempt to added database entries
to your MySql server so that IMP will function properly.
(type None if your password is blank)

",
      'mysql_pass',
      'None',
      '1','e');
   }
}

    if ($configtype == 3) {
                $dbtype='pgsql';
		$impmgr='nobody';
		$impmgr_passwd='';
    }

    if ($configtype == 4) {
                $dbtype='oracle';
    }

    if ($configtype == 5) {
                $dbtype='ifmx';
    }


# now do it ...

    &setfile('config/imp.conf',
'# This is the main IMP configuration file.
# Debian Config Version 2',
"
installation_dir=$install_dir
imap_server=$imap_server
localhost=$syshostname2
your_hostname=$syshostname
database=$dbtype
");

$confdescrip="
Installation Directory will be $install_dir
Your IMAP server is: $imap_server
Your IMAP port is: $imap_server_port
Your hostname is: $syshostname
Mail will appear from: $from_server
You chose to use the $dbtype database option.

Allow users to change the IMAP server they connect to:  $imp_server
Allow users to change their Full Name information:      $fullname
Allow users to change their fromline:                   $fromline
Allow users to use the Addressbook:                     $addressbook
Use the New Mail Popup Feature:                         $newpopup
IMAP Subscribe Option:				 	$imapsubscribe
Allow users to change which mail folder to use:		$changefolder
Default Language:					$languagename


";




    do {
        print "\n\nThe following configuration has been entered:

$confdescrip

Is this OK ?  Hit Return or type \`y' to confirm it and install,
or \`n' to make changes (in which case we'll go round again, giving you
your previous answers as defaults.     (y/n) ";

        $!=0; defined($what=<STDIN>) || die "impconfig: EOF/error on stdin: $!  \n";
    } while ($what !~ m/^\s*[yn]?\s*$/i);
    last unless $what =~ m/^n/i;
}



    &setfile('config/defaults.php3',

'<?php',
"

/* set theme colors */
\$default->dark_bg                   = '#002266';
\$default->light_bg                  = '#e9e9e9';
\$default->text_on_light             = '#000000';
\$default->text_on_dark              = '#ffffff';
\$default->text_bg                   = '#ffffff';
\$default->item_bg                   = '#ffffcc';
\$default->new_item_bg               = '#eeeeff';
\$default->del_item_bg               = '#cccccc';
\$default->nav_bg                    = '#dcdcdc';
\$default->sort_bg                   = '#ffdd88';

\$default->body->bg_color            = \$default->light_bg;
\$default->body->bg_file             = '';
\$default->body->text_color          = \$default->text_on_light;
\$default->body->link_color          = '#0000ff';
\$default->body->vlink_color         = '#0000aa';
\$default->body->alink_color         = '#0000ff';
\$default->sidebar->bg_color         = \$default->dark_bg;
\$default->sidebar->text_color       = \$default->text_on_dark;
\$default->sidebar->link_color       = '#e0e0e0';
\$default->sidebar->vlink_color      = '#dddddd';
\$default->sidebar->alink_color      = '#ffffff';
\$default->sidebar->logo	     = true;
\$default->sidebar->logo_url         = 'impsmall.gif';
\$default->sidebar->local_site_logo  = false;
\$default->sidebar->local_site_logo_url  = '';

// \$default->deleted_flag              = 'D';
// \$default->unread_flag               = 'N';
// \$default->answered_flag             = 'A';

\$default->deleted_flag              = '<img alt=\"[deleted]\" src=\"graphics/deleted.gif\">';
\$default->unread_flag               = '<img alt=\"[unread]\" src=\"graphics/newmail.gif\">';
\$default->answered_flag             = '<img alt=\"[answered]\" src=\"graphics/answered.gif\">';


/* width attributes for mailbox pages */
\$default->max_frm_chars             = 40;
\$default->max_sub_chars             = 50;
\$default->max_messages_page         = 30;


/* Server Specific Configuration */
\$default->root_url                  = '/imp';
\$default->graphics_url              = \$default->root_url . '/graphics';
\$default->server                    = '$imap_server';
\$default->from_server               = '$from_server';
\$default->port                      = $imap_server_port;
\$default->folders                   = 'mail/';
\$default->sent_mail                 = 'sent-mail';
\$default->postponed                 = 'postponed-msgs';
\$default->secure                    = true;
\$default->cache_pages               = false;
\$default->save_sent_mail            = true;
\$default->use_imap_subscribe        = $imapsubscribe;
\$default->use_ldap_search	     = false;
\$default->user_change_server        = $imp_server;
\$default->use_server_list           = false;
\$default->user_change_folder        = $changefolder;
\$default->user_change_from          = $fromline;
\$default->user_change_fullname      = $fullname;
\$default->user_use_filemgr          = false;
\$default->user_use_addressbook      = $addressbook;
\$default->show_dotfiles             = false;
\$default->error_level               = 15;
\$default->refresh_delay             = 300;
\$default->newmail_popup             = $newpopup;
\$default->cookie_timeout            = 1000;
\$default->path_to_sendmail          = '/usr/sbin/sendmail';
\$default->path_to_ispell            = '/usr/local/bin/ispell';
\$default->path_to_mswordview        = '/usr/local/bin/mswordview -g /dev/null -o -';
\$default->db_lib                    = 'lib/$dbtype.lib.php3';
\$default->use_db                    = true;
\$default->include_dir               = './templates';
\$default->localhost                 = '$syshostname';
\$default->ssl->snoop_dn             = false;
\$default->ssl->client_auth_required = false;
\$default->cyrus->enabled            = false;
\$default->personal_folders          = '';
\$default->language                  = '$language';
\$default->fetch_mime_info           = true;    /* change to false for speed increase with mailbox.php3 */
\$default->append_header             = true;
\$default->append_trailer            = true;

/* database config */
\$default->db_user_name              = '$impmgr';
\$default->db_password               = '$impmgr_passwd';
\$default->db_name                   = 'imp';
\$default->db_server_name            = 'localhost';
\$default->db_pref_table             = 'imp_pref';
\$default->db_address_table          = 'imp_addr';
\$default->db_log_table              = 'imp_logs';
\$default->db_connect_string         = '';
\$default->db_server_port            = '';
\$default->db_server_options         = '';
\$default->db_server_tty             = '';



/* include mime and language configuration */
require( './config/mime.php3' );
require( './config/lang.php3' );



?>
");     



sub setfileshort {
    local ($filename,$value) = @_;
    push(@files,$filename);
    $filecontents{$filename}= $value;
}

sub setfile {
    local ($filename,$value1,$value2,$d) = @_;
    chop($d=`date`);
    $v=
"$value1\
$value2";
    push(@files,$filename);
    $filecontents{$filename}=$v;
}

sub reswarn {
    print STDERR "$_[0]\n";
    return 0;
}

sub query {
    local ($question, $varname, $default, $check, $opts) = @_;
    local ($allowempty, $response, $e);
    print "\n";
    $allowempty= $opts =~ m/e/;
    if (eval "defined(\$$varname)") {
        $default= eval "\$$varname";
        $default='none' if $default eq '' && $allowempty;
    }
    for (;;) {
        print "$question\nEnter value (";
        print "default=\`$default', " if length($default);
        print "\`x' to restart): ";
	$!=0; defined($iread=<STDIN>) || die "impconfig: EOF/error on stdin: $!\n";
        $_= $iread; s/^\s+//; s/\s+$//;
        return 0 if m/^x$/i;
        $_= $default if $_ eq '';
        if (!length($_)) {
            print "  Sorry, you must enter a value.\n";
            next;
        }
        $_= '' if $_ eq 'none' && $allowempty;
        $response= $_;
        last if eval $check;
        if (length($@)) {
            print STDERR "  Aargh, bug - bug - please report:\n$@\nin\n $check\n";
            last;
        } else {
            print "  Sorry, that value is not acceptable.\n";
        }
    }
    $e= "\$$varname = \$response;";
    eval $e; length($@) && die "aargh - internal error ($e): $@";
    1;
}


for $f (@files) {
    open(N,">$etc/$f.postinstnew") || die "Error creating $etc/$f.postinstnew: $
!\n";  
    print(N $filecontents{$f}) || die "Error writing $etc/$f.postinstnew: $!\n";
    close(N) || die "Error closing $etc/$f.postinstnew: $!\n";
}

while (defined($f= pop(@files))) {
    rename("$etc/$f.postinstnew","$etc/$f") || die "Error installing $etc/$f: $!
\n";     
}


while (defined($f= pop(@files))) {
    rename("$etc/$f.postinstnew","$etc/$f") || die "Error installing $etc/$f: $!\n";
}


print "
Configuration installed. Finishing up everything else...

";

  if ($configtype == 5) {
     exec 'cat ../libs/scripts/ifmxsetup.txt ;echo "Please Restart Apache" ';
  }

  if ($configtype == 4)  {
     exec 'cat ../lib/scripts/oraclesetup.txt ;echo "Please Restart Apache" ';
   }


  if ($configtype == 3) {
        #exec 'echo "Attempting to auto-config PostgreSQL for you..." ; su postgres -c "psql template1 < ../lib/scripts/pgsql_create.sql " ; su postgres -c "../lib/scripts/pgsql_cuser.sh" ; echo "Please restart Apache and PostgreSQL" ';
	exec 'cat ../lib/scripts/psgqlsetup.txt ; echo "Please Restart Apache" ';
   }


if ($configtype == 2) {

  if ($mysql_yes == 1) {

      if ($mysql_pass == "None") {
exec 'echo "Attempting to Configure MySql" ; mysql < ../lib/scripts/ver2/mysql_create_all.sql >> /dev/null 2>&1 ; echo "MySql should (cross your fingers) be configured now!" ; echo "Please Restart MySql and Apache" ';
      } else {
        exec 'echo "Attempting to Configure MySql" ; mysql --password=$mysql_pass < ../lib/scripts/ver2/mysql_create.sql >> /dev/null 2>&1 ; echo "MySql should (cross your fingers) be configured now!" ; echo "Please Restart MySql and Apache" ';
      }
 
 } else {
   exec 'cat ../lib/scripts/mysqlsetup.txt ; echo "Please Restart Apache" ';
 }
}

  if ($configtype == 1) {
     exec 'echo "Please Restart Apache..." ';
  }


