#!/usr/local/bin/bash
# This script performs a checkout from the horde CVS tree at horde.org
# and makes a release type tarball
#
#  Test for all arguments present
#
MYNAME=`basename $0`
if [ $# -lt 1 ] ; then
    /bin/echo "Usage: $MYNAME [imp nag gollem kronolith troll] " 1>&2
    exit 2
fi


# Setup some script variables
export DATE=`date +%Y%m%d`
export CWD=`pwd`;
export CVSROOT="Your CVSROOT"
export RSYNC="/usr/local/bin/rsync -az --delete"
export CVSCOMMAND="/usr/bin/cvs -q checkout $1"
export IMPHOME="Where you want to keep your Tar Balls"

echo "Connecting to horde.org::horde-cvs...";

$RSYNC horde.org::horde-cvs/ $CVSROOT;

     # Use some temp drive space to tar.bz2 and tar.gz copy
#rm -f *.tar.gz;
cd $IMPHOME
mkdir temp;
cd temp;
$CVSCOMMAND;
tar cfz $1-$DATE-cvssnap.tar.gz $1/*;
mv $1-$DATE-cvssnap.tar.gz $IMPHOME/;
cd $IMPHOME;
rm -rf temp/ ;

# Go back to our current directory

cd $CWD;

echo "Done...";
