#!/usr/local/bin/bash
# This script performs a checkout from the horde CVS tree at horde.org
#
#  Test for all arguments present
#
MYNAME=`basename $0`
if [ $# -lt 1 ] ; then
    /bin/echo "Usage: $MYNAME [imp nag gollem kronolith troll] " 1>&2
    exit 2
fi


# Setup some script variables
export DATE=`date +%Y%m%d`
export CWD=`pwd`;
export CVSROOT="Your CVSROOT"
export RSYNC="/usr/local/bin/rsync -az --delete"
export CVSCOMMAND="/usr/bin/cvs -q checkout $1"

if [ $1 = imp ] ; then
    export CVSCHECKOUT="Where you installed IMP"
elif [ $1 = nag ] ; then
    export CVSCHECKOUT="Where you installed NAG"/"
elif [ $1 = kronolith ] ; then
    echo "Localtion Not Assigned"
    exit
#   export CVSCHECKOUT=""
elif [ $1 = gollem ] ; then
    echo "Localtion Not Assigned"
    exit
#   export CVSCHECKOUT=""
elif [ $1 = troll ] ; then
    echo "Localtion Not Assigned"
    exit
#   export CVSCHECKOUT=""
else
    echo "$1 is not a Valid OPTION"
    exit
fi

echo "Connecting to horde.org::horde-cvs...";

$RSYNC horde.org::horde-cvs/ $CVSROOT;

echo "Checking Out $1 cvs...";

# Checkout copy for my web server

cd $CVSCHECKOUT;
$CVSCOMMAND;

# Go back to our current directory

cd $CWD;

echo "Done...";
