<?php

/*
 
 File: spelling.php3
 $Author: chuck $
 $Revision: 1.21 $
 $Date: 1999/01/13 21:13:02 $
 
 IMP: Copyright 1999 Charles J. Hagenbuch  <chuck@horde.org>
 
 You should have received a copy of the GNU Public
 License along with this package; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 
 */

require( './lib/imp.lib' );             /* IMPlib is the IMP function library  */
require( './config/defaults.php3' );    /* Defaults configuration file */
$language = select_lang();
require ("./locale/$language/spelling.lang");
require ('./locale/local/spelling.lang');

error_reporting($default->error_level); /* set error level from imp.lib   */

/* send headers to ensure that the page will reload correctly. */
caching_headers();

$title = $lang->spelling_title;
$sidebar = false;
require("$default->include_dir/doctype.inc");
require("$default->include_dir/generic-header.inc");

$tocheck = escapeShellCmd($message);

exec( "echo $tocheck | $default->path_to_ispell -l", $warnings);
sort($warnings);

$prev = '';
while (list($key, $val) = each($warnings)) {
   if ($val != $prev) {
      $errors[] = $val;
   }
   $prev = $val;
}

$message = "\n" . nl2br(htmlspecialchars($message));
if (isset($errors)) {
   while (list($key, $error) = each($errors)) {
      // thanks to Ray Kimsey <Ray_Kimsey@ncsu.edu> for these smarter regexes
      $message = ereg_replace(" $error([ ,.:;!?()/\n])", " <font color=ff0000>$error</font>\\1", $message);
      $message = ereg_replace("\n$error([ ,.:;!?()/\n])", "\n<font color=ff0000>$error</font>\\1", $message);
      $message = ereg_replace(" $error\r", " <font color=ff0000>$error</font>\r", $message);
   }
}

echo stripSlashes($message);

require("$default->include_dir/spelling.php3-footer.inc");

?>
