#!/usr/bin/perl
# buildlib.pl
#
local( %FILE_COMMENTS );
local( %FILE_NEEDED );
local( @INIT_ORDER );
local( $inc, $def, $func, $obj, $init );

$inc  = 'includes/';
$def  = 'defines/';
$func = 'functions/';
$obj  = 'objects/';
$init = 'initialization/';

$VALID_OPT = 0;

# Init all of the files as not-needed
init_needs_file();

local ( $NEED_NAG, $NEED_IMP );
$NEED_NAG          = 0;
$NEED_IMP          = 0;

# Database configuration stuff

# Dummy driver is used if none other is specified
#$NEED_V1_DBDUMMY   = 1;
#$NEED_V2_DBDUMMY   = 1;

# Flags to turn on / off database options
$NEED_MYSQL        = 0;             # Mysql database
$NEED_INFORMIX     = 0;             # Informix database
$NEED_ORACLE       = 0;             # Oracle database
$NEED_POSTGRES     = 0;             # Postgres database

$NEED_V1_DB        = 0;             # Version 1 of the database
$NEED_V2_DB        = 0;             # Version 2 of the database

#
$TARGET_DIR        = '..';
$NEED_USAGE        = 0;

for( $i = 0; $i <= $#ARGV; $i++ ) {
   # Modules 
   if ( $ARGV[ $i ] eq "--imp" )                   { $NEED_IMP      = 1; $VALID_OPT = 1; next; }
   if ( $ARGV[ $i ] eq "--nag" )                   { $NEED_NAG      = 1; $VALID_OPT = 1; next; }
   # Database options
   if ( $ARGV[ $i ] eq "--with-v1" )               { $NEED_V1_DB    = 1; $VALID_OPT = 1; next; }
   if ( $ARGV[ $i ] eq "--with-v2" )               { $NEED_V2_DB    = 1; $VALID_OPT = 1; next; }
   if ( $ARGV[ $i ] eq "--with-mysql" )            { $NEED_MYSQL    = 1; $VALID_OPT = 1; next; }
   if ( $ARGV[ $i ] eq "--with-informix" )         { $NEED_INFORMIX = 1; $VALID_OPT = 1; next; }
   if ( $ARGV[ $i ] eq "--with-oracle" )           { $NEED_ORACLE   = 1; $VALID_OPT = 1; next; }
   if ( $ARGV[ $i ] eq "--with-postgres" )         { $NEED_POSTGRES = 1; $VALID_OPT = 1; next; }

   # Options for flagging stuff off
   if ( $ARGV[ $i ] =~ /--with-v1=no/i )           { $NEED_V1_DB    = 0; $VALID_OPT = 1; next; }
   if ( $ARGV[ $i ] =~ /--with-v2=no/i )           { $NEED_V2_DB    = 0; $VALID_OPT = 1; next; }
   if ( $ARGV[ $i ] =~ /--with-mysql=no/i )        { $NEED_MYSQL    = 0; $VALID_OPT = 1; next; }
   if ( $ARGV[ $i ] =~ /--with-informix=no/i )     { $NEED_INFORMIX = 0; $VALID_OPT = 1; next; }
   if ( $ARGV[ $i ] =~ /--with-oracle=no/i )       { $NEED_ORACLE   = 0; $VALID_OPT = 1; next; }
   if ( $ARGV[ $i ] =~ /--wtih-postgres=no/i )     { $NEED_POSTGRES = 0; $VALID_OPT = 1; next; }

   # Override option defaults
   if ( $ARGV[ $i ] =~ /--target-dir=(.*)/ )       { $TARGET_DIR    = $1; $VALID_OPT = 1; next; }

   # Help options
   if ( $ARGV[ $i ] eq '-?' )                      { $NEED_USAGE    = 1; next; }
   if ( $ARGV[ $i ] eq '--?' )                     { $NEED_USAGE    = 1; next; }
   if ( $ARGV[ $i ] eq '-help' )                   { $NEED_USAGE    = 1; next; }
   if ( $ARGV[ $i ] eq '--help' )                  { $NEED_USAGE    = 1; next; }

   # UNKNOWN ARG :
   print "Please check your arguments : " . $ARGV[ $i ] . " is not a valid option.\n";
   print_usage();
   exit();

}

if ( $NEED_USAGE == 1        || $VALID_OPT == 0  ) {
   print_usage();
   exit();
}
### -- Build Process -- ###

# Build horde.lib
init_needs_file();
$horde_lib_name = $TARGET_DIR . "/horde.lib";

if ( $NEED_NAG == 1 ) {
build_nag_horde_lib();
}
if ( $NEED_IMP == 1 ) {
build_imp_horde_lib();
}

build_lib();

# Build the individual client modules

## -- NAG -- ##
if ( $NEED_NAG == 1 ) {
   init_needs_file();
   $horde_lib_name = $TARGET_DIR . "/nag.lib";
   build_nag_lib();
   build_lib();
}
## -- IMP -- ##
if ( $NEED_IMP == 1 ) {
   init_needs_file();
   $horde_lib_name = $TARGET_DIR . "/imp.lib";
   build_imp_lib();
   build_lib();
}

# Build the database library
init_needs_file();
$horde_lib_name = $TARGET_DIR . "/db.lib";
needs_horde_copyright();
if ( $NEED_IMP == 1 ) {
   needs_imp_database();
}
build_lib();

sub init_needs_file {
   foreach $file( keys %FILE_COMMENTS ) {
      $FILE_NEEDED{ $file } = 0;
   }
   @INIT_ORDER = ();
}

sub need_file {
   local( $file_name, $comment ) = @_;
   $FILE_COMMENTS{ $file_name } = $comment;
   $FILE_NEEDED{ $file_name } = 1;
}

#### - Different needs functions -> used in the lib functions to setup need this type relationships - ####
sub needs_horde_cookies {
   need_file(     'HordeCookies.object',              'HordeCookies Object' );
}

sub needs_horde_help {
   need_file( 'HordeHelp.object',                     'HordeHelp Object' );
}

sub needs_horde_copyright {
   need_file( 'HordeCopyright.inc',                 '' );
}

sub needs_horde_html {
   need_file( 'HtmlDocument.object',                  'HtmlDocument Object' );
   need_file( 'HtmlBold.object',                      'HtmlBold Object' );
   need_file( 'HtmlTable.object',                     'HtmlTable Object' );
   need_file( 'HtmlTableCell.object',                 'HtmlTableCell Object' );
   need_file( 'HtmlTableRow.object',                  'HtmlTableRow Object' );
   need_file( 'HtmlFont.object',                      'HtmlFont Object' );
}

sub needs_horde_objects {
   need_file( 'HordeAdminPrivlage.object',            'HordeAdminPrivlage Object' );
   need_file( 'HordeConfigForm.object',               'HordeConfigForm Object' );
   need_file( 'HordeGrant.object',                    'HordeGrant Object' );
   need_file( 'HordeDataGrant.object',                'HordeDataGrant Object' );
   need_file( 'HordeImapServer.object',               'HordeImapServer Object' );
   need_file( 'HordeUser.object',                     'HordeUser Object' );
   need_file( 'HordeGroup.object',                    'HordeGroup Object' );
   need_file( 'HordeLocaleLang.object',               'HordeLocaleLang Object' );
   need_file( 'HordeDefaults.object',                 'HordeDefaults Object');
}

sub needs_horde_lib_version {
   need_file( 'HordeLibVersion.def',                  'HordeLibrary Version' );
}

sub needs_browser_match {
   need_file( 'WebClient.object',                     'WebClient Object' );
}

sub needs_imp_database {
   
   local $v1_function_root       = 'db/v1/functions';
   local $v1_includes_root       = 'db/v1/includes';
   local $db_driver              = '';

   if ( $NEED_MYSQL     == 1 ) { $db_driver = 'mysql';      }
   if ( $NEED_INFORMIX  == 1 ) { $db_driver = 'informix';   }
   if ( $NEED_ORACLE    == 1 ) { $db_driver = 'oracle';     }
   if ( $NEED_POSTGRES  == 1 ) { $db_driver = 'postgres';   }

   # Default database driver
   if (
      $NEED_MYSQL       == 0           &&
      $NEED_INFORMIX    == 0           &&
      $NEED_ORACLE      == 0           &&
      $NEED_POSTGRES    == 0 )
      {
      $db_driver = 'dummy';
      } else {
         if ( $NEED_V1_DB == 1 ) {
            # Include the database's table_format.inc
            need_file( $v1_includes_root . '/' . $db_driver . '/table_format.inc',                  'Table format' );
         }
      }

   if ( $NEED_V1_DB == 1 ) {
      if ( $NEED_ORACLE == 1 ) {
      need_file( $v1_function_root . '/' . $db_driver . '/enterOracle.func',                  'enterOracle function' );
      need_file( $v1_function_root . '/' . $db_driver . '/leaveOracle.func',                  'leaveOracle function' );
      }
      need_file( $v1_function_root . '/' . $db_driver . '/imp_delete_address.func',           'imp_delete_address function' );
      need_file( $v1_function_root . '/' . $db_driver . '/imp_get_fullname.func',             'imp_get_fullname function' );
      need_file( $v1_function_root . '/' . $db_driver . '/imp_set_from.func',                 'imp_set_from function' );
      need_file( $v1_function_root . '/' . $db_driver . '/imp_set_signature.func',            'imp_set_signature function' );
      need_file( $v1_function_root . '/' . $db_driver . '/imp_add_address.func',              'imp_add_address function' );
      need_file( $v1_function_root . '/' . $db_driver . '/imp_get_addresses.func',            'imp_get_addresses function' );
      need_file( $v1_function_root . '/' . $db_driver . '/imp_get_lang.func',                 'imp_get_lang function' );
      need_file( $v1_function_root . '/' . $db_driver . '/imp_set_fullname.func',             'imp_set_fullname function' );
      need_file( $v1_function_root . '/' . $db_driver . '/imp_update_address.func',           'imp_update_address function' );
      need_file( $v1_function_root . '/' . $db_driver . '/imp_check_prefs.func',              'imp_check_prefs function' );
      need_file( $v1_function_root . '/' . $db_driver . '/imp_get_from.func',                 'imp_get_from function' );
      need_file( $v1_function_root . '/' . $db_driver . '/imp_get_signature.func',            'imp_get_signature function' );
      need_file( $v1_function_root . '/' . $db_driver . '/imp_set_lang.func',                 'imp_set_lang function' );
   }
   if ( $NEED_V2_DB == 1 ) {
      need_file( 'db/v2/' . $db_driver . '/obejects/' . 'HordeDb.object',                     'HordeDb object' );
   }

}

sub needs_imp_defaults_objects {
   need_file( 'ImpDefaults.object',                   'ImpDefaults Object' );
   need_file( 'CyrusDefaults.object',                 'CyrusDefaults Object' );
   #need_file( 'LogDefaults.object',                   'LogDefaults Objects' );
   need_file( 'SSLDefaults.object',                   'SSLDefaults Object' );
   need_file( 'IMAPServer.object',                    'IMAPServer Object' );
   need_file( 'ImpUserDefaults.object',               'ImpUserDefaults Object' );
}

sub needs_nag_defaults_objects {
   need_file( 'NagDefaults.object',                   'NagDefaults Object' );
}

sub needs_horde_global_defs {
   need_file( 'GlobalDefines.def',                 '' );
}

sub needs_horde_db_defs {
   need_file( 'HordeDb.def',                       'Horde Database defines' );
}
 
sub build_nag_horde_lib {

   needs_horde_copyright();
   needs_horde_lib_version();
   
   needs_horde_global_defs();
   needs_horde_html();
   needs_horde_objects();
   needs_horde_db_defs();
   needs_horde_cookies();
   needs_horde_help();
   #needs_browser_match();

   # Nag specific objects
   need_file( 'NagModes.def',                      'Nag - Form Action Defines' );
   need_file( 'NagItem.def',                       'Nag items define.' );
   needs_nag_defaults_objects();

   # Nag specific functions
   need_file( 'init_db.func',                      'init_db function' );
   need_file( 'login_to_db.func',                  'login_to_db function' );
   need_file( 'form_title.func',                   'form_title function' );
   need_file( 'submit_reset.func',                 'submit_reset function' );
   need_file( 'text_box.func',                     'text_box function' );
   need_file( 'hidden_item.func',                  'hidden_item function' );
   need_file( 'main_ops.func',                     'main_ops function' );
   need_file( 'get_section_id.func',               'get_section_id function' );
   need_file( 'get_user_id.func',                  'get_user_id function' );
   need_file( 'update_todo.func',                  'update_todo function' );
   need_file( 'insert_todo.func',                  'insert_todo function' );
   need_file( 'insert_user.func',                  'insert_user function' );
   need_file( 'todo_sections.func',                'todo_sections function' );
   # -- Deprecated functions
   #need_file( 'font_me.func',                      'font_me function' );

}

sub build_nag_lib {
   needs_horde_copyright();
   need_file( 'ImpLibVersion.def',                 'ImpLibrary Version' );
   need_file( 'IncludeHordeLib.init',              'Include Horde Lib' );
   need_file( 'InitNagDefaults.init',              'Init Nag Defaults object' );
   need_file( 'InitHelp.init',                     'Init Horde Help' );
}

sub build_imp_horde_lib {
   
   needs_horde_copyright();
   needs_horde_lib_version();
   needs_horde_html();
   needs_horde_objects();
   needs_horde_cookies();
   needs_horde_help();
   needs_browser_match();
   needs_imp_defaults_objects();
   needs_horde_global_defs();
   needs_horde_db_defs();

   # Imp specific objects
   need_file( 'ImapServers.def',                   'IMAP Servers' );
   need_file( 'ImpActions.def',                    'IMP - Form Action Defines' );
   need_file( 'ImpUserSignature.object',           'ImpUserSignature Object' );
   need_file( 'ImpUser.object',                    'ImpUser Object' );
   need_file( 'ImpCookies.object',                 'IMP - Cookies Object' );
   need_file( 'LDAPServer.object',                 'LDAPServer Object' );

   # Imp specific functions
   need_file( 'wrap_message.func',                 'Message wrapping function.' );
   need_file( 'textwrap.func',                     'textwrap function' );
   need_file( 'get_barefrom.func',                 'get_barefrom function' );
   need_file( 'fill_paragraphs.func',              'fill_paragraphs function' );
   need_file( 'decode_mime_string.func',           'decode_mime_string function' );
   need_file( 'full_mailbox_list.func',            'full_mailbox_list function' );        # -- Mailbox listing functions --
   need_file( 'mailbox_list.func',                 'mailbox_list function' );             # -- Mailbox listing functions --
   need_file( 'reload_frame.func',                 'reload_frame function' );
   need_file( 'validate_login.func',               'validate_login function' );
   need_file( 'status.func',                       'status function' );
   need_file( 'caching_headers.func',              'caching_headers function' );
   need_file( 'init_db.func',                      'init_db function' );
   
}

sub build_imp_lib {
   needs_horde_copyright();
   need_file( 'ImpLibVersion.def',                 'ImpLibrary Version' );
   need_file( 'IncludeHordeLib.init',              'Include Horde Lib' );
   need_file( 'InitImpDefaults.init',              'Init Imp Defaults object' );
   need_file( 'InitHelp.init',                     'Init Horde Help' );
}


##### --- #####
sub build_lib {

   print "Building : $horde_lib_name\n";
	open( HORDE_LIB, "> $horde_lib_name" )
   	|| die "ERROR : Could not open horde lib for writing.\nEXITING\nERROR : $!\n";

	print HORDE_LIB "<?php\n\n";
   print "\n\tIncludes :\n";
   build_ext_file( HORDE_LIB, "inc" );
   print "\n\tDefines :\n";
   build_ext_file( HORDE_LIB, "def" );
   print "\n\tObjects :\n";
   build_ext_file( HORDE_LIB, "object" );
   print "\n\tFunctions :\n";
   build_ext_file( HORDE_LIB, "func" );
   print "\n\tInit :\n";
   build_ext_file( HORDE_LIB, "init" );
   print "\n";
	print HORDE_LIB "?>\n";
	close( HORDE_LIB );
}

sub build_ext_file {
   local( *OUT_FH, $ext_to_process )  = @_;
   if ( $ext_to_process ne "init" ) {
	   foreach $file_key ( sort keys %FILE_COMMENTS ) {
   	   ( @temp_data ) = split( /\./, $file_key );
	      $file_ext = $temp_data[ ( @temp_data - 1) ];
  	 	   $base_dir = '';
         if ( $file_ext ne $ext_to_process ) {     next; }
         if ( $FILE_NEEDED{ $file_key } != 1 ) {   next; }
  		   if ( $file_ext eq "inc"    ) {   $base_dir = $inc;  }
   	   if ( $file_ext eq "def"    ) {   $base_dir = $def;  }
   	   if ( $file_ext eq "func"   ) {   $base_dir = $func; }
   	   if ( $file_ext eq "object" ) {   $base_dir = $obj;  }
         if ( $file_ext eq "init" )   {   $base_dir = $init; }
         if ( $file_ext eq "object" && $file_key =~ /Html/ ) { 
            $base_dir .= "Html/";
         }
         if ( $file_key =~ /\// ) { # It's already got a path in it 
            $base_dir = '';
         };
   	   add_file( OUT_FH, $base_dir . $file_key, $FILE_COMMENTS{ $file_key } );
	   }

   } else {
	   foreach $file_key ( sort keys %FILE_COMMENTS ) {
   	   ( @temp_data ) = split( /\./, $file_key );
	      $file_ext = $temp_data[ ( @temp_data - 1) ];
  	 	   $base_dir = '';
         if ( $file_ext ne $ext_to_process ) {     next; }
         if ( $FILE_NEEDED{ $file_key } != 1 ) {   next; }
         if ( $file_ext eq "init" )   {   $base_dir = $init; }
   	   add_file( OUT_FH, $base_dir . $file_key, $FILE_COMMENTS{ $file_key } );
      }

   }
}

sub add_file {
   local( *OUT_FH, $filename, $comment ) = @_;
   print "\tAdding file : $filename\n";

   if ( $comment ne "" ) {
   print OUT_FH <<"FILE_COMMENT";
/*
$comment      : $filename
*/
FILE_COMMENT
   }

   open( IN_FH, $filename ) || warn "WARNING : Unable to open : $filename\nERROR : $!\n";
   while( <IN_FH> ) { print OUT_FH $_; }
   close( IN_FH );   

   print OUT_FH <<"EOF";
/*      EOF - $filename       */



EOF

}

sub print_usage {
   print <<"USAGE"

buildlib.pl : Horde Library build program.

   This program builds a horde.lib and a client library for each
   module that is provided as a command line option to this program.
   So if you wanted to build a library that was inclusive for nag
   and imp you would run :
      ./buildlib.pl --imp --nag

   Another example would be :
      ./buildlib.pl --imp --with-mysql --nag

   Available modules :
      --imp
      --nag
      

   Available option flags :
      Database flags -

         --with-v1[=no]

            Turns on/off the v1 database functions. Needed for
            compatibility with pre v2 imp versions.

         --with-v2[=no]

            Turns on/off the v2 database functions.

         --with-mysql[=no]
         --with-informix[=no]
         --with-oracle[=no]
         --with-postgres[=no]

            Turns on/off the support for that database.


      Output flags -         

         --target-dir=[ Output directory ]  

            Changes the output directory for the libraries.
      
      Help flags -

         -?
         --?
         -help
         --help


USAGE
}
