<?php

require( './lib/imp.lib' );
require( './config/ldap.php3' );
require( './config/defaults.php3' );
$language = select_lang();
require ("./locale/$language/ldap.user.lang");
require ('./locale/local/ldap.user.lang');

error_reporting($default->error_level);

$cookies = new ImpCookies();
$server = $cookies->get_server();


/* send headers to ensure that the page will reload correctly. */
caching_headers();

$title            = '';
$sidebar          = true;

require( "$default->include_dir/generic-header.inc" );

?>


<script language="JavaScript">

function ClearAttr() {
   while ( document.ldap_form.attr_type.options.length > 0 ) {
      document.ldap_form.attr_type.options[0] = null; 
   }
}

function ClearOptions() {
   while ( document.ldap_form.ldap_options.options.length > 0 ) {
      document.ldap_form.ldap_options.options[0] = null;
   }
}

function AddOption(attr) {
   
   switch(attr) {
      
    case "uid":
      var uid = new Option("<?php echo $lang->uid; ?>", uid, defaultSelected=0, selected=0);
      document.ldap_form.attr_type.options[document.ldap_form.attr_type.options.length] = new Option("<?php echo $lang->uid; ?>");
      break;
      
    case "mail":
      var mail = new Option("<?php echo $lang->mail; ?>", mail, defaultSelected=0, selected=0);
      document.ldap_form.attr_type.options[document.ldap_form.attr_type.options.length] = new Option("<?php echo $lang->mail; ?>");
      break;
      
    case "sn":
      var sn = new Option("<?php echo $lang->sn; ?>", sn, defaultSelected=0, selected=0);
      document.ldap_form.attr_type.options[document.ldap_form.attr_type.options.length] = new Option("<?php echo $lang->sn; ?>");
      break;
      
    case "givenname":
      var givenname = new Option("<?php echo $lang->givenname; ?>", givenname, defaultSelected=0, selected=0);
      document.ldap_form.attr_type.options[document.ldap_form.attr_type.options.length] = new Option("<?php echo $lang->givenname; ?>");
      break;
      
    case "ou":
      var ou = new Option("<?php echo $lang->ou; ?>", ou, defaultSelected=0, selected=0);
      document.ldap_form.attr_type.options[document.ldap_form.attr_type.options.length] = new Option("<?php echo $lang->ou; ?>");
      break;
      
    case "cn":
      var cn = new Option("<?php echo $lang->cn; ?>", cn, defaultSelected=1, selected=1);
      document.ldap_form.attr_type.options[document.ldap_form.attr_type.options.length] = new Option("<?php echo $lang->cn; ?>");
      break;
      
    case "begins":
      var begins = new Option("<?php echo $lang->begins; ?>", begins, defaultSelected=0, selected=0);
      document.ldap_form.ldap_options.options[document.ldap_form.ldap_options.options.length] = new Option("<?php echo $lang->begins; ?>");
      break;
      
    case "contains":
      var contains = new Option("<?php echo $lang->contains; ?>", contains, defaultSelected=0, selected=0);
      document.ldap_form.ldap_options.options[document.ldap_form.ldap_options.options.length] = new Option("<?php echo $lang->contains; ?>");
      break;
      
    case "ends":
      var ends = new Option("<?php echo $lang->ends; ?>", ends, defaultSelected=0, selected=0);
      document.ldap_form.ldap_options.options[document.ldap_form.ldap_options.options.length] = new Option("<?php echo $lang->ends; ?>");
      break;
      
    case "is_strict":
      var is_strict = new Option("<?php echo $lang->is_strict; ?>", is_strict, defaultSelected=0, selected=0);
      document.ldap_form.ldap_options.options[document.ldap_form.ldap_options.options.length] = new Option("<?php echo $lang->is_strict; ?>");
      break;
      
    case "is":
      var is = new Option("<?php echo $lang->is; ?>", is, defaultSelected=1, selected=1);
      document.ldap_form.ldap_options.options[document.ldap_form.ldap_options.options.length] = new Option("<?php echo $lang->is; ?>");
      break;
      
    case "sounds":
      var sounds = new Option("<?php echo $lang->sounds; ?>", sounds, defaultSelected=0, selected=0);
      document.ldap_form.ldap_options.options[document.ldap_form.ldap_options.options.length] = new Option("<?php echo $lang->sounds; ?>");
      break;
      
   }
}


function StandardOptions() {
<?php

$i = 0;
reset($LDAPServers);
while (list($key, $lserver) = each($LDAPServers)) {
   $options = explode(',', $lserver->options);
   
   if ($i == 0) echo "if (document.ldap_form.ldap_serv.options[$i].selected) {\n";
   else echo "else if (document.ldap_form.ldap_serv.options[$i].selected) {\n";
   
   echo "   ClearOptions();\n";
   for ($j = 0; $j < count($options); $j++)
     echo "   AddOption(\"$options[$j]\");\n";
   
   echo "}\n\n";
   $i++;
}

?>
}


function UpdateSelect() {

<?php

$i = 0;
reset($LDAPServers);
while (list($key, $lserver) = each($LDAPServers)) {
   $options = explode(',', $lserver->attribs);
   
   if ($i == 0) echo "if (document.ldap_form.ldap_serv.options[$i].selected) {\n";
   else echo "else if (document.ldap_form.ldap_serv.options[$i].selected) {\n";
   
   echo "   ClearAttr();\n";
   for ($j = 0; $j < count($options); $j++)
     echo "   AddOption(\"$options[$j]\");\n";
   
   echo "}\n\n";
   $i++;
}

?>

   StandardOptions();
}


function UpdateOptions() {
   
   StandardOptions();
   
   for(i=0 ; i < 6 ; i++) {
      if ( document.ldap_form.attr_type.options[i] ) {
         if ( document.ldap_form.attr_type.options[i].selected ) {
	    
            switch (document.ldap_form.attr_type.options[i].text) {
	     case "<?php echo $lang->mail; ?>":
	       if ( document.ldap_form.ldap_serv.options[0].selected ) {
		  ClearOptions();
		  AddOption("is_strict");
		  
	       }
	       
	       if ( document.ldap_form.ldap_serv.options[1].selected ) {
		  ClearOptions();
		  AddOption("is_strict");
                  
	       }
	       
	       if ( document.ldap_form.ldap_serv.options[2].selected ) {
		  ClearOptions();
		  AddOption("is_strict");
                  
	       }
	       
	     case "<?php echo $lang->sn; ?>":
	       if ( document.ldap_form.ldap_serv.options[1].selected ) {
		  ClearOptions();
		  AddOption("is_strict");
		  
	       }
	       
            }
         }
      }
   }

document.ldap_form.ldap_options.options[0].selected = true;
   
}

</script>

<center>

<form name="ldap_form" ACTION="ldap.search.php3" target="ldap_result" METHOD=POST>

<table border=0 cellpadding=0 cellspacing=0><tr><td bgcolor="<?php echo $default->dark_bg ?>">
<FONT SIZE="-1"><?php echo $lang->search; ?> &nbsp;</FONT>

<select name="ldap_serv" onChange=UpdateSelect()>
<?php

reset($LDAPServers);
$i = 1;
while (list($key, $lserver) = each($LDAPServers)) {
   if ($i) {
      echo '<option value="' . $lserver->tag . '" selected>' . $lserver->name . "\n";
      $i = 0;
   } else echo '<option value="' . $lserver->tag . '">' . $lserver->name . "\n";
}

?>
</select>

<font size="-1"> <?php echo $lang->directory . " " . $lang->where; ?>&nbsp;</font>

<select name="attr_type" onChange=UpdateOptions() onLoad=UpdateSelect()>
<?php

reset($LDAPServers);
list($key, $lserver) = each($LDAPServers);
$options = explode(',', $lserver->attribs);

for ($i = 0; $i < count($options); $i++) {
   echo "<option value=\"$options[$i]\">" . $lang->$options[$i] . "\n";
}

?>
</select>

<select name="ldap_options">
<?php

reset($LDAPServers);
list($key, $lserver) = each($LDAPServers);
$options = explode(',', $lserver->options);

for ($i = 0; $i < count($options); $i++) {
   echo "<option value=\"$options[$i]\">" . $lang->$options[$i] . "\n";
}

?>
</select>

<input type="text" name="s_text">
<input type="submit" name="submit_button" value="<?php echo $lang->submit_button; ?>">

</td></tr></table>
</form>

</center>

<?php require( "$default->include_dir/generic-footer.inc" ); ?>
