<?php

/*
 
 File: config/lang.php3
 $Author: chuck $
 $Revision: 1.8 $
 $Date: 1999/01/13 21:27:21 $
 
 IMP: Copywrite 1998 Charles J. Hagenbuch chuck@horde.org
 
 This code is under the GNU Public License
 See the file COPYING in this directory
 
 */

$default->lang['cs'] = 'Czech';
$default->lang['da'] = 'Danish';
$default->lang['de'] = 'German';
$default->lang['en'] = 'English';
$default->lang['es'] = 'Spanish';
$default->lang['fr'] = 'French';
$default->lang['no'] = 'Norwegian';
$default->lang['ru'] = 'Russian';

function select_lang () {
   global $HTTP_ACCEPT_LANGUAGE, $chuckmIMPlang, $default;
   
   if (isset($chuckmIMPlang) && valid_lang($chuckmIMPlang)) return $chuckmIMPlang;
   else if (isset($HTTP_ACCEPT_LANGUAGE)) {
      $langs = explode(',', $HTTP_ACCEPT_LANGUAGE);
      array_walk($langs, 'mytrim');
      
      $found = false;
      $i = 0;
      while (!$found && ($i < count($langs))) {
	 if (valid_lang($langs[$i])) $found = true;
	 else $i++;
      }
      if ($found) return $langs[$i];
      else return $default->language;
   } else return $default->language;
}

function mytrim ($item) {
   $item = trim($item);
}

function valid_lang ($lang) {
   if (@is_dir("./locale/$lang")) return true;
   else return false;
}

?>
