<?php

/*
 
 File: config/examples/mimetypes.php3
 $Author: chuck $
 $Revision: 1.4 $
 $Date: 1999/01/09 01:46:35 $
 
 IMP: Copywrite 1998 Charles J. Hagenbuch chuck@horde.org
 
 This code is under the GNU Public License
 See the file COPYING in this directory
 
 */

// this file contains user-contributed mimetypes for various kinds of data
// add them to mime.conf if you want them.



// From: Joao Pedro Goncalves <joaop@iscsp.utl.pt>
// .zip - Uses zipinfo.
// Define $default->path_to_unzip in defaults.conf.

$mime_actions["application/zip"] = array("action" => "default",
					 "view" => true,
					 "view_function" => "mime_view_zip",
					 "download" => true,
					 "icon" => "mime_compressed.gif" );

function mime_view_zip( $mime ) {
   global $mbox, $default;
   $mime->fetch_contents();
   $zip_name = "/tmp/imp.zip.".date("Y-M-D_H:i:s")."__".md5($mime->contents);
   $fh = fopen( $zip_name, "w" );
   fwrite( $fh, imap_base64( $mime->contents ) );
   fclose( $fh );
   $pipe = popen("$default->path_to_unzip -m $zip_name  2>&1 |grep -v Archive","r");
   $data = "<b><u>Contents of ZIP file</u></b><br><table><tr><td align=left><pre>";
   while( ($rc=fgets($pipe,10)) )
     $data.= $rc;
   pclose( $pipe );
   $data .="</pre></td></tr></table><br><b><u>Details of ZIP file</u></b><br><table><tr><td align=left><pre>";
   $pipe = popen("$default->path_to_unzip -mvh $zip_name  2>&1 |grep -v Archive","r");
   while( ($rc=fgets($pipe,10)) )
     $data.= $rc;
   pclose( $pipe );
   $data .="</pre></td></tr></table>";
   unlink("$zip_name");
   return $data;
}


// From: Joao Pedro Goncalves <joaop@iscsp.utl.pt>
// .tgz - Uses GNU tar that allows -z flag for compressed files.
// Define $default->path_to_tar in defaults.conf

$mime_actions["application/x-gtar"] = array("action" => "default",
					    "view" => true,
					    "view_function" => "mime_view_tgz",
					    "download" => true,
					    "icon" => "mime_compressed.gif" );


function mime_view_tgz( $mime ) {
   global $mbox, $default;
   $mime->fetch_contents();
   $tgz_name = "/tmp/imp.".date("s")."__".md5($mime->contents).".tgz";
   $fh = fopen( $tgz_name, "w" );
   fwrite( $fh, imap_base64( $mime->contents ) );
   fclose( $fh );
   $pipe = popen("$default->path_to_tar tvfz $tgz_name  2>&1","r");
   $data = "<b><u>Query Gzipped Tarball</u></b><br><table><tr><td align=left><pre>";
   while( ($rc=fgets($pipe,10)) )
     $re.= $rc;
   pclose( $pipe );
   $data .= fill_paragraphs(htmlentities($re));
   $data .="</pre></td></tr></table>";
   unlink("$tgz_name");
   return $data;
}


// From: Joao Pedro Goncalves <joaop@iscsp.utl.pt>
// .rpm - RedHat packages.
// Define $default->path_to_rpm in defaults.conf.

$mime_actions["/x-pn-realaudio-plugin"] = array("action" => "default",
						"view" => true,
						"view_function" => "mime_view_rpm",
						"download" => true,
						"icon" => "mime_rpm.gif" );

function mime_view_rpm( $mime ) {
   global $mbox, $default;
   $mime->fetch_contents();
   $rpm_name = "/tmp/imp.rpm.".date("Y-M-D_H:i:s")."__".md5($mime->contents);
   $fh = fopen( $rpm_name, "w" );
   fwrite( $fh, imap_base64( $mime->contents ) );
   fclose( $fh );
   $pipe = popen("$default->path_to_rpm -qip $rpm_name  2>&1","r");
   $data = "<b><u>Query RPM Package</u></b><br><table><tr><td align=left><pre>";
   while( ($rc=fgets($pipe,10)) )
     $re.= $rc;
   pclose( $pipe );
   $data .= fill_paragraphs(htmlentities($re));
   $data .="</pre></td></tr></table>";
   unlink("$rpm_name");
   return $data;
}


// From: Dave <dcaplinger@orent.com>
// unfiltered html viewer

/* Note that currently this isn't doing any filtering of "evil" tags
 * such as <EMBED> etc.  I'm comfortable with this in my environment
 * (where IMP is used for internal email) but you may not be in yours.
 */

$mime_actions["text/html"] = array("action" => "default",
				   "view" => true,
				   "view_function" => "mime_view_html",
				   "download" => true,
				   "icon" => "mime_html.gif" );

function mime_view_html( $mime ) {
   global $mbox, $default;
   $mime->fetch_contents();
   
   /*
    // If you want to filter, you probably want this code instead.
    $html_name = "/tmp/imp.html.".date("Y-M-D_H:i:s")."__".md5($mime->contents);
    $fh = fopen( $html_name, "w" );
    fwrite( $fh, imap_qprint( $mime->contents ) );
    fclose( $fh );
    
    $pipe = popen("/bin/cat $html_name","r");
    $data = "";
    // Here is where you could filter $data to remove <EMBED>, etc.
    // or we could have had the external program to do it in place of
    // /bin/cat (which is probably faster than doing it in PHP3!)
    
    while( ($rc=fgets($pipe,8192)) )
    $data.=$rc;
    pclose( $pipe );
    unlink($html_name);
    */
   /* but I'm going to do it all in-memory and skip disk i/o */
   if ($mime->encoding == 4) {
      $data = imap_qprint( $mime->contents );
   } else {
      $data = $mime->contents;
   }
   
   return $data;
}
