#!/usr/bin/perl
# build_implib.pl
#
local( $horde_lib_name ) = "../imp.lib";
local( @FILE_ORDER );
local( %FILE_COMMENTS );
local( $inc, $def, $func, $obj );

$inc  = 'includes/';
$def  = 'defines/';
$func = 'functions/';
$obj  = 'objects/';
$init = 'initialization/';

@FILE_ORDER = (
         ## - Includes - ##
         'HordeCopyright.inc',
         'IncludeHordeLib.init',
         ## - Defines - ##
         'ImpLibVersion.def',
         'Actions.def',
         ## - Objects - ##
         ## - Functions - ##
         'wrap_message.func',
         'textwrap.func',
	 'get_barefrom.func',
         'fill_paragraphs.func',
         'decode_mime_string.func',
         'full_mailbox_list.func',
         'mailbox_list.func',
	 'reload_frame.func',
         'validate_login.func',
         'status.func',
         'caching_headers.func',
         ## - Initialize items - ##
         'InitImpDefaults.init',
	 'InitHelp.init',
);

## - Includes - ##
## - Defines - ##
$FILE_COMMENTS{ 'ImpLibVersion.def' }                                = 'ImpLibrary                 Version';
$FILE_COMMENTS{ 'Actions.def' }                                      = 'Form Action                Defines';
## - Objects - ##
## - Functions - ##
$FILE_COMMENTS{ 'wrap_message.func' }                                = 'wrap_message               Function';
$FILE_COMMENTS{ 'textwrap.func' }                                    = 'textwrap                   Function';
$FILE_COMMENTS{ 'get_barefrom.func' }                                = 'get_barefrom               Function';
$FILE_COMMENTS{ 'fill_paragraphs.func' }                             = 'fill_paragraphs            Function';
$FILE_COMMENTS{ 'decode_mime_string.func' }                          = 'decode_mime_string         Function';
$FILE_COMMENTS{ 'full_mailbox_list.func' }                           = 'full_mailbox_list          Function';
$FILE_COMMENTS{ 'mailbox_list.func' }                                = 'mailbox_list               Function';
$FILE_COMMENTS{ 'validate_login.func' }                              = 'validate_login             Function';
$FILE_COMMENTS{ 'status.func' }                                      = 'status                     Function';
$FILE_COMMENTS{ 'print_help_js.func' }											= 'print_help_js					Function';
$FILE_COMMENTS{ 'show_help.func' }												= 'show_help						Function';
$FILE_COMMENTS{ 'add_help_item.func' }											= 'add_help_item					Function';


open( HORDE_LIB, "> $horde_lib_name" )
   || die "ERROR : Could not open horde lib for writing.\nEXITING\nERROR : $!\n";
print HORDE_LIB "<?php\n\n";
foreach $file_key ( @FILE_ORDER ) {
   ( @temp_data ) = split( /\./, $file_key );
   $file_ext = $temp_data[ ( @temp_data - 1) ];
   $base_dir = '';
   if ( $file_ext eq "inc" ) {   $base_dir = $inc; }
   if ( $file_ext eq "def" ) {   $base_dir = $def; }
   if ( $file_ext eq "func" ) {  $base_dir = $func; }
   if ( $file_ext eq "obj" ) {   $base_dir = $obj; }
   if ( $file_ext eq "init" ) {  $base_dir = $init; }
   add_file( HORDE_LIB, $base_dir . $file_key, $FILE_COMMENTS{ $file_key } );
}
print HORDE_LIB "?>\n";
close( HORDE_LIB );

sub add_file {
   local( *OUT_FH, $filename, $comment ) = @_;

   if ( $comment ne "" ) {
   print OUT_FH <<"FILE_COMMENT";
/*
$comment      : $filename
*/
FILE_COMMENT
   }

   open( IN_FH, $filename ) || print STDERR "WARNING : Unable to open : $filename\nERROR : $!\n";
   while( <IN_FH> ) { print OUT_FH $_; }
   close( IN_FH );   

   print OUT_FH <<"EOF";
/*      EOF - $filename       */



EOF

}
