<?php

/*
 
 File: compose.php3
 $Author: chuck $
 $Revision: 1.113 $
 $Date: 1999/01/14 04:56:45 $
 
 IMP: Copyright 1999 Charles J. Hagenbuch <chuck@horde.org>
 
 You should have received a copy of the GNU Public
 License along with this package; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 
 */


/* format a from: address correctly based on all relevant factors... */
function get_from($user, $server) {
   global $default, $from;
   
   if ($default->user_change_fullname) {
      $name = imp_get_fullname($user, $server);
   }
   if (!isset($name) || !$name) $name = '';
   
   if (!isset($from) || !$from || !$default->user_change_from) { 
      $from = '';
      if ($name) {
	 $from  = $name;
	 $from .= ' <';
      }
      $from .= get_barefrom($user, $server);
      if ($name) {
	 $from .= '>'; 
      }
   }
   
   return $from;
}

/* obtain the -0400 or whatever it is for your offset for the date header */
function gm_offset() {
   $offset = ((date("H") - gmdate("H")));
   if ($offset >= 0) { return sprintf("+%02d", $offset) . "00"; }
   else { return sprintf("-%02d", -$offset) . "00"; }
}

/* function that interfaces to sendmail, so from address and all headers
 * are set correctly
 */

function mailfrom($to, $from, $barefrom, $subject, $hdrs, $mesg) {
   global $default;
   
   $hdrs .= "Sender: $barefrom\n";
   if ($default->append_header)  $hdrs .= implode(@file('./config/header.txt'), '');
   if ($default->append_trailer) $mesg .= "\n" . implode(@file('./config/trailer.txt'), '');
   
   if (is_executable($default->path_to_sendmail)) {
      $mail = popen("$default->path_to_sendmail -t -i -f '$barefrom'", 'w');
      
      $result  = fputs($mail, "From: $from\n");
      $result += fputs($mail, "To: $to\n");
      $result += fputs($mail, $hdrs);
      $result += fputs($mail, "Subject: $subject\n\n");
      $result += fputs($mail, $mesg);
      
      pclose($mail);
      
   } else {
      
      $hdrs = "From: $from\n" . $hdrs;
      
      if (mail($to, $subject, $mesg, $hdrs)) { $result = 1; }
      else { $result = 0; }
   }
   
   if ($result > 0) { return 1; }
   else { return 0; }
}


require ('./lib/imp.lib');                   /* IMPlib is the IMP function library  */
require ('./config/defaults.php3');          /* Defaults configuration file         */
if ($default->ssl->enabled) { include( './lib/ssl.lib' ); }
require ('./lib/mime.lib');                  /* Mime lib for composing mime messages */
require ('./lib/signature.lib');             /* Verification of S/MIME and IMP sigs */
$db = init_db(); 										/* V1/V2 Database init */
$language = select_lang();
require ("./locale/$language/compose.lang");
require ("./locale/local/compose.lang");
error_reporting($default->error_level);      /* set error level from imp.lib   */

/* send headers to ensure that the page will reload correctly. */
caching_headers();

$cookies = new ImpCookies();
$user    = $cookies->get_user();
$pass    = $cookies->get_password();
$server  = $cookies->get_server();
$port    = $cookies->get_port();
$folders = $cookies->get_folder();
if (!isset($mailbox)) { $mailbox = 'INBOX'; }
$get_sig = true;

/* login */
$mbox = validate_login($server, $port, $mailbox, $user, $pass);

/* array to translate string actions into the appropriate integer ID */
$actions[$lang->button_send]          = SEND_MESSAGE;
$actions[$lang->button_postpone]      = POSTPONE_MESSAGE;
$actions[$lang->button_attach]        = ADD_ATTACHMENT;
$actions[$lang->button_delete_attach] = DELETE_ATTACHMENT;
$actions[$lang->button_bounce]        = BOUNCE_MESSAGE;

/* doctype */
require("$default->include_dir/doctype.inc");

/* Run through action handlers */

if (isset($actionID)) {
   /* translate non-int values into the correct int */
   if (strcspn($actionID, '0123456789')) { $actionID = $actions[$actionID]; }
   
   switch ($actionID) {
    case NO_ACTION:
      status($lang->status_composition);
      $ACTION_TEXT = $lang->status_composition;
      break;

    case MAILTO:
      if ($mailbox && $index && $bodypart) {
	 $h = imap_header($mbox, imap_msgno($mbox, $index));
	 if ($h->reply_toaddress) { $to = chop(htmlspecialchars($h->reply_toaddress)); }
	 else { $to = chop(htmlspecialchars($h->fromaddress )); }
/*	 
	 $msg  = $lang->quoting_string . ' ' . chop(htmlspecialchars($h->fromaddress)) . ":\n\n&gt; ";
	 $msg .= htmlspecialchars(wrap_message(imap_fetchbody($mbox, $index, $bodypart, FT_UID), 75, "\n> "));
	 $msg .= "\n";
 
	 if (isset($h->subject) && (strtolower(substr($h->subject, 0, 3)) != 're:')) $subject = 'Re: ' . chop(htmlspecialchars($h->subject));
	 elseif (isset($h->subject)) $subject = chop(htmlspecialchars($h->subject));
	 else $subject = 'Re: ';
*/
	 
      	$ACTION_TEXT = $lang->action_compose;
      }	
      break;
      
    case REPLY:
      if ($mailbox && $index && $bodypart) {
	 $h = imap_header($mbox, imap_msgno($mbox, $index));
	 if (isset($h->reply_toaddress)) { $to = chop(htmlspecialchars($h->reply_toaddress)); }
	 elseif (isset($h->fromaddress)) { $to = chop(htmlspecialchars($h->fromaddress )); }
	 else $to = '';
	 
	 if (isset($h->fromaddress)) $qfrom = chop(htmlspecialchars($h->fromaddress));
	 else $qfrom = '&lt;&gt;';
	 
	 $msg  = $lang->quoting_string . ' ' . $qfrom . ":\n\n&gt; ";
	 $msg .= htmlspecialchars(wrap_message(imap_fetchbody($mbox, $index, $bodypart, FT_UID), 75, "\n> "));
	 $msg .= "\n";
	 
	 if (isset($h->subject) && (strtolower(substr($h->subject, 0, 3)) != 're:')) $subject = 'Re: ' . chop(htmlspecialchars($h->subject));
	 elseif (isset($h->subject)) $subject = chop(htmlspecialchars($h->subject));
	 else $subject = 'Re: ';
	 
	 $ACTION_TEXT = $lang->action_reply . ' ' . chop(htmlspecialchars($subject));
      }
      break;
      
    case REPLY_ALL:
      if ($mailbox && $index && $bodypart) {
	 $h = imap_header($mbox, imap_msgno($mbox, $index));
	 if ($h->reply_toaddress) { $reply = chop(htmlspecialchars($h->reply_toaddress)); }
	 else { $reply = chop(htmlspecialchars($h->fromaddress )); }
	 
	 /* build up the reply to all addresses */
	 if ($reply != chop(htmlspecialchars($h->fromaddress ))) { $to = $reply . ',' . chop(htmlspecialchars($h->fromaddress )); }
	 else { $to = $reply; }
	 if ( $reply != chop(htmlspecialchars($h->toaddress )) ) { $to .= "," . chop(htmlspecialchars($h->toaddress )); }
	 if (isset($h->ccaddress)) { $to .= ',' . chop(htmlspecialchars($h->ccaddress )); }
	 
	 $msg  = $lang->quoting_string . ' ' . chop(htmlspecialchars($h->fromaddress)) . ":\n\n&gt; ";
	 $msg .= htmlspecialchars(wrap_message(imap_fetchbody($mbox, $index, $bodypart, FT_UID), 75, "\n> "));
	 $msg .= "\n";
	 
	 if (strtolower(substr($h->subject, 0, 3)) != 're:') $subject = 'Re: ' . chop(htmlspecialchars($h->subject));
	 else $subject = chop(htmlspecialchars($h->subject));
	 
	 $ACTION_TEXT = $lang->action_reply_all . ' ' . chop( htmlspecialchars( $h->subject ) );
	 
      }
      break;
      
    case FORWARD:
      if ($mailbox && $index && $bodypart) {
	 $h = imap_header($mbox, imap_msgno($mbox, $index));
	 $message_source = chop(htmlspecialchars($h->fromaddress));
	 $barefrom = get_barefrom($user, $server);
	 $from = get_from($user, $server);
	 
	 $msg  = "\n" . $lang->forwarded_from($message_source) . "\n";
	 
	 if ($h->date) { $msg .= 'Date: ' . chop(htmlspecialchars($h->date)) . "\n"; }
	 if ($h->fromaddress) { $msg .= 'From: ' . chop(htmlspecialchars($h->fromaddress)) . "\n"; }
	 if ($h->reply_toaddress) { $msg .= 'Reply-To: ' . chop(htmlspecialchars($h->reply_toaddress)) . "\n"; }
	 if ($h->subject) { $msg .= 'Subject: ' . chop(htmlspecialchars($h->subject)) . "\n"; }
	 if ($h->toaddress) { $msg .= 'To: ' . chop(htmlspecialchars($h->toaddress)) . "\n"; }
	 $msg .= "\n";
	 $msg .= htmlspecialchars(wrap_message(imap_fetchbody($mbox, $index, $bodypart, FT_UID)));
	 $msg .= "\n----- " . $lang->forward_end_string . " -----\n";
	 
	 $subject = $lang->fwd_string . ' ' . chop(htmlspecialchars($h->subject));
	 $ACTION_TEXT = $lang->action_forward . ' ' . chop( htmlspecialchars( $h->subject ) );
      }
      break;
      
    case BOUNCE_MESSAGE:
      if ($mailbox && $index && $to) {
	 
	 $h = imap_header($mbox, imap_msgno($mbox, $index));
	 $barefrom = get_barefrom($user, $server);
	 
	 if (isset($h->fromaddress)) { $from = $h->fromaddress;
	 } else $from = '';
	 if (isset($h->subject)) { $subject = $h->subject;
	 } else $subject = '';
	 
	 $msg = imap_body($mbox, $index, FT_UID);
	 $hdrs = '';
	 
	 if (mailfrom($to, $from, $barefrom, $subject, $hdrs, $msg)) {
	    status($lang->status_bounce_success);
	    
	    if ($default->save_sent_mail) {
	       $fcc  = 'Date: ' . date("D, d M H:i:s Y ") . gm_offset() . "\n";
	       $fcc .= 'To: ' . $to . "\n";
	       $fcc .= "From: $from\n";
	       $fcc .= 'Subject: ' . $subject . "\n";
	       $fcc .= $hdrs;
	       $fcc .= "\n";
	       $fcc .= $msg;
	    }
	    
	    echo '<script language=javascript>window.location="mailbox.php3?mailbox=' . $mailbox . '";</script>';
	    exit;
	 }
	 
	 unset($to);
	 unset($subject);
	 unset($msg);
	 unset($from);
	 unset($barefrom);
	 unset($hdrs);
	 unset($h);
      }
      break;
      
    case SEND_MESSAGE:
      
      if (isset($is_reply) && isset($index) && isset($mailbox) && $is_reply) 	 imap_setflag_full($mbox, $index, '\\ANSWERED', SE_UID);
      
      if (isset($attachments_name) && !is_array($attachments_name)) { $attachments = array($attachments_name); }
      if (isset($attachments_size) && !is_array($attachments_size)) { $attachments = array($attachments_size); }
      if (isset($attachments_file) && !is_array($attachments_file)) { $attachments = array($attachments_file); }
      if (isset($attachments_type) && !is_array($attachments_type)) { $attachments = array($attachments_type); }
      
      if ($to && $message) {
	 
	 if( $deliver_signed == "yes" ) {
	    
	    $sig = new signature_rc;
	    $sig->sig = $signature;
	    $sig->data = $message;
	    
	    signature_verify_syntax( &$sig );
	    signature_verify_pkcs7( &$sig );
	    
	    echo signature_display( &$sig );
	    
	    /* Check the check syntax and (if they have p7verify) the validity */
	    $valid = true;
	    if( !$sig->valid_syntax ) { $valid = false; }
	    if( $valid && !isset($default->path_to_p7verify)
	       && strlen($default->path_to_p7verify) &&
	       (!$sig->valid_certs || !$sig->valid_hash ))
	    { $valid = false; }
	    
	    if( !$valid ) {
	       echo $lang->sig_valid_error;
	       
	       $get_sig = false;
	       $msg = $message;
	       
	       /* Delete the attachments the user tried to send. */
	       for ($i = 0; $i < count ($attachments_name); $i++) {
		  unlink ($attachments_file);
	       }
	       
	       echo "&nbsp &nbsp</td></tr></table>\n";
	       $ACTION_TEXT = '';
	       break;
	    }
	 }
	 
	 /* somehow need to verify email addresses */
	 
	 // move these checks into javascript expand function
	 if (!strstr($to, '@')) $to .= "@$server";
	 if ((strlen($cc) > 0) && !strstr($cc, '@')) { $cc .= "@$server"; }
	 
	 $mime = new mime_message;
	 $mime->init( $message.$signature );
	 
	 $text_part = new mime_part;
	 $text_part->contents = wrap_message($message, 80, "\n");
	 $mime->add_begin_part( $text_part );
	 
	 if( $deliver_signed == "yes" ) {
	    /* Added the mime part for the signature */
	    if( !empty($signature) ) {
	       $sig_part = new mime_part;
	       $sig_part->type = "APPLICATION";
	       $sig_part->subtype = "X-IMP-SIGNATURE";
	       $sig_part->transfer_encoding = "base64";
	       $sig_part->description = "IMP/Netscape Object Signature for message body";
	       $sig_part->contents = $signature;
	       $mime->add_middle_part( $sig_part );
	    }
	 }
	 
	 if (count ($attachments_name) > 0) {
	    for ($i = 0; $i < count ($attachments_name) - 1; $i++) {
	       $fd = fopen( $attachments_file[$i], "r" );
	       $contents = fread( $fd, $attachments_size[$i]);
	       fclose( $fd ); 
	       unlink($attachments_file[$i]);
	       
	       $file_part = new mime_part;
	       
	       /* some browsers do not send mime type */
	       if (strcmp($attachments_type[$i], "")) { 
		  $file_part->parse_full_type( $attachments_type[$i] );
	       } else { 
		  $file_part->parse_full_type( "text/plain" );
	       }
	       
	       $file_part->transfer_encoding = "base64";
	       $file_part->name = $attachments_name[$i];
	       $file_part->contents = $attachments_size < 100000 ? 
		 fill_paragraphs(base64_encode($contents), 80, "\n", '')
		   : base64_encode($contents);
	       $mime->add_middle_part( $file_part );
	    }
	    
	    $i = count ($attachments_name) - 1;
	    
	    $fd = fopen( $attachments_file[$i], "r" );
	    $contents = fread( $fd, $attachments_size[$i]);
	    fclose( $fd ); 
	    unlink($attachments_file[$i]);
	    
	    $file_part = new mime_part;
	    
	    /* some browsers do not send mime type */
	    if (strcmp($attachments_type[$i], "")) { 
	       $file_part->parse_full_type( $attachments_type[$i] );
	    } else { 
	       $file_part->parse_full_type( "text/plain" );
	    }
	    
	    $file_part->transfer_encoding = "base64";
	    $file_part->name = $attachments_name[$i];
	    $file_part->contents = $attachments_size < 100000 ? 
	      fill_paragraphs(base64_encode($contents), 80, "\n", '')
		: base64_encode($contents);
	    $mime->add_end_part( $file_part );
	 }
	 
	 $msg = $mime->generate();
	 $barefrom = get_barefrom($user, $server);
	 $from = get_from($user, $server);
	 
	 $hdrs  = "Errors-To: $barefrom\n";
	 $hdrs .= "Reply-To: $from\n";
	 if ($cc != '') { $hdrs .= "Cc: $cc\n"; }
	 $hdrs .= $mime->header();
	 
	 $hdrs .= 'X-Mailer: IMP/PHP3 Imap webMail Program ' . IMP_VERSION;
	 $hdrs .= "\n";
	 
	 if (mailfrom($to, $from, $barefrom, $subject, $hdrs, $msg)) {
	    status($lang->status_send_success);
	    
	    if ($default->save_sent_mail) {
	       $fcc  = 'Date: ' . date("D, d M H:i:s Y ") . gm_offset() . "\n";
	       $fcc .= 'To: ' . $to . "\n";
	       $fcc .= "From: $from\n";
	       $fcc .= 'Subject: ' . $subject . "\n";
	       $fcc .= $hdrs;
	       $fcc .= "\n";
	       $fcc .= $msg;
	       
	       $preamble = $folders.$default->personal_folders;
	       
	       if (!imap_listmailbox($mbox, "{$server:$port}", "$preamble$default->sent_mail")) {
		  imap_createmailbox($mbox, "{$server:$port}$preamble$default->sent_mail");
		  if ($default->use_imap_subscribe) {
		     imap_subscribe($mbox, "{$server:$port}$preamble$default->sent_mail");
		  }
		  imp_reload_frame('impfolder', 'select.php3');
	       }
	       $fcc = ereg_replace("\n", "\r\n", $fcc);
	       if ( !(imap_append($mbox, "{$server:$port}$preamble"."$default->sent_mail", $fcc)) ) {
		  status($lang->status_send_save_error . $default->sent_mail);
	       }
	    }
	    
	    echo '<script language=javascript>window.location="mailbox.php3?mailbox=' . $mailbox . '";</script>';
	    exit;	
	 }
	 
	 unset($to);
	 unset($cc);
	 unset($subject);
	 unset($message);
	 unset($msg);
      }
      break;
      
    case ADD_ATTACHMENT:
      
      if (isset($attachments_name) && !is_array($attachments_name)) { $attachments_name = array($attachments_name); }
      if (isset($attachments_size) && !is_array($attachments_size)) { $attachments_size = array($attachments_size); }
      if (isset($attachments_file) && !is_array($attachments_file)) { $attachments_file = array($attachments_file); }
      if (isset($attachments_type) && !is_array($attachments_type)) { $attachments = array($attachments_type); }
      
      if ($file_upload_size > 0) {
	 $attachments_name[] = $file_upload_name;
	 $attachments_size[] = $file_upload_size;
	 $attachments_file[] = $file_upload . ".att";
	 
	 if (isset ($file_upload_type)) {
	    $attachments_type[] = $file_upload_type;
	 } else {
	    $attachments_type[] = "";
	 }
	 
	 $total_size = 0;
	 
	 for ($i = 0; $i < count ($attachments_size); $i++) {
	    $total_size += $attachments_size[$i];
	 }
	 
	 rename ($file_upload, $file_upload . ".att");
	 
	 $msg = $message;
      }
      
      $ACTION_TEXT = $lang->action_add_attach;
      $get_sig = false;
      break;
      
    case DELETE_ATTACHMENT:
      
      if (isset($attachments_name) && !is_array($attachments_name)) { $attachments = array($attachments_name); }
      if (isset($attachments_size) && !is_array($attachments_size)) { $attachments = array($attachments_size); }
      if (isset($attachments_file) && !is_array($attachments_file)) { $attachments = array($attachments_file); }
      if (isset($attachments_type) && !is_array($attachments_type)) { $attachments = array($attachments_type); }
      if (isset($delattachments) && !is_array($delattachments)) { $indices = array($delattachments); }
      
      if ($delattachments) {
	 for ($i = 0; $i < count ($delattachments); $i++) {
	    for ($j = 0; $j < count ($attachments_file); $j++) {
	       if (strcmp($delattachments[$i], $attachments_file[$j]) == 0) {
		  unlink ($attachments_file[$j]);
		  $attachments_name[$j] = "";
		  $attachments_size[$j] = "";
		  $attachments_file[$j] = "";
		  $attachments_type[$i] = "";
	       }
	    }
	 }
      }
      
      $new_name = array ();
      $new_file = array ();
      $new_size = array ();
      $new_type = array ();
      
      for ($i = 0; $i < count ($attachments_file); $i++) {
	 if (strcmp($attachments_file[$i], "")) {
	    $new_name[] = $attachments_name[$i];
	    $new_file[] = $attachments_file[$i];
	    $new_size[] = $attachments_size[$i];
	    $new_type[] = $attachments_type[$i];
	 }
      }
      
      $attachments_name = array ();
      $attachments_file = array ();
      $attachments_size = array ();
      $attachments_type = array ();
      
      $total_size = 0;
      
      for ($i = 0; $i < count ($new_name); $i++) {
	 $attachments_name[] = $new_name[$i];
	 $attachments_file[] = $new_file[$i]; 
	 $attachments_size[] = $new_size[$i]; 
	 $attachments_type[] = $new_type[$i]; 
	 $total_size += $attachments_size[$i];
      }
      
      $msg = $message;
      $ACTION_TEXT = $lang->action_del_attach;
      $get_sig = false;
      break;
      
      
    case POSTPONE_MESSAGE:
      $hdrs  = "Errors-To: $user@$server\n";
      if ($to != '') { $hdrs .= "To: $to\n"; }
      if ($cc != '') { $hdrs .= "Cc: $cc\n"; }
      if ($subject != '') { $hdrs .= "Subject: $subject\n"; }
      $hdrs .= 'X-Mailer: IMP/PHP3 Imap webMail Program ' . IMP_VERSION;
      $hdrs .= "\n\n";
      
      $msg = $hdrs . $message;
      $preamble = $folders.$default->personal_folders;
      $msg = ereg_replace("\n","\r\n",$msg);
      
      if (!imap_listmailbox($mbox, "{$server:$port}", "$preamble$default->postponed")) {
	 imap_createmailbox($mbox, "{$server:$port}$preamble$default->postponed");
	 if ($default->use_imap_subscribe) {
	    imap_subscribe($mbox, "{$server:$port}$preamble$default->postponed");
	 }
	 imp_reload_frame('impfolder', 'select.php3');
      }
      if ( !(imap_append($mbox, "{$server:$port}$preamble"."$default->postponed", $msg)) ) {
	 status($lang->status_postpone_error, 'red');
	 $get_sig = false;
      }  else {
	 status($lang->status_message_postponed);
	 unset($to);
	 unset($cc);
	 unset($subject);
	 unset($message);
	 unset($msg);
      }
      
      $ACTION_TEXT = '';
      break;
      
    case BOUNCE_COMPOSE:
      $ACTION_TEXT = $lang->action_bounce;
      break;
      
    default:
      $ACTION_TEXT = $lang->action_compose;
      break;
      
   }
} else { $ACTION_TEXT = $lang->action_compose; }
if (!isset($status_sent)) { status($lang->status_composition); }

$title = $lang->status_composition;
$sidebar = false;
require("$default->include_dir/generic-header.inc");

$barefrom = get_barefrom($user, $server);
$from = get_from($user, $server);
if (!isset($msg)) { $msg = ''; }
if (!isset($to)) { $to = ''; }
if (!isset($cc)) { $cc = ''; }
if (!isset($subject)) { $subject = ''; }
if ($get_sig && $sig = imp_get_signature($user, $server)) $msg .= "\n\n\n" . $sig;

$addresses = imp_get_addresses($user, $server);

if (isset($actionID) && ($actionID == BOUNCE_COMPOSE)) {
   include("$default->include_dir/compose.php3-bounce.inc");
} else {
   include("$default->include_dir/compose.php3-compose.inc");
}
require("$default->include_dir/generic-footer.inc");
require("$default->include_dir/compose.php3-javascript.inc");

?>
