<?php

/*
 
 File: message.php3
 $Author: chuck $
 $Revision: 1.59 $
 $Date: 1999/01/05 19:05:33 $
 
 IMP: Copyright 1998 Charles J. Hagenbuch <chuck@horde.org>
 
 You should have received a copy of the GNU Public
 License along with this package; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 
 */


function add_attachment( $mime ) {
   global $atc, $mailbox, $j, $index, $default, $lang;
   if ($mime->name == "") { $mime->name = $lang->attachment . ' ' . $j; }
   if ($mime->size != 0) {
      if( !isset($atc) ) $atc = "";
      $atc .= $mime->display();
   }
}

function wrap ($text, $wrap = 80, $break = "\n") {
   $paras = explode("\n", $text);
   
   $result = array();
   $i = 0;
   while ($i < count($paras)) {
      if (strlen($paras[$i]) <= $wrap) {
	 $result[] = $paras[$i];
	 $i++;
      } else {
	 $result[] = substr($paras[$i], 0, $wrap);
	 $new = trim(substr($paras[$i], $wrap, strlen($paras[$i]) - $wrap));
	 if ($new != '') $paras[$i] = $new;
	 else $i++;
      }
   }
   return implode($break, $result);
}


require('./lib/imp.lib');           /* IMPlib is the IMP function library */
require('./lib/mimetypes.lib');     /* Mime handling routes */
require('./config/defaults.php3');  /* Defaults configuration file */
$language = select_lang();
require ("./locale/$language/message.lang");
require ("./locale/local/message.lang");

if ($default->ssl->enabled) include( "./lib/ssl.lib" );

error_reporting($default->error_level);  /* set error level from imp.lib   */

caching_headers();

$user    = getuser();
$pass    = getpass();
$server  = getsrvr();
$port    = getport();
$folders = getfldr();
$sorted  = getmsgl();
if (!$mailbox) { $mailbox = 'INBOX'; }
$current_mbox = eregi_replace("{$server}$folders*", '', $mailbox);

if (strlen($default->personal_folders)>0)
$current_mbox = eregi_replace("$default->personal_folders", '',$current_mbox);

$mbox = validate_login($server, $port, $mailbox, $user, $pass);

/* doctype */
require("$default->include_dir/doctype.inc");

/* Run through action handlers */

if (isset($actionID)) {
   switch ($actionID) {
    case NO_ACTION:
      break;
      
    case DELETE_MESSAGES:
      if ($index && $mailbox) {
	 if (!(imap_delete($mbox, imap_msgno($mbox, $index)))) {
	    $errormsg = $lang->delete_error;
	 }
	 $array_index++;
	 $index = $sorted[$array_index];
      }
      break;
   }
}

/* parse MIME header info */

$structure = imap_fetchstructure($mbox, imap_msgno($mbox, $index));
$num_parts = count($structure->parts);


if (!isset($bodypart) || ($bodypart < 1)) { $bodypart = 1; }
$j = 1;
$msg = "&nbsp;";
if ($num_parts > 1) {
   
   while ($j <= $num_parts) {
      if (isset($structure->parts[$j])) {
	 $part = $structure->parts[$j];
	 
	 $mime = new mime_part_data;
	 $mime->set_imap_data( $mailbox, $index, $j );
	 $mime->parse( $part );
	 add_attachment( &$mime );
      }
      $j++;
   }
   
   /* get and format the main body part */
   $msg = htmlspecialchars(imap_fetchbody($mbox, $index, $bodypart, FT_UID));
   if ($qprint_msg = imap_qprint($msg)) { $msg = $qprint_msg; }
   $msg = wrap_message($msg, 85);
   $msg = wrap($msg, 85);
   $msg = eregi_replace("(http|https|ftp)://([[:alnum:]/\n+-=%:_.~?]+[#[:alnum:]+]*)", "<a href=\"\\1://\\2\" target=\"_blank\">\\1://\\2</a>", $msg);
   $charset = $mime->charset;
   
} else {
   $mime = new mime_part_data;
   $mime->set_imap_data( $mailbox, $index, $j );
   $mime->parse( $structure );
   if ($mime->type == 1 ) {
      /* Safe to display, it is text */
      /* get and format the main body part */
      $msg = htmlspecialchars(imap_fetchbody($mbox, $index, $bodypart, FT_UID));
      if ($qprint_msg = imap_qprint($msg)) { $msg = $qprint_msg; }
      $msg = wrap_message($msg, 85);
      $msg = wrap($msg, 85);
      $msg = eregi_replace("(http|https|ftp)://([[:alnum:]/\n+-=%:_.~?]+[#[:alnum:]+]*)", "<a href=\"\\1://\\2\" target=\"_blank\">\\1://\\2</a>", $msg);
      $charset = $mime->charset;
   } else {
      add_attachment(&$mime);
   }
}

if ($default->view_message_source) {
   if (!isset($atc)) $atc = "";
   $mime = new mime_part_data;
   $mime->set_type_full( "mail/source" );
   $atc .= "<a href=\"$default->root_url/view.php3?mailbox=" . urlencode($mailbox) . "&index=$index&bodypart=$j&actionID=" . VIEW_SOURCE . '">' . $mime->img_tag() . ' ' . $lang->source . '</a><br>';
}


$h = imap_header($mbox, imap_msgno($mbox, $index));

if (isset($h->date))            { $dat = htmlspecialchars(chop($h->date )); }
if (isset($h->toaddress))       { $to  = htmlspecialchars(decode_mime_string(chop($h->toaddress ))); }
if (isset($h->fromaddress))     { $frm = htmlspecialchars(decode_mime_string(chop($h->fromaddress ))); }
if (isset($h->ccaddress))       { $cc  = htmlspecialchars(decode_mime_string(chop($h->ccaddress ))); }
if (isset($h->reply_toaddress)) { $rep = htmlspecialchars(decode_mime_string(chop($h->reply_toaddress ))); }
if (isset($h->subject))         { $sub = htmlspecialchars(decode_mime_string(chop($h->subject ))); }

$msg_index = $array_index + 1;
status ($lang->message_status($current_mbox, $msg_index, imap_num_msg($mbox)));

if (isset($sub)) $title = "$mailbox: $sub";
else $title = $mailbox . ': ' . $lang->no_subject;

$sidebar = false;
require("$default->include_dir/generic-header.inc");

$prev_index = $array_index - 1;
$next_index = $array_index + 1;

if (isset($sorted[$prev_index])) $prev = $sorted[$prev_index];
else $prev = -1;

if (isset($sorted[$next_index])) $next = $sorted[$next_index];
else $next = -1;

if ($msg_index != count($sorted)) {
   $del_target = 'message.php3';
   $del_ident  = 'index';
} else {
   $del_target = 'mailbox.php3';
   $del_ident  = 'indices';
}

require("$default->include_dir/message.php3-navbar.inc");
require("$default->include_dir/message.php3-headers.inc");
require("$default->include_dir/message.php3-message.inc");
require("$default->include_dir/message.php3-navbar.inc");
require("$default->include_dir/generic-footer.inc");

?>
