<?php

/*
 
 File: login.php3
 $Author: chuck $
 $Revision: 1.37 $
 $Date: 1999/01/02 18:29:47 $
 
 IMP: Copyright 1998 Charles J. Hagenbuch <chuck@horde.org>
 
 You should have received a copy of the GNU Public
 License along with this package; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 
*/

require( './lib/imp.lib' );           /* IMPlib is the IMP function library  */
require( './config/defaults.php3' );  /* Defaults configuration file */
require( './lib/setcookie.lib' );

$language = select_lang();
require( "./locale/$language/login.lang" );
require( "./locale/local/login.lang" );
require( "./help/defines/login.help" );

if( $default->ssl->enabled ) { include( "./lib/ssl.lib" ); }

error_reporting($default->error_level);  /* set error level from imp.lib   */

/* invalidate any previous cookies */
setcookie('chuckmIMPuser');
setcookie('chuckmIMPpass');
setcookie('chuckmIMPsrvr');
setcookie('chuckmIMPport');
setcookie('chuckmIMPfldr');
setcookie('chuckmIMPmsgl');
setlang($language);

if (!isset($reason)) { $reason = 'login'; }

$messages[ 'login' ]     = '';
$messages[ 'timeout' ]   = 'Either you have logged in incorrectly, or your login has expired. Please login again.';
$messages[ 'logout' ]    = 'You have been logged out of IMP. Thank you for using the system. If you wish to log in again, please use the form below.';
$messages[ 'nocert' ]    = 'You need a valid certificate in order to access this site.';
$messages[ 'noaccount' ] = 'You do not yet have an email account with us.';

/* doctype */
require("$default->include_dir/doctype.inc");

if( $default->ssl->enabled && $ssl->process() ) { 
   $ssl->login();
} else {
   status( 'Welcome to Imp. Please log in...' );
   include( "$default->include_dir/login.php3-login.inc" );
}

?>
