<?php

/*
   
   File : lib/imp.lib.php3
   $Author: chuck $
   $Revision: 1.3 $
   $Date: 1998/12/17 20:41:11 $
   
   IMP : Copyright 1998 Patrick C. Audley paudley@blackcat.ca
   
   This code is under the GNU Public License
   See the file COPYING in this directory


  This can be used to figure out what imap_fetchstructure is actually returning.

 ex:
  $structure = imap_fetchstructure($mbox, imap_msgno($mbox, $index));
  include( "./lib/debug/mime_debug.php3" );  
  decompose( $structure );

*/



  function _decompose_line($var,$name,$extra="") { 
    echo "<tr><th>$name</th><td>".gettype($var)."</td><td>$var</td><td>$extra</td></tr>\n";
  }

  function decompose($part) {
    global $mime_types, $mime_encoding;
    echo "<table bgcolor=white border=1>\n";
    _decompose_line( isset( $part->type )          ? $part->type          : "NotSet" , "type", isset($part->type)?$mime_types[$part->type]:"" );
    _decompose_line( isset( $part->encoding )      ? $part->encoding      : "NotSet" , "encoding", isset($part->encoding)?$mime_encoding[$part->encoding]:"" );
    _decompose_line( isset( $part->ifsubtype )     ? $part->ifsubtype     : "NotSet" , "ifsubtype" );
    _decompose_line( isset( $part->subtype )       ? $part->subtype       : "NotSet" , "subtype" );
    _decompose_line( isset( $part->ifdescription ) ? $part->ifdescription : "NotSet" , "ifdescription" );
    _decompose_line( isset( $part->description )   ? $part->description   : "NotSet" , "description" );
    _decompose_line( isset( $part->ifid )          ? $part->ifid          : "NotSet" , "ifid" );
    _decompose_line( isset( $part->id )            ? $part->id            : "NotSet" , "id" );
    _decompose_line( isset( $part->lines )         ? $part->lines         : "NotSet" , "lines" );
    _decompose_line( isset( $part->bytes )         ? $part->bytes         : "NotSet" , "bytes" );
    _decompose_line( isset( $part->ifparameters )  ? $part->ifparameters  : "NotSet" , "ifparameters" );
    _decompose_line( @count( $part->parameters ), "@count(parameters)" );
    for( $i=0; $i<@count( $part->parameters ); $i++ ) {
      $parm = $part->parameters[$i];
      _decompose_line( isset( $parm->attribute )   ? $parm->attribute     : "NotSet" , "parameters[$i]->attribute" );
      _decompose_line( isset( $parm->value )       ? $parm->value         : "NotSet" , "parameters[$i]->value" );
    }
    _decompose_line( isset( $part->ifparameters )  ? $part->ifdparameters : "NotSet" , "ifdparameters" );
    _decompose_line( @count( $part->dparameters ), "@count(dparameters)" );
    for( $i=0; $i<@count( $part->dparameters ); $i++ ) {
      $parm = $part->dparameters[$i];
      _decompose_line( isset( $parm->attribute )   ? $parm->attribute     : "NotSet" , "dparameters[$i]->attribute" );
      _decompose_line( isset( $parm->value )       ? $parm->value         : "NotSet" , "dparameters[$i]->value" );
    }
    _decompose_line( @count( $part->parts ), "@count(parts)" );
    for( $i=0; $i<@count( $part->parts ); $i++ ) {
      echo "<tr><th>parts[$i]</th><td>Object</td><td>";
      if( isset( $part->parts[$i] ) ) {
	$parm = $part->parts[$i];
	decompose( $parm );
      } else 
	echo "NotSet";
      echo "</td></tr>\n";
    }
    echo "</table>\n";
  }

?>
