<?php

/*
  
  File: config/mime.conf
  $Author: chuck $
  $Revision: 1.1 $
  $Date: 1998/12/15 13:05:02 $
  
  IMP: Copywrite 1998 Patrick C. Audley paudley@blackcat.ca
  
  This code is under the GNU Public License
  See the file COPYING in this directory
  
*/


/*  Custom mime_types config:
 *
 *  Below is an example of a custom mime type.  This could be used to process
 * the contents and display them....  For example, the second function below
 * display all gifs/jpgs that are 10k or smaller.
 *
 *  The third function will display word attachments as HTML if you have mswordview.
 *
 */
  
  $mime_actions["application/x-imp-data"] = array("action" => "function",
  						  "function" => "mime_action_ximpdata",
						  "view" => false,
						  "download" => false,
						  "icon" => "mime_broken.gif" );

  $mime_actions["image/"] = array("action" => "function",
				  "function" => "mime_action_images",
				  "view" => true,
				  "download" => true,
				  "icon" => "mime_image.gif" );

  $mime_actions["application/msword"] = array("action" => "default",
					      "view" => true,
					      "view_function" => "mime_view_msword",
					      "download" => true,
					      "icon" => "mime_msword.gif" );

  function mime_action_ximpdata( $mime ) {
    global $default;
    $ret = "\n<table vspace=0 hspace=0 cellpadding=0 cellspacing=0 border=0><tr><td>$mime->icon Data &nbsp $nbsp</td>";    
    return $ret."</tr></table>\n";
  }

  function mime_action_images( $mime ) {
    $ret = "<table vspace=0 hspace=0 cellpadding=0 cellspacing=0 border=0><tr><td>";
    $mime->action["action"] = "default";
    $ret .= $mime->display();
    if( $mime->size < 10000 && ( $mime->subtype == "gif" || $mime->subtype == "jpeg" ) ) {
      $ret .= "</td><td> &nbsp &nbsp"; 
      $ret .= "<img src=view.php3?mailbox=" . urlencode($mime->mailbox) . "&index=$mime->index&bodypart=$mime->partno&actionID=" . VIEW_ATTACH . ">";
    }
    $ret .= "</td></tr></table>";
    return $ret;
  }

  function mime_view_msword( $mime ) {
    global $mbox, $default;
    $mime->fetch_contents();

    $word_name = "/tmp/imp.word.".date("Y-M-D_H:i:s")."__".md5($mime->contents);
    $fh = fopen( $word_name, "w" );
    fwrite( $fh, imap_base64( $mime->contents ) );
    fclose( $fh );

    $pipe = popen("$default->path_to_mswordview $word_name 2>&1","r");
    $data = "<b><u>MS Word View (word v8 only)</u></b><br><table><tr><td align=left>";
    while( ($rc=fgets($pipe,8192)) )
      $data.=$rc;
    pclose( $pipe );
    $data .="</td></tr></table>";
    
    unlink($word_name);
    return $data;
  }
  
?>
