<?php

/*
 
 File: addressbook.php3
 $Author: chuck $
 $Revision: 1.32 $
 $Date: 1999/01/02 18:29:47 $
 
 IMP: Copyright 1998 Charles J. Hagenbuch <chuck@horde.org>
 
 You should have received a copy of the GNU Public
 License along with this package; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 
 */

require ('./lib/imp.lib');              /* IMPlib is the IMP function library  */
require ('./config/defaults.php3');     /* Defaults Configuration File */
$language = select_lang();
require ("./locale/$language/addressbook.lang");
require ("./locale/local/addressbook.lang");

/* Initialize database library --- V1/V2 */
$db = init_db();

if ($default->ssl->enabled) { include( './lib/ssl.lib' ); }
error_reporting($default->error_level);  /* set error level from imp.lib   */

/* send headers to ensure that the page will reload correctly. */
caching_headers();

/* retrieve authentication information from cookies */
$user    = getuser();
$pass    = getpass();
$server  = getsrvr();
$port    = getport();
$folders = getfldr();
$mailbox = '';

/* proceed only with a valid login */
$mbox = validate_login($server, $port, $mailbox, $user, $pass);

/* doctype */
require("$default->include_dir/doctype.inc");


/* Run through the action handlers */
if (isset($actionID)) {
   switch($actionID) {
    case NO_ACTION:
      break;
      
    case DELETE_ADDR:
      if ($dead_address) {
	 if (!(imp_delete_address($dead_address, $user, $server))) {
	    $errormsg = $lang->error_delete_address;
	 }
      }
      break;
      
    case ADD_ADDR:
      if ($new_address && $new_nickname && $new_fullname) {
	 $clean_nickname = addslashes($new_nickname);
	 $clean_fullname = addslashes($new_fullname);
	 $clean_address = addslashes($new_address);
	 
	 $errormsg = '';
	 if ($clean_address != $new_address)   $errormsg .= $lang->error_address_chars;
	 if ($clean_nickname != $new_nickname) $errormsg .= $lang->error_nickname_chars;
	 if ($clean_fullname != $new_fullname) $errormsg .= $lang->error_fullname_chars;
	 if (!(imp_add_address($clean_address, $clean_nickname, $clean_fullname, $user, $server))) {
	    $errormsg .= $lang->error_create_address;
	 }
      }
      break;
      
    case UPDATE_ADDR:
      if ($old_address && $new_address && $new_nickname && $new_fullname) {
	 if (!(imp_update_address($old_address, $new_address, $new_nickname, $new_fullname, $user, $server))) {
	    $errormsg = $lang->error_update_address;
	 }
      }
      break;
   }
}


$title = $lang->addressbook_title;
$sidebar = false;
require("$default->include_dir/generic-header.inc");

$addresses = imp_get_addresses($user, $server);

$options = '';
if (isset($addresses) && is_array($addresses)) {
   for ($i = 0; $i < count($addresses); $i++) {
      if (is_array($addresses[$i]) && sizeof($addresses[$i] > 1)) {
	 $options .= '    <option value="' . $addresses[$i][0] . '">' . $addresses[$i][1] . ' &lt;' . $addresses[$i][0] . "&gt;\n";
      }
   }
}

require("$default->include_dir/addressbook.php3-create.inc");
require("$default->include_dir/addressbook.php3-update.inc");
require("$default->include_dir/addressbook.php3-delete.inc");
require("$default->include_dir/generic-footer.inc");
require("$default->include_dir/addressbook.php3-javascript.inc");
?>
