<?php

/*
 * 
 File: status.php3
 $Author: chuck $
 $Revision: 1.23 $
 $Date: 1998/12/22 21:34:01 $
 * 
 IMP: Copyright 1998 Charles J. Hagenbuch <chuck@horde.org>
 * 
 You should have received a copy of the GNU Public
 License along with this package; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 * 
 */

$title = "Status Bar";
$sidebar = true;

require( './lib/imp.lib' );
require( './config/defaults.php3' );

/* send headers to ensure that the page will reload correctly. */
caching_headers();

/* can we log in? */
$user    = getuser();
$pass    = getpass();
$server  = getsrvr();
$port    = getport();
$folders = getfldr();
if (!isset($mailbox)) { $mailbox = 'INBOX'; }

/* if we can log in, do so and get the mail stats for this mailbox */
if(isset($default->refresh_delay) && isset($user) && $user != '') {
  /* make it refresh */
  $refresh = true;

  $mbox = validate_login($server, $port, $mailbox, $user, $pass);
  $mailinfo = imap_mailboxmsginfo($mbox);
  if($mailinfo) {
    $num_unread = $mailinfo->Unread;
    $num_recent = $mailinfo->Recent;
    $message = "$message&nbsp;&nbsp;|&nbsp&nbsp;$num_unread new, $num_recent recent";

    /* If they want it, we can give them a "new mail" popup */
    if(isset($default->newmail_popup) && $default->newmail_popup) {
      if($num_recent > 0) {
        echo "<script>onLoad=\"mail_popup()\";";
	echo "alert(\"You\'ve got mail\!\");</script>";
      }
    }
  }
}


require( "$default->include_dir/generic-header.inc" );
require( "$default->include_dir/status.php3-body.inc" );
require( "$default->include_dir/generic-footer.inc" );

?>
