#!/usr/bin/perl
# build_hordelib.pl
#
local( $horde_lib_name ) = "../horde.lib";
local( @FILE_ORDER );
local( %FILE_COMMENTS );
local( $inc, $def, $func, $obj );

$inc  = 'includes/';
$def  = 'defines/';
$func = 'functions/';
$obj  = 'objects/';

@FILE_ORDER = (
         ## - Includes - ##
         'HordeCopyright.inc',
         ## - Defines - ##
         'HordeLibVersion.def',
         'GlobalDefines.def',
         'HordeDb.def',
         'ImapServers.def',
         ## - Objects - ##
         'CyrusDefaults.object',
         'HordeAdminPrivlage.object',
         'HordeConfigForm.object',
         'HordeDataGrant.object',
         'HordeGrant.object',
         'HordeImapServer.object',
         'HordeUser.object',
         'HordeGroup.object',
			'HordeLocaleLang.object',
         'HtmlDocument.object',
         'ImpDefaults.object',
         'ImpUserDefaults.object',
         'ImpUserSignature.object',
         'ImpUser.object',
         'SSLDefaults.object',
         'LogDefaults.object',
         ## - Functions - ##
         'init_db.func',
);

## - Includes - ##
## - Defines - ##
$FILE_COMMENTS{ 'HordeLibVersion.def' }         =             'HordeLibrary Version';
$FILE_COMMENTS{ 'GlobalDefines.def' }           =             'Global Defines';
$FILE_COMMENTS{ 'HordeDb.def' }                 =             'Horde Database Defines';
$FILE_COMMENTS{ 'ImapServers.def' }             =             'IMAP Server Defines';
## - Objects - ##
$FILE_COMMENTS{ 'CyrusDefaults.object' }           =             'CyrusDefaults Object';
$FILE_COMMENTS{ 'HordeAdminPrivlage.object' }      =             'HordeAdminPrivlage Object';
$FILE_COMMENTS{ 'HordeConfigForm.object' }         =             'HordeConfigForm Object';
$FILE_COMMENTS{ 'HordeGrant.object' }              =             'HordeGrant Object';
$FILE_COMMENTS{ 'HordeDataGrant.object' }          =             'HordeDataGrant Object';
$FILE_COMMENTS{ 'HordeImapServer.object' }         =             'HordeImapServer Object';
$FILE_COMMENTS{ 'HordeUser.object' }               =             'HordeUser Object';
$FILE_COMMENTS{ 'HordeGroup.object' }              =             'HordeGroup Object';
$FILE_COMMENTS{ 'HordeLocaleLang.object' }			=	           'HordeLocaleLang Object';			
$FILE_COMMENTS{ 'HtmlDocument.object' }            =             'HtmlDocument Object';
$FILE_COMMENTS{ 'ImpDefaults.object' }             =             'ImpDefaults Object';
$FILE_COMMENTS{ 'ImpUserDefaults.object' }         =             'ImpUserDefaults Object';
$FILE_COMMENTS{ 'ImpUserSignature.object' }        =             'ImpUserSignature Object';
$FILE_COMMENTS{ 'ImpUser.object' }                 =             'ImpUser Object';
$FILE_COMMENTS{ 'SSLDefaults.object' }             =             'SSLDefaults Object';
$FILE_COMMENTS{ 'LogDefaults.object' }             =             'LogDefaults Objects';
## - Functions - ##
$FILE_COMMENTS{ 'init_db.func' }                =             'V2 Database init function';

open( HORDE_LIB, "> $horde_lib_name" )
   || die "ERROR : Could not open horde lib for writing.\nEXITING\nERROR : $!\n";
print HORDE_LIB "<?php\n\n";
foreach $file_key ( @FILE_ORDER ) {
   ( @temp_data ) = split( /\./, $file_key );
   $file_ext = $temp_data[ ( @temp_data - 1) ];
   $base_dir = '';
   if ( $file_ext eq "inc"    ) {   $base_dir = $inc;  }
   if ( $file_ext eq "def"    ) {   $base_dir = $def;  }
   if ( $file_ext eq "func"   ) {   $base_dir = $func; }
   if ( $file_ext eq "object" ) {   $base_dir = $obj;  }
   add_file( HORDE_LIB, $base_dir . $file_key, $FILE_COMMENTS{ $file_key } );
}
print HORDE_LIB "?>\n";
close( HORDE_LIB );

sub add_file {
   local( *OUT_FH, $filename, $comment ) = @_;

   if ( $comment ne "" ) {
   print OUT_FH <<"FILE_COMMENT";
/*
$comment      : $filename
*/
FILE_COMMENT
   }

   open( IN_FH, $filename ) || print STDERR "WARNING : Unable to open : $filename\nERROR : $!\n";
   while( <IN_FH> ) { print OUT_FH $_; }
   close( IN_FH );   

   print OUT_FH <<"EOF";
/*      EOF - $filename       */



EOF

}
