<?php

/*
 
 File : lib/pgsql.lib.php3
 $Author: chuck $
 $Revision: 1.14 $
 $Date: 1998/12/30 19:33:54 $
 
 IMP : Copywrite 1998 Charles J. Hagenbuch <chuck@horde.org>
 
 You should have received a copy of the GNU Public
 License along with this package; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 
*/


/* Table Structure for PostgreSQL version:
   
   Preferences Table (possibly more to be added later):

    create table imp_pref (
      username   text,        -- joe@imap.doe.com format username
      sig        text,        -- signature
      replyto    text,        -- joe@doe.com for replyto/from lines
      fullname   text,        -- Joe Doe
      lang       varchar(30)  -- users's preferred language (en, es, ...)
    );

   Address Table:

   create table imp_addr (
     username   text,     -- joe@doe.com identifier of who this entry belongs to
     address    text,     -- address@mail.server.com - the actual address
     nickname   text,     -- any entered nickname - ie "bonnie".
     fullname   text      -- full name - "My Bonnie".
   );

   Log table:

   create table imp_logs (
     username text,       -- joe@imap.doe.com format username
     ts       datetime,   -- date/time of event
     event    int,
     target   text,
     log      text,
     md5      text
   );

*/


/* Required Functions - funtions that are called by other files and therefore
 * must be present in all db.lib implementations
 */

function imp_check_prefs ($user, $server) {
   global $default;   
   $sql="select username from $default->db_pref_table where username='$user@$server'";
   if (!($db = pg_pconnect($default->db_server_name,$default->db_server_port,$default->db_server_options,$default->db_server_tty,$default->db_name))) {return false;}
   if (($result = pg_Exec($db,$sql)) && (pg_NumRows($result) > 0 )) { 
	return true;
   } else {
	return false;
   }
}

function imp_get_lang ($user, $server) {
   global $default;
   
   /* post: returns the signature for the database key $user@$server
    (a string), or false on failure.
    */
   
   if (!($db = pg_pconnect($default->db_server_name,$default->db_server_port,$default->db_server_options,$default->db_server_tty,$default->db_name))) { return false; }
   if (!($result = pg_exec($db, "select lang from $default->db_pref_table where username='$user@$server'")) || (pg_NumRows($result) <= 0 )) { return false; }
   
   return(pg_result($result, 0, "lang"));
}

function imp_get_from ($user, $server) {
   global $default;

   /* post: returns the signature for the database key $user@$server
    (a string), or false on failure.
    */
   
   if (!($db = pg_pconnect($default->db_server_name,$default->db_server_port,$default->db_server_options,$default->db_server_tty, $default->db_name))) { return false; }
   if (!($result = pg_exec($db, "select replyto from $default->db_pref_table where username='$user@$server'")) || (pg_NumRows($result) <= 0 )) { return false; }
   
   return(pg_result($result, 0, "replyto"));
}

function imp_get_fullname ($user, $server) {
   global $default;
   
   /* post: returns the signature for the database key $user@$server
    (a string), or false on failure.
    */
   
   if (!($db = pg_pconnect($default->db_server_name,$default->db_server_port,$default->db_server_options,$default->db_server_tty, $default->db_name))) { return false; }
   if (!($result = pg_exec($db, "select fullname from $default->db_pref_table where username='$user@$server'")) || (pg_NumRows($result) <= 0 )) { return false; }
   
   return(pg_result($result, 0, "fullname"));
}

function imp_get_signature ($user, $server) {
   global $default;
   
   /* post: returns the signature for the database key $user@$server
    (a string), or false on failure.
    */
   
   if (!($db = pg_pconnect($default->db_server_name,$default->db_server_port,$default->db_server_options,$default->db_server_tty, $default->db_name))) { return false; }
   if (!($result = pg_exec($db, "select sig from $default->db_pref_table where username='$user@$server'")) || (pg_NumRows($result) <= 0 )) { return false; }
   
   return(pg_result($result, 0, "sig"));
}


function imp_set_signature ($signature, $user, $server) {
   global $default;
   
   /* post: sets the signature to $signature for the database key $user@$server
    returns true on success and false on failure
    */
   
   if (imp_check_prefs($user,$server)) {
      $sql = "update $default->db_pref_table set sig='$signature' where username='$user@$server'";
   } else {
      $sql = "insert into $default->db_pref_table (username,sig) values ('$user@$server', '$signature')";
   }
   
   if (!($db = pg_pconnect($default->db_server_name,$default->db_server_port,$default->db_server_options,$default->db_server_tty, $default->db_name))) { return false; }
   if (!($result = pg_Exec($db,$sql))) { return false; }
   
   return true;
}

function imp_set_from ($from, $user, $server) {
   global $default;
   
   /* post: sets the replyto to $from for the database key $user@$server
    returns true on success and false on failure
    */
   if (imp_check_prefs($user,$server)) { 
      $sql = "update $default->db_pref_table set replyto='$from' where username='$user@$server'";
   } else {
      $sql = "insert into $default->db_pref_table (username,replyto) values ('$user@$server', '$from')";
   }
   
   if (!($db = pg_pconnect($default->db_server_name,$default->db_server_port,$default->db_server_options,$default->db_server_tty, $default->db_name))) { return false; }
   if (!($result = pg_Exec($db,$sql))) { return false; }
   
   return true;
}

function imp_set_lang ($lang, $user, $server) {
   global $default;
 
   /* post: sets the language to $lang for the database key $user@$server      
    returns true on success and false on failure
    */
 
   if (imp_check_prefs($user, $server)) {
      $sql = "update $default->db_pref_table set lang='$lang' where username='$user@$server'";
   } else {
      $sql = "insert into $default->db_pref_table (username, lang) values ('$user@$server', '$lang')";
   }
    
   if (!($db = pg_pconnect($default->db_server_name,$default->db_server_port,$default->db_server_options,$default->db_server_tty,$default->db_name))) { return false; }   
   if (!($result = pg_Exec($db,$sql))) { return false; } 
   return true;
}  

function imp_set_fullname ($fullname, $user, $server) {
   global $default;
   
   /* post: sets the fullname to $fullname for the database key $user@$server
    returns true on success and false on failure
    */
   if (imp_check_prefs($user,$server)) {
      $sql = "update $default->db_pref_table set fullname='$fullname' where username='$user@$server'";
   } else {
      $sql = "insert into $default->db_pref_table (username,fullname) values ('$user@$server', '$fullname')";
   }
   
   if (!($db = pg_pconnect($default->db_server_name,$default->db_server_port,$default->db_server_options,$default->db_server_tty, $default->db_name))) { return false; }
   if (!($result = pg_Exec($db,$sql))) { return false; }
   
   return true;
}

function imp_get_addresses ($user, $server) {
   global $default;
   
   /* post: returns a 2d array of addresses where each
    element is an array in which element 0 is the address,
    element 1 is the nickname, and element 2 is the fullname.
    it returns false on failure.
    */
   
   if (!($db = pg_pconnect($default->db_server_name,$default->db_server_port,$default->db_server_options,$default->db_server_tty, $default->db_name))) { return false; }
   if (!($result = pg_Exec($db, "select address, nickname, fullname from $default->db_address_table where username='$user@$server' order by nickname"))) { return false; }
   if (($rowcount = pg_NumRows($result))==0) { return false; }
   
   for ($i=0; $i<$rowcount; $i++) {
      $return[$i]=array(0=>pg_Result($result,$i,"address"),1=>pg_Result($result,$i,"nickname"),2=>pg_Result($result,$i,"fullname"));
   }
   
   return($return);
}

function imp_delete_address ($address, $user, $server) {
   global $default;
   
   /* post: deletes $address from the addressbook of $user@$server
    returns true on success and false on failure
    */
   
   if (!($db = pg_pconnect($default->db_server_name,$default->db_server_port,$default->db_server_options,$default->db_server_tty, $default->db_name))) { return false; }
   if (!($result = pg_Exec($db, "delete from $default->db_address_table where username='$user@$server' and address='$address'"))) { return false; }
   
   return true;
}

function imp_add_address ($address, $nickname, $fullname, $user, $server) {
   global $default;
   
   /* post: adds $address, $nickname, $fullname to the addressbook for $user@$server
    returns true on success and false on failure
    */
   
   if (!($db = pg_pconnect($default->db_server_name,$default->db_server_port,$default->db_server_options,$default->db_server_tty, $default->db_name))) { return false; }
   if (!($result = pg_exec($db, "insert into $default->db_address_table values ('$user@$server', '$address', '$nickname', '$fullname')"))) { return false; }
   
   return true;
}

function imp_update_address ($old_address, $address, $nickname, $fullname, $user, $server) {
   global $default;
   
   /* post: changes the entry for $old_address to $address, $nickname, $fullname.
    returns true on success and false on failure
    */
   
   if (!($db = pg_pconnect($default->db_server_name,$default->db_server_port,$default->db_server_options,$default->db_server_tty, $default->db_name))) { return false; }
   if (!($result = pg_Exec($db, "update $default->db_address_table set address='$address', nickname='$nickname', fullname='$fullname' where username='$user@$server' and address='$old_address'"))) { return false; }
   
   return true;
}

function log_event ($user, $target, $event, $log, $md5) {
   global $default;

   if (! $default->log->enabled) 
      { return true; }

   if (!($db = pg_pconnect($default->db_server_name,$default->db_server_port,$default->db_server_options,$default->db_server_tty, $default->db_name))) 
      { return false; }

   if (!(pg_Exec($db, "insert into $default->db_log_table values ('$user','now', $event,'$target','$log','$md5')")))
      { return false; }

   return true;
}

function imp_get_log( $user)
{    
   global $default;

   if (!($db = pg_pconnect($default->db_server_name,$default->db_server_port,$default->db_server_options,$default->db_server_tty, $default->db_name))) { return false; }

   if (!($result = pg_Exec($db, "select ts,target,event,log,md5 from $default->db_log_table where username = '$user' order by ts"))) { return false; }

   if (($rowcount = pg_NumRows($result))==0) { return false; }
   
   for ($i=0; $i<$rowcount; $i++) {
      $return[$i]=array(0=>pg_Result($result,$i,"ts"),1=>pg_Result($result,$i,"target"),2=>pg_Result($result,$i,"event"),3=>pg_Result($result,$i,"log"),4=>pg_Result($result,$i,"md5"));
   }
   
   return($return);
}


/* Support Functions - functions which are only used by routines in this file,
 * and which therefore can change from implementation to implementation.
 */

?>
