<?php

/*
 
 File: folders.php3
 $Author: chuck $
 $Revision: 1.40 $
 $Date: 1998/12/23 03:58:54 $
 
 IMP: Copyright 1998 Charles J. Hagenbuch <chuck@horde.org>
 
 You should have received a copy of the GNU Public
 License along with this package; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 
 */

require( './lib/imp.lib' );           /* IMPlib is the IMP function library  */
require( './config/defaults.php3' );  /* Defaults configuration file */
$language = select_lang();
require ("./locale/$language/folders.lang");

if ($default->ssl->enabled) { include( "./lib/ssl.lib" ); }

error_reporting($default->error_level);  /* set error level from imp.lib   */

caching_headers();

/* retrieve authentication information from cookies */
$user    = getuser();
$pass    = getpass();
$server  = getsrvr();
$port    = getport();
$folders = getfldr();
$mailbox = '';

/* proceed only with a valid login */
$mbox = validate_login($server, $port, $mailbox, $user, $pass);

$preamble = $folders.$default->personal_folders;
$errormsg = '';

/* Run through the action handlers */

if (isset($actionID)) {
   switch($actionID) {
    case NO_ACTION:
      break;
      
    case DELETE_FOLDER:
      if ($dead_mailbox) {
	 if ($default->use_imap_subscribe) { $boxes = mailbox_list('INBOX'); }
	 if (!(imap_deletemailbox($mbox, "{$server:$port}"."$dead_mailbox"))) {
	    $errormsg = $lang->delete_folder_error;
	 } else {
	    if ($default->use_imap_subscribe) {
	       if (strstr($boxes, "\"$dead_mailbox\"")) {
		  if(!(imap_unsubscribe($mbox, "{$server:$port}$dead_mailbox"))) {
		     $errormsg = $lang->unsub_folder_error;
		  }
	       }
	    }
	 }
      }
      break;
      
    case CREATE_FOLDER:
      if ($new_mailbox) {
	 if (!(imap_createmailbox($mbox, "{$server:$port}$preamble$new_mailbox"))) {
	    $errormsg = $lang->create_folder_error;
	 } else {
	    if ($default->use_imap_subscribe) {
	       if(!(imap_subscribe($mbox,"{$server:$port}$preamble$new_mailbox"))) {
		  $errormsg = $lang->subscribe_folder_error;
	       }
	    }
	 }
      }
      break;
      
    case RENAME_FOLDER:
      if ($old_mailbox && $new_mailbox) {
	 if (!(imap_renamemailbox($mbox, "{$server:$port}$old_mailbox", "{$server:$port}$preamble"."$new_mailbox"))) {
	    $errormsg = $lang->rename_folder_error;
	 }
      }
      break;
    case SUBSCRIBE_FOLDER:
      if ($new_mailbox) {
	 if(!(imap_subscribe($mbox,"{$server:$port}$new_mailbox"))) {
	    $errormsg = $lang->subscribe_folder_error;
	 }
      }
      break;
    case UNSUBSCRIBE_FOLDER:
      if($old_mailbox) {
	 if(!(imap_unsubscribe($mbox, "{$server:$port}$old_mailbox"))) {
            $errormsg = $lang->unsub_folder_error;
	 }
      }
      break;
   }
}

/* close and reopen the imap stream so the mailbox list is up to date */
imap_close($mbox);
$mbox = validate_login($server, $port, $mailbox, $user, $pass);

$title = $lang->folders_title;
require("$default->include_dir/generic-header_reload.inc");

$options = mailbox_list('INBOX');
if($default->use_imap_subscribe) {
   $newlist = full_mailbox_list('INBOX');
   include("$default->include_dir/folders.php3-subscribe.inc");
   include("$default->include_dir/folders.php3-unsubscribe.inc");
} else {
   $newlist=$options;
}
require("$default->include_dir/folders.php3-delete.inc");
require("$default->include_dir/folders.php3-rename.inc");
require("$default->include_dir/folders.php3-create.inc");
require("$default->include_dir/generic-footer.inc");

?>
