<?php

/*
 
 File: config/examples/mimetypes.php3
 $Author: chuck $
 $Revision: 1.2 $
 $Date: 1998/12/17 21:39:13 $
 
 IMP: Copywrite 1998 Charles J. Hagenbuch chuck@horde.org
 
 This code is under the GNU Public License
 See the file COPYING in this directory
 
 */

// this file contains user-contributed mimetypes for various kinds of data
// add them to mime.conf if you want them.



// From: Joao Pedro Goncalves <joaop@iscsp.utl.pt>
// .zip - Uses zipinfo.
// Define $default->path_to_unzip in defaults.conf.

$mime_actions["application/zip"] = array("action" => "default",
					 "view" => true,
					 "view_function" => "mime_view_zip",
					 "download" => true,
					 "icon" => "mime_compressed.gif" );

function mime_view_zip( $mime ) {
   global $mbox, $default;
   $mime->fetch_contents();
   $zip_name = "/tmp/imp.zip.".date("Y-M-D_H:i:s")."__".md5($mime->contents);
   $fh = fopen( $zip_name, "w" );
   fwrite( $fh, imap_base64( $mime->contents ) );
   fclose( $fh );
   $pipe = popen("$default->path_to_unzip -m $zip_name  2>&1 |grep -v Archive","r");
   $data = "<b><u>Contents of ZIP file</u></b><br><table><tr><td align=left><pre>";
   while( ($rc=fgets($pipe,10)) )
     $data.= $rc;
   pclose( $pipe );
   $data .="</pre></td></tr></table><br><b><u>Details of ZIP file</u></b><br><table><tr><td align=left><pre>";
   $pipe = popen("$default->path_to_unzip -mvh $zip_name  2>&1 |grep -v Archive","r");
   while( ($rc=fgets($pipe,10)) )
     $data.= $rc;
   pclose( $pipe );
   $data .="</pre></td></tr></table>";
   unlink("$zip_name");
   return $data;
}


// From: Joao Pedro Goncalves <joaop@iscsp.utl.pt>
// .tgz - Uses GNU tar that allows -z flag for compressed files.
// Define $default->path_to_tar in defaults.conf

$mime_actions["application/x-gtar"] = array("action" => "default",
					    "view" => true,
					    "view_function" => "mime_view_tgz",
					    "download" => true,
					    "icon" => "mime_compressed.gif" );


function mime_view_tgz( $mime ) {
   global $mbox, $default;
   $mime->fetch_contents();
   $tgz_name = "/tmp/imp.".date("s")."__".md5($mime->contents).".tgz";
   $fh = fopen( $tgz_name, "w" );
   fwrite( $fh, imap_base64( $mime->contents ) );
   fclose( $fh );
   $pipe = popen("$default->path_to_tar tvfz $tgz_name  2>&1","r");
   $data = "<b><u>Query Gzipped Tarball</u></b><br><table><tr><td align=left><pre>";
   while( ($rc=fgets($pipe,10)) )
     $re.= $rc;
   pclose( $pipe );
   $data .= fill_paragraphs(htmlentities($re));
   $data .="</pre></td></tr></table>";
   unlink("$tgz_name");
   return $data;
}


// From: Joao Pedro Goncalves <joaop@iscsp.utl.pt>
// .rpm - RedHat packages.
// Define $default->path_to_rpm in defaults.conf.

$mime_actions["/x-pn-realaudio-plugin"] = array("action" => "default",
						"view" => true,
						"view_function" => "mime_view_rpm",
						"download" => true,
						"icon" => "mime_rpm.gif" );

function mime_view_rpm( $mime ) {
   global $mbox, $default;
   $mime->fetch_contents();
   $rpm_name = "/tmp/imp.rpm.".date("Y-M-D_H:i:s")."__".md5($mime->contents);
   $fh = fopen( $rpm_name, "w" );
   fwrite( $fh, imap_base64( $mime->contents ) );
   fclose( $fh );
   $pipe = popen("$default->path_to_rpm -qip $rpm_name  2>&1","r");
   $data = "<b><u>Query RPM Package</u></b><br><table><tr><td align=left><pre>";
   while( ($rc=fgets($pipe,10)) )
     $re.= $rc;
   pclose( $pipe );
   $data .= fill_paragraphs(htmlentities($re));
   $data .="</pre></td></tr></table>";
   unlink("$rpm_name");
   return $data;
}
