<?php

/*
 
 File: spelling.php3
 $Author: chuck $
 $Revision: 1.11 $
 $Date: 1998/11/30 16:04:36 $
 
 IMP: Copyright 1998 Charles J. Hagenbuch  <chuck@osmos.ml.org>
 
 You should have received a copy of the GNU Public
 License along with this package; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 
 */

require( './lib/imp.lib' );             /* IMPlib is the IMP function library  */
require( './config/defaults.conf' );    /* Defaults configuration file */

error_reporting($default->error_level); /* set error level from imp.lib   */

/* send headers to ensure that the page will reload correctly. */
header( 'Cache-Control: no-cache, must-revalidate' );
header( 'Pragma: no-cache' );
header( 'Expires: 0' );

$title = " Message Spelling Suggestions ";
$no_table_frame = true;
$sidebar = false;
require("$default->include_dir/generic-header.inc");

$tocheck = escapeShellCmd($message);

exec( "echo $tocheck | $default->path_to_ispell -l", $warnings);
sort($warnings);

$prev = '';
while (list($key, $val) = each($warnings)) {
   if ($val != $prev) {
      $errors[] = $val;
   }
   $prev = $val;
}

$message = ' ' . nl2br(htmlentities($message));
if (isset($errors)) {
   while (list($key, $error) = each($errors)) {
      // thanks to Ray Kimsey <Ray_Kimsey@ncsu.edu> for these smarter regexes
      $message = ereg_replace(" $error([ ,.:;!?()/])", " <font color=ff0000>$error</font>\\1", $message);
      $message = ereg_replace("\n$error([ ,.:;!?()/])", "\n<font color=ff0000>$error</font>\\1", $message);
      $message = ereg_replace(" $error\r", " <font color=ff0000>$error\r</font>", $message);
   }
}

echo stripSlashes($message);

require("$default->include_dir/spelling.php3-footer.inc");

?>
