<?php

/*
 
 File : lib/pgsql.lib.php3
 $Author: chuck $
 $Revision: 1.7 $
 $Date: 1998/11/29 01:37:20 $
 
 IMP : Copywrite 1998 Charles J. Hagenbuch <chuck@osmos.ml.org>
 
 You should have received a copy of the GNU Public
 License along with this package; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 
*/


/* Settings - these may be different for different backends */

$imp_db        = 'imp';                /* the name of imp's db                */
$db_server     = '';           	       /* where the database server is        */
$db_port       = '';		       /* port field of pg_pconnect           */
$db_options    = '';		       /* options field of pg_pconnect        */
$db_tty        = '';		       /* tty field of pg_pconnect            */
$db_user       = 'nobody';             /* user to connect to the database as  */
$db_pass       = '';                   /* database password, if any -NOT USED IN PGSQL-*/
$pref_table    = 'preferences';        /* the name of the prefs table         */
$address_table = 'address';            /* the name of the address table       */


/* Table Structure for PostgreSQL version:
   
   Preferences Table:
    field:     type:      description:
    username   text       joe@imap.doe.com format username
    sig        text       signature
    replyto    text       joe@doe.com for replyto/from lines
    fullname   text       Joe Doe
    lang       varchar(30)  users's preferred language (en, es, ...)
    (possibly more to be added later)
 
   Address Table:
    field:     type:      description:
    username   text       joe@doe.com identifier of who this entry belongs to
    address    text       address@mail.server.com - the actual address
    nickname   text       any entered nickname - ie "bonnie".
    fullname   text       full name - "My Bonnie".
*/


/* Required Functions - funtions that are called by other files and therefore
 * must be present in all db.lib implementations
 */

function imp_check_prefs ($user, $server) {
   global $imp_db, $db_server, $db_user, $pref_table, $db_port, $db_options,
   $db_tty;
   
   $sql="select username from $pref_table where username='$user@$server'";
   if (!($db = pg_pconnect($db_server,$db_port,$db_options,$db_tty,$imp_db))) {
      if (($result = pg_Exec($db,$sql))) { 
	 return true;
      } else {
	 return false;
      }
   }
}

function imp_get_lang ($user, $server) {
   global $imp_db, $db_server, $db_user, $pref_table, $db_port, $db_options,
   $db_tty;
   
   /* post: returns the signature for the database key $user@$server
    (a string), or false on failure.
    */
   
   if (!($db = pg_pconnect($db_server,$db_port,$db_options,$db_tty,$imp_db))) { return false; }
   if (!($result = pg_exec($db, "select lang from $pref_table where username='$user@$server'"))) { return false; }
   
   return(pg_result($result, 0, "lang"));
}

function imp_get_from ($user, $server) {
   global $imp_db, $db_server, $db_user, $pref_table, $db_port, $db_options, $db_tty;
   
   /* post: returns the signature for the database key $user@$server
    (a string), or false on failure.
    */
   
   if (!($db = pg_pconnect($db_server,$db_port,$db_options,$db_tty, $imp_db))) { return false; }
   if (!($result = pg_exec($db, "select replyto from $pref_table where username='$user@$server'"))) { return false; }
   
   return(pg_result($result, 0, "replyto"));
}

function imp_get_fullname ($user, $server) {
   global $imp_db, $db_server, $db_user, $pref_table, $db_port, $db_options, $db_tty;
   
   /* post: returns the signature for the database key $user@$server
    (a string), or false on failure.
    */
   
   if (!($db = pg_pconnect($db_server,$db_port,$db_options,$db_tty, $imp_db))) { return false; }
   if (!($result = pg_exec($db, "select fullname from $pref_table where username='$user@$server'"))) { return false; }
   
   return(pg_result($result, 0, "fullname"));
}

function imp_get_signature ($user, $server) {
   global $imp_db, $db_server, $db_user, $pref_table, $db_port, $db_options, $db_tty;
   
   /* post: returns the signature for the database key $user@$server
    (a string), or false on failure.
    */
   
   if (!($db = pg_pconnect($db_server,$db_port,$db_options,$db_tty, $imp_db))) { return false; }
   if (!($result = pg_exec($db, "select sig from $pref_table where username='$user@$server'"))) { return false; }
   
   return(pg_result($result, 0, "sig"));
}


function imp_set_signature ($signature, $user, $server) {
   global $imp_db, $db_server, $db_user, $pref_table, $db_port, $db_options, $db_tty;
   
   /* post: sets the signature to $signature for the database key $user@$server
    returns true on success and false on failure
    */
   
   if (imp_check_prefs($user,$server)) {
      $sql = "update $pref_table set sig='$signature' where username='$user@$server'";
   } else {
      $sql = "insert into $pref_table values ('$user@$server', '$signature')";
   }
   
   if (!($db = pg_pconnect($db_server,$db_port,$db_options,$db_tty, $imp_db))) { return false; }
   if (!($result = pg_Exec($db,$sql))) { return false; }
   
   return true;
}

function imp_set_from ($from, $user, $server) {
   global $imp_db, $db_server, $db_user, $pref_table, $db_port, $db_options, $db_tty;
   
   /* post: sets the replyto to $from for the database key $user@$server
    returns true on success and false on failure
    */
   if (imp_check_prefs($user,$server)) { 
      $sql = "update $pref_table set replyto='$from' where username='$user@$server'";
   } else {
      $sql = "insert into $pref_table (username,replyto) values ('$user@$server', '$signature')";
   }
   
   if (!($db = pg_pconnect($db_server,$db_port,$db_options,$db_tty, $imp_db))) { return false; }
   if (!($result = pg_Exec($db,$sql))) { return false; }
   
   return true;
}

function imp_set_lang ($lang, $user, $server) {
   global $imp_db, $db_server, $db_user, $pref_table, $db_port, $db_options, $db_tty;
 
   /* post: sets the language to $lang for the database key $user@$server      
    returns true on success and false on failure
    */
 
   if (imp_check_prefs($user, $server)) {
      $sql = "update $pref_table set lang='$lang' where username='$user@$server'";
   } else {
      $sql = "insert into $pref_table (username, lang) values ('$user@$server', '$lang')";
   }
    
   if (!($db = pg_pconnect($db_server,$db_port,$db_options,$db_tty,$imp_db))) { return false; }   
   if (!($result = pg_Exec($db,$sql))) { return false; } 
   return true;
}  

function imp_set_fullname ($fullname, $user, $server) {
   global $imp_db, $db_server, $db_user, $pref_table, $db_port, $db_options, $db_tty;
   
   /* post: sets the fullname to $fullname for the database key $user@$server
    returns true on success and false on failure
    */
   if (imp_check_prefs($user,$server)) {
      $sql = "update $pref_table set fullname='$fullname' where username='$user@$server'";
   } else {
      $sql = "insert into $pref_table (username,fullname) values ('$user@$server', '$fullname')";
   }
   
   if (!($db = pg_pconnect($db_server,$db_port,$db_options,$db_tty, $imp_db))) { return false; }
   if (!($result = pg_Exec($db,$sql))) { return false; }
   
   return true;
}

function imp_get_addresses ($user, $server) {
   global $imp_db, $db_server, $db_user, $pref_table, $db_port, $db_options, $db_tty, $address_table;
   
   /* post: returns a 2d array of addresses where each
    element is an array in which element 0 is the address,
    element 1 is the nickname, and element 2 is the fullname.
    it returns false on failure.
    */
   
   if (!($db = pg_pconnect($db_server,$db_port,$db_options,$db_tty, $imp_db))) { return false; }
   if (!($result = pg_Exec($db, "select address, nickname, fullname from $address_table where username='$user@$server' order by nickname"))) { return false; }
   if (($rowcount = pg_NumRows($result))==0) { return false; }
   
   for ($i=0; $i<$rowcount; $i++) {
      $return[$i]=array(0=>pg_Result($result,$i,"address"),1=>pg_Result($result,$i,"nickname"),2=>pg_Result($result,$i,"fullname"));
   }
   
   return($return);
}

function imp_delete_address ($address, $user, $server) {
   global $imp_db, $db_server, $db_user, $pref_table, $db_port, $db_options, $address_table;
   
   /* post: deletes $address from the addressbook of $user@$server
    returns true on success and false on failure
    */
   
   if (!($db = pg_pconnect($db_server,$db_port,$db_options,$db_tty, $imp_db))) { return false; }
   if (!($result = pg_Exec($db, "delete from $address_table where username='$user@$server' and address='$address'"))) { return false; }
   
   return true;
}

function imp_add_address ($address, $nickname, $fullname, $user, $server) {
   global $imp_db, $db_server, $db_user, $pref_table, $db_port, $db_options, $db_tty, $address_table;
   
   /* post: adds $address, $nickname, $fullname to the addressbook for $user@$server
    returns true on success and false on failure
    */
   
   if (!($db = pg_pconnect($db_server,$db_port,$db_options,$db_tty, $imp_db))) { return false; }
   if (!($result = pg_exec($db, "insert into $address_table values ('$user@$server', '$address', '$nickname', '$fullname')"))) { return false; }
   
   return true;
}

function imp_update_address ($old_address, $address, $nickname, $fullname, $user, $server) {
   global $imp_db, $db_server, $db_user, $pref_table, $db_port, $db_options, $address_table;
   
   /* post: changes the entry for $old_address to $address, $nickname, $fullname.
    returns true on success and false on failure
    */
   
   if (!($db = pg_pconnect($db_server,$db_port,$db_options,$db_tty, $imp_db))) { return false; }
   if (!($result = pg_Exec($db, "update $address_table set address='$address', nickname='$nickname', fullname='$fullname' where username='$user@$server' and address='$old_address'"))) { return false; }
   
   return true;
}


/* Support Functions - functions which are only used by routines in this file,
 * and which therefore can change from implementation to implementation.
 */

?>
