#!/usr/bin/perl
# build_dblibs.pl
#


local( $horde_lib_name );
local( @FILE_ORDER );
local( %FILE_COMMENTS );
local( $inc, $def, $func, $obj );

##### - Mysql Lib Build - ####
$horde_lib_name = "../mysql.lib.php3";
set_file_bases( 'mysql' );

@FILE_ORDER = (
         ## - Includes - ##
         'HordeCopyright.inc',
         ## - Defines - ##
         'HordeLibVersion.def',
         ## - Objects - ##
         'User_ImapServer.obj',
         'User.obj',
         'HordeMysqlDb.obj',
         ## - Functions - ##
);

## - Includes - ##
## - Defines - ##
$FILE_COMMENTS{ 'HordeLibVersion.def' }         =             'Mysql HordeLibrary Version';
## - Objects - ##
$FILE_COMMENTS{ 'User_ImapServer.obj' }         =             'User_ImapServer Object';
$FILE_COMMENTS{ 'User.obj' }                    =             'User Object';
$FILE_COMMENTS{ 'HordeMysqlDb.obj' }            =             'HordeMysqlDb Object';
## - Functions - ##

## - Build Library - ##
build_lib();
#### - END Mysql Lib Build - ####







sub set_file_bases {
local( $dir_base ) = @_;
$inc  = $dir_base  . '/includes/';
$def  = $dir_base  . '/defines/';
$func = $dir_base  . '/functions/';
$obj  = $dir_base  . '/objects/';
}

sub build_lib {
local( $file_key );
local( @temp_data );
local( $file_ext, $base_dir );

open( HORDE_LIB, "> $horde_lib_name" )
   || die "ERROR : Could not open horde lib for writing.\nEXITING\nERROR : $!\n";
print HORDE_LIB "<?php\n\n";
foreach $file_key ( @FILE_ORDER ) {
   ( @temp_data ) = split( /\./, $file_key );
   $file_ext = $temp_data[ ( @temp_data - 1) ];
   $base_dir = '';
   if ( $file_ext eq "inc" ) {   $base_dir = $inc; }
   if ( $file_ext eq "def" ) {   $base_dir = $def; }
   if ( $file_ext eq "func" ) {  $base_dir = $func; }
   if ( $file_ext eq "obj" ) {   $base_dir = $obj; }
   add_file( HORDE_LIB, $base_dir . $file_key, $FILE_COMMENTS{ $file_key } );
}
print HORDE_LIB "?>\n";
close( HORDE_LIB );
}

sub add_file {
   local( *OUT_FH, $filename, $comment ) = @_;

   if ( $comment ne "" ) {
   print OUT_FH <<"FILE_COMMENT";
/*
$comment      : $filename
*/
FILE_COMMENT
   }

   open( IN_FH, $filename ) || print STDERR "WARNING : Unable to open : $filename\nERROR : $!\n";
   while( <IN_FH> ) { print OUT_FH $_; }
   close( IN_FH );   

   print OUT_FH <<"EOF";
/*      EOF - $filename       */



EOF

}
