<?php

/*
 
 File: folders.php3
 $Author: chuck $
 $Revision: 1.32 $
 $Date: 1998/12/02 03:28:04 $
 
 IMP: Copyright 1998 Charles J. Hagenbuch <chuck@osmos.ml.org>
 
 You should have received a copy of the GNU Public
 License along with this package; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 
 */

require( './lib/imp.lib' );           /* IMPlib is the IMP function library  */
require( './config/defaults.conf' );  /* Defaults configuration file */

if ($default->ssl->enabled) { include( "./lib/ssl.lib" ); }

error_reporting($default->error_level);  /* set error level from imp.lib   */

header( 'Cache-Control: no-cache, must-revalidate' );
header( 'Pragma: no-cache' );
header( 'Expires: 0' );

/* retrieve authentication information from cookies */
$user    = getuser();
$pass    = getpass();
$server  = getsrvr();
$port    = getport();
$folders = getfldr();
$mailbox = '';

/* proceed only with a valid login */
$mbox = validate_login($server, $port, $mailbox, $user, $pass);

$preamble = $folders.$default->personal_folders;
$errormsg = '';

/* Run through the action handlers */

if (isset($actionID)) {
   switch($actionID) {
    case NO_ACTION:
      break;
      
    case DELETE_FOLDER:
      if ($dead_mailbox) {
	 if ($default->use_imap_subscribe) { $boxes = mailbox_list('INBOX'); }
	 if (!(imap_deletemailbox($mbox, "{$server:$port}"."$dead_mailbox"))) {
	    $errormsg = '<tr><th colspan=5>An error occured; the folder was not deleted.</th></tr>';
	 } else {
	    if ($default->use_imap_subscribe) {
	       if (ereg("\"$dead_mailbox\"", $boxes)) {
		  if(!(imap_unsubscribe($mbox, "{$server:$port}$dead_mailbox"))) {
		     $errormsg = '<tr><th colspan=5>An error occured; the folder was not unsubscribed</th></tr>';
		  }
	       }
	    }
	 }
      }
      break;
      
    case CREATE_FOLDER:
      if ($new_mailbox) {
	 if (!(imap_createmailbox($mbox, "{$server:$port}$preamble$new_mailbox"))) {
	    $errormsg = '<tr><th colspan=5>An error occured; the new folder was not created</th></tr>';
	 } else {
	    if(!(imap_subscribe($mbox,"{$server:$port}$preamble$new_mailbox"))) {
	       $errormsg = '<tr><th colspan=5>An error occured; the folder was not subscribed</th></tr>';
	    }
	 }
      }
      break;
      
    case RENAME_FOLDER:
      if ($old_mailbox && $new_mailbox) {
	 if (!(imap_renamemailbox($mbox, "{$server:$port}$old_mailbox", "{$server:$port}$preamble"."$new_mailbox"))) {
	    $errormsg = '<tr><th colspan=5>An error occured; the folder was not renamed</th></tr>';
	 }
      }
      break;
    case SUBSCRIBE_FOLDER:
      if ($new_mailbox) {
	 if(!(imap_subscribe($mbox,"{$server:$port}$new_mailbox"))) {
	    $errormsg = '<tr><th colspan=5>An error occured; the folder was not subscribed</th></tr>';
	 }
      }
      break;
    case UNSUBSCRIBE_FOLDER:
      if($old_mailbox) {
	 if(!(imap_unsubscribe($mbox, "{$server:$port}$old_mailbox"))) {
            $errormsg = '<tr><th colspan=5>An error occured; the folder was not unsubscribed</th></tr>';
	 }
      }
      break;
   }
}

/* close and reopen the imap stream so the mailbox list is up to date */
imap_close($mbox);
$mbox = validate_login($server, $port, $mailbox, $user, $pass);

$title = "Mail Folders";
$no_table_frame = true;
require("$default->include_dir/generic-header_reload.inc");

$options = mailbox_list('INBOX');
if($default->use_imap_subscribe) {
   $newlist = full_mailbox_list('INBOX');
   include("$default->include_dir/folders.php3-subscribe.inc");
   include("$default->include_dir/folders.php3-unsubscribe.inc");
} else {
   $newlist=$options;
}
require("$default->include_dir/folders.php3-delete.inc");
require("$default->include_dir/folders.php3-rename.inc");
require("$default->include_dir/folders.php3-create.inc");
require("$default->include_dir/generic-footer.inc");
?>
