<?php

/*
  
  File: addressbook.php3
  $Author: chuck $
  $Revision: 1.20 $
  $Date: 1998/10/23 15:02:18 $
  
  IMP: Copyright 1998 Charles J. Hagenbuch <chuck@osmos.ml.org>
  
  You should have received a copy of the GNU Public
  License along with this package; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.
  
*/
  
  require ('./lib/imp.lib');              /* IMPlib is the IMP function library  */
  require ('./config/defaults.conf');     /* Defaults Configuration File */
  require ($default->db_lib);             /* DBlib is the db backend library     */
  if ($default->ssl->enabled) { include( './lib/ssl.lib' ); }
  error_reporting($default->error_level);  /* set error level from imp.lib   */
  
  /* send headers to ensure that the page will reload correctly. */
  header( 'Cache-Control: no-cache, must-revalidate' );
  header( 'Pragma: no-cache' );
  header( 'Expires: 0' );
  
  /* retrieve authentication information from cookies */
  $user    = getuser();
  $pass    = getpass();
  $server  = getsrvr();
  $port    = getport();
  $folders = getfldr();
  $mailbox = '';
  
  /* proceed only with a valid login */
  $mbox = validate_login($server, $port, $mailbox, $user, $pass);
  
  
  /* Run through the action handlers */
  if (isset($actionID)) {
    switch($actionID) {
      case NO_ACTION:
        break;
      
      case DELETE_ADDR:
        if ($dead_address) {
	  if (!(imp_delete_address($dead_address, $user, $server))) {
	    $errormsg = '<tr><th>An error occured; the entry was not deleted from your addressbook.</th></tr>';
	  }
	}
	break;
      
      case ADD_ADDR:
        if ($new_address && $new_nickname && $new_fullname) {
	  $clean_nickname = eregi_replace(' ', '', $new_nickname);
	  $clean_fullname = eregi_replace(',', '', $new_fullname);
	  $clean_fullname = eregi_replace('\'', '', $clean_fullname);
	  $clean_fullname = eregi_replace('"', '', $clean_fullname);
	  $clean_address = eregi_replace(',', '', $new_address);
	  $clean_address = eregi_replace('\'', '', $clean_address);
	  $clean_address = eregi_replace('"', '', $clean_address);
	  $clean_address = eregi_replace(' ', '', $clean_address);
	  
	  $errormsg = '';
	  if ($clean_address != $new_address) { $errormsg .= '<tr><th>You used an illegal character in the email address. It has been entered without it; edit it if you want to change the resulting entry.</th></tr>'; }
	  if ($clean_nickname != $new_nickname) { $errormsg .= '<tr><th>You used an illegal character in the nickname. It has been entered without it; edit it if you want to change the resulting entry.</th></tr>'; }
	  if ($clean_fullname != $new_fullname) { $errormsg .= '<tr><th>You used an illegal character in the full name. It has been entered without it; edit it if you want to change the resulting entry.</th></tr>'; }
	  if (!(imp_add_address($clean_address, $clean_nickname, $clean_fullname, $user, $server))) {
	    $errormsg .= '<tr><th>An error occured; the entry was not created.</th></tr>';
	  }
	}
	break;
      
      case UPDATE_ADDR:
        if ($old_address && $new_address && $new_nickname && $new_fullname) {
	  if (!(imp_update_address($old_address, $new_address, $new_nickname, $new_fullname, $user, $server))) {
	    $errormsg = '<tr><th>An error occured; the entry was not changed.</th></tr>';
	  }
	}
	break;
    }
  }
  
  
  $title = "Addressbook";
  $no_table_frame = false;
  $sidebar = false;
  require("$default->include_dir/generic-header.inc");
  
  $addresses = imp_get_addresses($user, $server);
  
  $options = '';
  if (isset($addresses) && is_array($addresses)) {
    for ($i = 0; $i < count($addresses); $i++) {
      if (is_array($addresses[$i]) && sizeof($addresses[$i] > 1)) {
        $options .= '    <option value="' . $addresses[$i][0] . '">' . $addresses[$i][1] . ' &lt;' . $addresses[$i][0] . "&gt;\n";
      }
    }
  }
  
  require("$default->include_dir/addressbook.php3-create.inc");
  require("$default->include_dir/addressbook.php3-update.inc");
  require("$default->include_dir/addressbook.php3-delete.inc");
  require("$default->include_dir/generic-footer.inc");
  require("$default->include_dir/addressbook.php3-javascript.inc");
?>
