<?php

/*
  
  File: view.php3
  $Author: chuck $
  $Revision: 1.26 $
  $Date: 1998/10/23 15:02:19 $
  
  IMP: Copyright 1998 Charles J. Hagenbuch <chuck@osmos.ml.org>
  
  You should have received a copy of the GNU Public
  License along with this package; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.
  
*/
  
  require( './lib/imp.lib' );           /* IMPlib is the IMP function library  */
  require( './lib/mimetypes.lib' );     /* Mime functions */
  require( './config/defaults.conf' );  /* Defaults configuration file */
  
  if( $default->ssl->enabled ) { include( "./lib/ssl.lib" ); }

  error_reporting($default->error_level);  /* set error level from imp.lib   */
  
  header( 'Cache-Control: no-cache, must-revalidate' );
  header( 'Pragma: no-cache' );
  header( 'Expires: 0' );
  
  $user    = getuser();
  $pass    = getpass();
  $server  = getsrvr();
  $port    = getport();
  $folders = getfldr();
  if (!$mailbox) { $mailbox = "INBOX"; }
  
  $mbox = validate_login($server, $port, $mailbox, $user, $pass);
  
  
  $structure = imap_fetchstructure ($mbox,$index);  
  if( !is_array($structure->parts) || $actionID == VIEW_SOURCE ) {
    $part = $structure;
    $bodyonly = true;
  } else {
    $part = $structure->parts[$bodypart];
    $bodyonly = false;
  }

#  include("./lib/debug/mime_debug.php3" );
#  decompose($part);
      
  /* Run through action handlers */
  if (isset($actionID)) {
    switch($actionID) {
      case NO_ACTION:
        break;
      
      case DOWNLOAD_ATTACH:
        $mime = new mime_part_data;
        $mime->parse( $part );
	
        /* This should force a save file dialog... */
        header("Content-type: application/octet-stream");
        break;
      
      case VIEW_ATTACH: {
	$mime = new mime_part_data;
	$mime->parse( $part );
	$mime->set_imap_data( $mailbox, $index, $bodypart );
	Header("content-type: text/html");
	if( isset($mime->action["view_function"]) ) {
	  $title = "MIME Attachment View";
	  include( "$default->include_dir/generic-header.inc" );
	  eval( "echo ".$mime->action["view_function"].'(\$mime);' );
	  include( "$default->include_dir/generic-footer.inc" );
	  exit;
	}
	
        if (($mime->subtype == 'jpeg') || ($mime->subtype == 'gif')) {
	  header("Content-type: image/$mime->subtype");
	} else {
	  /* do not set the encoding type to 1 here because it
	     potentially blows away our shot at decoding the
	     attachment when we need to.
	    $mime->encoding = 1; 
          */
	  header("Content-type: text/plain");
	}
      } break;
      
      case VIEW_SOURCE:
        if( !$default->view_message_source ) {
          echo "Not Authorized.";
        } else {
          header("Content-type: text/plain");
          echo imap_fetchheader ($mbox, $index ) . "\n" . imap_body ($mbox, $index );
          imap_close($mbox);
          exit; 
        }
        break;
      
      case SAVE_MESSAGE:
  	$h=imap_header($mbox,$index);
	$mime = new mime_part_data;
	$mime->name = chop(decode_mime_string($h->subject));
	$from = chop(decode_mime_string($h->fromaddress));
	$msg = "From " . $from . "\n";
	$msg = $msg . imap_fetchheader($mbox, $index, FT_PREFETCHTEXT);
	$body = $msg . imap_body ($mbox, $index);
	
        header("Content-type: application/RFC822");
	break;
      
    }
  }
  
  header("Content-Disposition: inline; filename=$mime->name");
  
  if (!$bodyonly && ($actionID != SAVE_MESSAGE)) {
    $bodypart++;
    $body = imap_fetchbody ($mbox, $index, $bodypart);
  } else {
    $body = imap_body($mbox,$index);
  }
  
  if ($mime->encoding == 3) { echo imap_base64($body); }
  else { echo $body; }
  
  imap_close($mbox);
?>
