<?php

/*
  
  File: prefs.php3
  $Author: chuck $
  $Revision: 1.25 $
  $Date: 1998/10/23 15:02:19 $
  
  IMP: Copyright 1998 Charles J. Hagenbuch <chuck@osmos.ml.org>
  
  You should have received a copy of the GNU Public
  License along with this package; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.
  
*/
  
  require( './lib/imp.lib' );              /* IMPlib is the IMP function library  */
  require( './config/defaults.conf' );     /* Defaults configuration file */
  if ($default->ssl->enabled) { include( './lib/ssl.lib' ); }
  error_reporting($default->error_level);  /* set error level from imp.lib   */
  require($default->db_lib);               /* DBlib is the db backend library     */
  
  /* send headers to ensure that the page will reload correctly. */
  header( 'Cache-Control: no-cache, must-revalidate' );
  header( 'Pragma: no-cache' );
  header( 'Expires: 0' );
  
  /* retrieve authentication information from cookies */
  $user    = getuser();
  $pass    = getpass();
  $server  = getsrvr();
  $port    = getport();
  $folders = getfldr();
  $mailbox = '';
  
  /* proceed only with a valid login */
  $mbox = validate_login($server, $port, $mailbox, $user, $pass);
  
  
  /* Run through the action handlers */
  if (isset($actionID)) {
    switch($actionID) {
      case NO_ACTION:
        break;
      
      case UPDATE_SIGNATURE:
        if (isset($signature)) {
	  if (!(imp_set_signature($signature, $user, $server))) {
	    $errormsg = '<tr><th>An error occured; your signature was not updated.</th></tr>';
	  }
	}
	break;
	
      case UPDATE_LANG:
        if (isset($lang)) {
	  if (!(imp_set_lang($lang, $user, $server))) {
	    $errormsg = '<tr><th>An error occured; your language was not updated.</th></tr>';
	  }
	}
	break;
      case UPDATE_FROM:
	if (isset($from)) {
	  if (!(imp_set_from($from,$user,$server))) {
	    $errormsg = '<tr><th>An error occured; your From was not updated.</th></tr>';
	  }
	}
	break;
      case UPDATE_FULLNAME:
	if (isset($fullname)) {
	  if (!(imp_set_fullname($fullname,$user,$server))) {
	    $errormsg = '<tr><th>An error occured; your full name was not updated.</th></tr>';
	  }
	}
	break;
    }
  }
  
  $cur_lang = imp_get_lang($user, $server);
  if (!isset($cur_lang)) { $cur_lang = ''; }
  
  $langs = '<select name=lang>';
  while (list($key, $val) = each($default->lang)) {
    if ($key == $cur_lang) { $sel = ' SELECTED'; }
    else { $sel = ''; }
    $langs .= "<option value=\"$key\" $sel>$val</option>\n";
  }
  $langs .= '</select>';
  
  $title = "IMP Preferences";
  $no_table_frame = false;
  $sidebar = false;
  require( "$default->include_dir/generic-header.inc" );
  require( "$default->include_dir/prefs.php3-signature.inc" );
  if($default->user_change_fullname) {
    require( "$default->include_dir/prefs.php3-fullname.inc");
  }
  if($default->user_change_from) {
    require( "$default->include_dir/prefs.php3-from.inc" );
  }
  require( "$default->include_dir/prefs.php3-lang.inc" );
  require( "$default->include_dir/generic-footer.inc" );
?>
