<?php

/*

  File: message.php3
  $Author: chuck $
  $Revision: 1.36 $
  $Date: 1998/10/23 15:02:19 $
  
  IMP : Copyright 1998 Charles J. Hagenbuch <chuck@osmos.ml.org>
  
  You should have received a copy of the GNU Public
  License along with this package; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.
  
*/
  
  require( './lib/imp.lib' );           /* IMPlib is the IMP function library */
  require( "./lib/mimetypes.lib" );     /* Mime handling routes */
  require( './config/defaults.conf' );  /* Defaults configuration file */
  
  if( $default->ssl->enabled )    { include( "./lib/ssl.lib" ); }
  
  error_reporting($default->error_level);  /* set error level from imp.lib   */
  
  header( 'Cache-Control: no-cache, must-revalidate' );
  header( 'Pragma: no-cache' );
  header( 'Expires: 0' );
  
  $user    = getuser();
  $pass    = getpass();
  $server  = getsrvr();
  $port    = getport();
  $folders = getfldr();
  if (!$mailbox) { $mailbox = 'INBOX'; }
  $current_mbox = eregi_replace("{$server}$folders*", '', $mailbox);

  if (strlen($default->personal_folders)>0)
    $current_mbox = eregi_replace("$default->personal_folders", '',$current_mbox);
  
  $mbox = validate_login($server, $port, $mailbox, $user, $pass);
  
  
  /* Run through action handlers */
  
  if (isset($actionID)) {
    switch ($actionID) {
      case NO_ACTION:
        break;
      
      case DELETE_MESSAGES:
        if ($index && $mailbox) {
	  if (!(imap_delete($mbox, $index))) {
	    $errormsg = '<tr><th colspan=2>An error occured; your message has not been deleted.</td></tr>';
	  }
	  $index++;
	}
	break;
    }
  }
  
  /* parse MIME header info */
  
  $structure = imap_fetchstructure($mbox, $index);
  $num_parts = count($structure->parts);
  
  function add_attachment( $mime ) {
    global $atc, $mailbox, $j, $index, $default;
    if ($mime->name == "") { $mime->name = 'attachment ' . $j; }
    if ($mime->size != 0) {
      if( !isset($atc) ) $atc = "";
      $atc .= $mime->display();
    }
  }    
  
  if (!isset($bodypart) || ($bodypart < 1)) { $bodypart = 1; }
  $j = 1;
  $msg = "&nbsp;";
  if ($num_parts > 1) {
  
    while ($j <= $num_parts) {
      if (isset($structure->parts[$j])) {
        $part = $structure->parts[$j];
	
	$mime = new mime_part_data;
	$mime->set_imap_data( $mailbox, $index, $j );
	$mime->parse( $part );
        add_attachment( &$mime );
      }
      $j++;
    }
    
    /* get and format the main body part */
    $msg = htmlentities(fill_paragraphs(imap_fetchbody($mbox, $index, $bodypart)));
    $msg = eregi_replace( "(http|https|ftp)://([-=%_a-zA-Z0-9./~?:]+)", "<a href=\"\\1://\\2\" target=\"_blank\">\\1://\\2</a>", $msg);
    
  } else {
    $mime = new mime_part_data;
    $mime->set_imap_data( $mailbox, $index, $j );
    $mime->parse( $structure );
    if( $mime->type == 1 ) {
      /* Safe to display, it is text */
      
      /* get and format the main body part */
      $msg = htmlentities(fill_paragraphs(imap_fetchbody($mbox, $index, $bodypart)));
      $msg = eregi_replace( "(http|https|ftp)://([-=%_a-zA-Z0-9./~?:]+)", "<a href=\"\\1://\\2\" target=\"_blank\">\\1://\\2</a>", $msg);
    } else {
      add_attachment( &$mime );
    }
  }
  
  if( $default->view_message_source ) {
    if( !isset($atc) ) $atc = "";
    $mime = new mime_part_data;
    $mime->set_type_full( "mail/source" );
    $atc .= "<a href=\"$default->root_url/view.php3?mailbox=" . urlencode($mailbox) . "&index=$index&bodypart=$j&actionID=" . VIEW_SOURCE . '">' . $mime->img_tag() . " (source)</a><br>";
  }

  
  $h = imap_header($mbox, $index);
  
  if (isset($h->date))            { $dat = htmlentities(chop($h->date )); }
  if (isset($h->toaddress))       { $to  = htmlentities(decode_mime_string(chop($h->toaddress ))); }
  if (isset($h->fromaddress))     { $frm = htmlentities(decode_mime_string(chop($h->fromaddress ))); }
  if (isset($h->ccaddress))       { $cc  = htmlentities(decode_mime_string(chop($h->ccaddress ))); }
  if (isset($h->reply_toaddress)) { $rep = htmlentities(decode_mime_string(chop($h->reply_toaddress ))); }
  if (isset($h->subject))         { $sub = htmlentities(decode_mime_string(chop($h->subject ))); }
  
  status( "Mailbox: $current_mbox: message $index of " . imap_num_msg($mbox));
  if (isset($sub)) {
    $title = "$mailbox: $sub";
  }
  else { $title = "$mailbox: [no subject]"; }

  $no_table_frame = false;
  $sidebar = false;
  require( "$default->include_dir/generic-header.inc" );
  
  $prev = $index - 1;
  $next = $index + 1;
  if ($index != imap_num_msg($mbox)) { $del_target = 'message.php3';
                                       $del_ident  = 'index'; }
  else { $del_target = 'mailbox.php3';
         $del_ident  = 'indices'; }
  
  require( "$default->include_dir/message.php3-navbar.inc" );
  require( "$default->include_dir/message.php3-headers.inc" );
  require( "$default->include_dir/message.php3-message.inc" );
  require( "$default->include_dir/message.php3-navbar.inc" );
  require( "$default->include_dir/generic-footer.inc" );
?>
