<?php

/*
  
  File: logviewer.php3
  $Author: chuck $
  $Revision: 1.2 $
  $Date: 1998/10/23 15:02:19 $
  
  IMP: Copyright 1998 Charles J. Hagenbuch <chuck@osmos.ml.org>
  
  You should have received a copy of the GNU Public
  License along with this package; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.
  
*/
  
  require( './lib/imp.lib' );           /* IMPlib is the IMP function library  */
  require( './config/defaults.conf' );  /* Defaults configuration file */
  require( $default->db_lib);
  if ($default->ssl->enabled) { include( './lib/ssl.lib' ); }
  
  error_reporting($default->error_level);  /* set error level from imp.lib   */
  header('Expires: 120');         /* make the page expire in 2 minutes   */
  
  /* retrieve authentication information from cookies */
  $user    = getuser();
  $pass    = getpass();
  $server  = getsrvr();
  $port    = getport();
  $folders = getfldr();
  $mailbox = '';

  /* proceed only with a valid login */
  $mbox = validate_login($server, $port, $mailbox, $user, $pass);
  
  $rows = imp_get_log($user);
  if( !$rows )
    status( "error getting log information");
  
  echo "<table border=1 cellpadding=2><caption>Log Information</caption>\n";
  echo "<tr><th>Timestamp<th>Target<th>Event<th>Message<th>MD5</tr>\n";
  for ( $i=0; $i < count( $rows ); $i++ ) {
    $row = $rows[$i];
    echo "<tr><td>".$row["ts"]."<td>".$row["target"]."<td>".$row["event"]."<td>".$row["log"]."<td>".$row["md5"]."</tr>\n";
  }
  echo "</table>\n";
  
?>
