<?php

/*
 
 File: lib/oracle.lib.php3
 $Author: chuck $
 $Revision: 1.5 $
 $Date: 1998/10/29 18:14:31 $
 
 Copyright Vadim Kolontsov <sb@123.org>
 Use it freely. Please notify me if something doesn't work.
 
 You should have received a copy of the GNU Public
 License along with this package; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 
*/


/* Settings - these may be different for different backends */

$db_user       = 'imp@oracle.world';      /* user to connect to the database as  */
$db_pass       = '*password*';		  /* database password, if any           */
$pref_table    = 'imp_pref';              /* the name of the prefs table         */
$address_table = 'imp_addr';              /* the name of the address table       */
$log_table     = 'log_addr';              /* the name of the address table       */

/* Table Structure for Oracle version

   (see scripts/oracle_create.sql)
   
   Preferences Table:

    field:     type:      	description:

    username   varchar2(255)	joe@imap.doe.com format username
    sig	       varchar2(2000)	signature
    fullname   varchar2(70)	Joe Doe
    replyto    varchar2(70)	joe@doe.com from and replyto address
    lang       varchar2(30)	users's preferred language (en, es, ...)
    (possibly more to be added later)
 
   Address Table:

    field:     type:          description:

    username   varchar2(255)  joe@doe.com identifier of who this entry belongs to
    address    varchar2(255)  address@mail.server.com - the actual address
    nickname   varchar2(255)  any entered nickname - ie "bonnie".
    fullname   varchar2(255)  full name - "My Bonnie".

   Log table:

    field:     type:          description:

    username   varchar2(255)  username
    ts	       date           date/time of event
    event      number
    target     varchar2(255)
    log	       varchar2(255)
    md5        varchar2(255)

*/


/* Required Functions - funtions that are called by other files and therefore
 * must be present in all db.lib implementations
 */


function imp_get_signature ($user, $server) {
   global $pref_table;
   
   /* post: returns the signature for the database key $user@$server
    (a string), or false on failure.
    */
   
   if (!enterOracle(&$conn, &$cursor, "SELECT sig from $pref_table where username='$user@$server'"))
     return false;
   
   if (Ora_Fetch($cursor))
     $result = Ora_GetColumn($cursor, 0);
   
   return leaveOracle($conn, $cursor, $result);
}

function imp_get_lang ($user, $server) {
   global $pref_table;
   
   /* post: returns the language
    */
   
   if (!enterOracle(&$conn, &$cursor, "SELECT lang from $pref_table where username='$user@$server'"))
     return false;
   
   if (Ora_Fetch($cursor))
     $result = Ora_GetColumn($cursor, 0);
   
   return leaveOracle($conn, $cursor, $result);
}

function imp_get_from ($user, $server) {
   global $pref_table;
   
   /* post: returns the replyto for the database key $user@$server
    (a string), or false on failure.
    */
   
   if (!enterOracle(&$conn, &$cursor, "SELECT replyto from $pref_table where username='$user@$server'"))
     return false;
   
   if (Ora_Fetch($cursor))
     $result = Ora_GetColumn($cursor, 0);
   
   return leaveOracle($conn, $cursor, $result);
}

function imp_get_fullname ($user, $server) {
   global $pref_table;
   
   /* post: returns the full name for the database key $user@$server
    (a string), or false on failure.
    */
   
   if (!enterOracle(&$conn, &$cursor, "SELECT fullname from $pref_table where username='$user@$server'"))
     return false;
   
   if (Ora_Fetch($cursor))
     $result = Ora_GetColumn($cursor, 0);
   
   return leaveOracle($conn, $cursor, $result);
}


function imp_set_fullname ($fullname, $user, $server) {
   global $pref_table;
   
   /* post: sets the replyto to $from for the database key $user@$server
    returns true on success and false on failure
    */
   
   if (!enterOracle(&$conn, &$cursor, 
		    "select username from $pref_table where username='$user@$server'"))
     return false;
   
   if (Ora_Fetch($cursor))
     $sql = "update $pref_table set fullname='$fullname' where username='$user@$server'";
   else
     $sql = "insert into $pref_table (username,fullname) values ('$user@$server', '$fullname')";
   
   Ora_Parse($cursor, $sql);
   
   if (!Ora_Exec($cursor))
     return leaveOracle($conn, $cursor, false);
   
   if (!Ora_Commit($conn))
     return leaveOracle($conn, $cursor, false);
   
   return leaveOracle($conn, $cursor, true);
}

function imp_set_lang ($lang, $user, $server) {
   global $pref_table;
   
   /* post: sets the language to $lang 
    */
   
   if (!enterOracle(&$conn, &$cursor, 
		    "select username from $pref_table where username='$user@$server'"))
     return false;
   
   if (Ora_Fetch($cursor))
     $sql = "update $pref_table set lang='$lang' where username='$user@$server'";
   else
     $sql = "insert into $pref_table (username,lang) values ('$user@$server', '$lang')";
   
   Ora_Parse($cursor, $sql);
   
   if (!Ora_Exec($cursor))
     return leaveOracle($conn, $cursor, false);
   
   if (!Ora_Commit($conn))
     return leaveOracle($conn, $cursor, false);
   
   return leaveOracle($conn, $cursor, true);
}

function imp_set_from ($from, $user, $server) {
   global $pref_table;
   
   /* post: sets the replyto to $from for the database key $user@$server
    returns true on success and false on failure
    */
   
   if (!enterOracle(&$conn, &$cursor,
		    $sql="select username from $pref_table where username='$user@$server'"))
     return false;
   
   if (Ora_Fetch($cursor)) /* no rows */
     $sql = "update $pref_table set replyto='$from' where username='$user@$server'";
   else
     $sql = "insert into $pref_table (username,replyto) values ('$user@$server','$from')";
   
   Ora_Parse($cursor, $sql);
   
   if (!Ora_Exec($cursor))
     return leaveOracle($conn, $cursor, false);
   
   if (!Ora_Commit($conn))
     return leaveOracle($conn, $cursor, false);
   
   return leaveOracle($conn, $cursor, true);
}


function imp_set_signature ($signature, $user, $server) {
   global $pref_table;
   
   /* post: sets the signature to $signature for the database key $user@$server
    returns true on success and false on failure
    */
   
   if (!enterOracle(&$conn, &$cursor,
		    "select username from $pref_table where username='$user@$server'"))
     return false;
   
   if (Ora_Fetch($cursor)) /* no rows */
     $sql = "update $pref_table set sig='$signature' where username='$user@$server'";
   else
     $sql = "insert into $pref_table (username,sig) values ('$user@$server', '$signature')";
   
   Ora_Parse($cursor, $sql);
   
   if (!Ora_Exec($cursor))
     return leaveOracle($conn, $cursor, false);
   
   if (!Ora_Commit($conn))
     return leaveOracle($conn, $cursor, false);
   
   return leaveOracle($conn, $cursor, true);
}


function imp_get_addresses ($user, $server) {
   global $address_table;
   
   /* post: returns a 2d array of addresses where each
    element is an array in which element 0 is the address,
    element 1 is the nickname, and element 2 is the fullname.
    it returns false on failure.
    */
   
   if (!enterOracle(&$conn, &$cursor, "SELECT address, nickname, fullname from $address_table where username='$user@$server' order by nickname"))
     return false;
   
   while (Ora_Fetch($cursor))
     $result[count($result)] = array(0=> Ora_GetColumn($cursor, 0), Ora_GetColumn($cursor, 1), Ora_GetColumn($cursor, 2));
   
   return leaveOracle($conn, $cursor, $result);
}


function imp_delete_address ($address, $user, $server) {
   global $address_table;
   
   /* post: deletes $address from the addressbook of $user@$server
    returns true on success and false on failure
    */
   
   if (!enterOracle(&$conn, &$cursor, "delete from $address_table where username='$user@$server' and address='$address'"))
     return false;
   
   if (!Ora_Commit($conn))
     return leaveOracle($conn, $cursor, false);
   
   return leaveOracle($conn, $cursor, true);
}


function imp_add_address ($address, $nickname, $fullname, $user, $server) {
   global $address_table;
   
   /* post: adds $address, $nickname, $fullname to the addressbook for $user@$server
    returns true on success and false on failure
    */
   
   if (!enterOracle(&$conn, &$cursor, "insert into $address_table values ('$user@$server', '$address', '$nickname', '$fullname')"))
     return false;
   
   if (!Ora_Commit($conn))
     return leaveOracle($conn, $cursor, false);
   
   return leaveOracle($conn, $cursor, true);
}


function imp_update_address ($old_address, $address, $nickname, $fullname, $user, $server) {
   global $address_table;
   
   /* post: changes the entry for $old_address to $address, $nickname, $fullname.
    returns true on success and false on failure
    */
   
   if (!enterOracle(&$conn, &$cursor, "update $address_table set address='$address', nickname='$nickname', fullname='$fullname' where username='$user@$server' and address='$old_address'"
		    ))
     return false;
   
   if (!Ora_Commit($conn))
     return leaveOracle($conn, $cursor, false);
   
   return leaveOracle($conn, $cursor, true);
}

function log_event( $user, $target, $event, $log, $md5 ) {
   global $default;
   
   if( ! $default->log->enabled ) { return true; }
   
   if (!enterOracle(&$conn, &$cursor, "insert into imp_log values ('$user',sysdate, $event,'$target','$log','$md5')"))
   {
      status("error committing log information");
      return false;
   }
   
   return leaveOracle($conn, $cursor, true);
}

function imp_get_log( $user)
{
   global $log_table;
   
   if (!enterOracle(&$conn, &$cursor, "select ts,target,event,log,md5 from imp_log where username = '$user' order by ts"))
     return false;
   
   while (Ora_Fetch($cursor))
     $result[count($result)] = array( "ts"=> Ora_GetColumn($cursor, 0),
				     "target"=> Ora_GetColumn($cursor, 1),
				     "event"=> Ora_GetColumn($cursor, 2),
				     "log"=> Ora_GetColumn($cursor, 3),
				     "md5"=> Ora_GetColumn($cursor, 4));
   
   return leaveOracle($conn, $cursor, $result);
}

/* Support Functions - functions which are only used by routines in this file,
 * and which therefore can change from implementation to implementation.
 */

/* Connect to oracle and execute the statement */
function enterOracle($conn, $cursor, $sql)
{                                     
   global $db_user, $db_pass;
   
   $conn = Ora_Logon($db_user, $db_pass);
   
   if ($conn < 0)                                  
     return leaveOracle($conn, 0, false);
   
   $cursor = Ora_Open($conn);
   
   if ($cursor < 0)
     return leaveOracle($conn, $cursor, false);
   
   Ora_CommitOff($conn);
   
   Ora_Parse($cursor, $sql);
   
   if (!Ora_Exec($cursor))
     return leaveOracle($conn, $cursor, false);
   
   return true;
}

/* Disconnect from Oracle and return results.. */
function leaveOracle($conn, $cursor, $result)
{
   if ($cursor)
     Ora_Close($cursor);
   
   Ora_Logoff($conn);
   
   return $result;
}

?>
