<?php

/*
   
   File : lib/oracle.lib.php3
   
   Just a quick hack by Vadim Kolontsov <sb@123.org>
   Feel free to use it or throw away

*/


/* Settings - these may be different for different backends */

$db_user       = 'imp@oracle.world';      /* user to connect to the database as  */
$db_pass       = '*password*';            /* database password, if any           */
$pref_table    = 'imp_pref';              /* the name of the prefs table         */
$address_table = 'imp_addr';              /* the name of the address table       */

/* Table Structure for Oracle version:
   
   Preferences Table:
    field:     type:      description:
    user       char(255)  joe@imap.doe.com format username
    sig        long       signature
    replyto    char(70)   joe@doe.com from and replyto address
    fullname   char(70)   Joe Doe
    (possibly more to be added later)
 
   Address Table:
    field:     type:      description:
    user       char(255)  joe@doe.com identifier of who this entry belongs to
    address    char(255)  address@mail.server.com - the actual address
    nickname   char(255)  any entered nickname - ie "bonnie".
    fullname   char(255)  full name - "My Bonnie".

  I'm using the following script:
------------------------------------- oracle.sql --------------------
DROP TABLE IMP_PREF;

CREATE TABLE IMP_PREF (
  USERNAME			VARCHAR2(255) NOT NULL,
  SIG				VARCHAR2(2000),
  REPLYTO                       VARCHAR2(70),
  FULLNAME			VARCHAR2(70)
);

DROP TABLE IMP_ADDR;

CREATE TABLE IMP_ADDR (
  USERNAME			VARCHAR2(255) NOT NULL,
  ADDRESS			VARCHAR2(255),
  NICKNAME			VARCHAR2(255),
  FULLNAME			VARCHAR2(255)
);
----------------------------------------------------------------------

*/


/* Required Functions - funtions that are called by other files and therefore
 * must be present in all db.lib implementations
 */


function imp_get_signature ($user, $server) {
  global $pref_table;
  
  /* post: returns the signature for the database key $user@$server
           (a string), or false on failure.
  */
  
  if (!enterOracle(&$conn, &$cursor, "SELECT sig from $pref_table where username='$user@$server'"))
    return false;
  
  if (Ora_Fetch($cursor) == 1)
    $result = Ora_GetColumn($cursor, 0);

  return leaveOracle($conn, $cursor, $result);
}
function imp_get_from ($user, $server) {
  global $pref_table;
  
  /* post: returns the replyto for the database key $user@$server
           (a string), or false on failure.
  */
  
  if (!enterOracle(&$conn, &$cursor, "SELECT replyto from $pref_table where username='$user@$server'"))
    return false;
  
  if (Ora_Fetch($cursor) == 1)
    $result = Ora_GetColumn($cursor, 0);

  return leaveOracle($conn, $cursor, $result);
}

function imp_get_fullname ($user, $server) {
  global $pref_table;
  
  /* post: returns the full name for the database key $user@$server
           (a string), or false on failure.
  */
  
  if (!enterOracle(&$conn, &$cursor, "SELECT fullname from $pref_table where username='$user@$server'"))
    return false;
  
  if (Ora_Fetch($cursor) == 1)
    $result = Ora_GetColumn($cursor, 0);

  return leaveOracle($conn, $cursor, $result);
}


function imp_set_fullname ($fullname, $user, $server) {
  global $pref_table;
  
  /* post: sets the replyto to $from for the database key $user@$server
           returns true on success and false on failure
  */
  
  $sql="select username from $pref_table where username='$user@server'";
  if (!enterOracle(&$conn, &$cursor, $sql)) 
     return false;
  
  if (Ora_Commit($cursor) < 0) { /* no rows */
    leaveOracle($conn, $cursor, false);
    $sql = "insert into $pref_table (user,fullname) values ('$user@$server', '$fullname')";
  } else {
    leaveOracle($conn, $cursor, true);
    $sql = "update $pref_table set fullname='$fullname' where username='$user@$server'";
  }
  
  if (!enterOracle(&$conn, &$cursor, $sql)) 
     return false;
  
  if (Ora_Commit($cursor) < 0)
     return leaveOracle($conn, $cursor, false);

  return leaveOracle($conn, $cursor, true);
}
function imp_set_from ($from, $user, $server) {
  global $pref_table;
  
  /* post: sets the replyto to $from for the database key $user@$server
           returns true on success and false on failure
  */
  
  $sql="select username from $pref_table where username='$user@server'";
  if (!enterOracle(&$conn, &$cursor, $sql)) 
     return false;
  
  if (Ora_Commit($cursor) < 0) { /* no rows */
    leaveOracle($conn, $cursor, false);
    $sql = "insert into $pref_table (username,replyto) values ('$user@$server','$from')";
  } else {
    leaveOracle($conn, $cursor, true);
    $sql = "update $pref_table set replyto='$from' where username='$user@$server'";
  }
  
  if (!enterOracle(&$conn, &$cursor, $sql)) 
     return false;
  
  if (Ora_Commit($cursor) < 0)
     return leaveOracle($conn, $cursor, false);

  return leaveOracle($conn, $cursor, true);
}


function imp_set_signature ($signature, $user, $server) {
  global $pref_table;
  
  /* post: sets the signature to $signature for the database key $user@$server
           returns true on success and false on failure
  */
  
  $sql="select username from $pref_table where username='$user@server'";
  if (!enterOracle(&$conn, &$cursor, $sql)) 
     return false;
  
  if (Ora_Commit($cursor) < 0) { /* no rows */
    leaveOracle($conn, $cursor, false);
    $sql = "insert into $pref_table (username,sig) values ('$user@$server', '$signature')";
  } else {
    leaveOracle($conn, $cursor, true);
    $sql = "update $pref_table set sig='$signature' where username='$user@$server'";
  }
  
  if (!enterOracle(&$conn, &$cursor, $sql)) 
     return false;
  
  if (Ora_Commit($cursor) < 0)
     return leaveOracle($conn, $cursor, false);

  return leaveOracle($conn, $cursor, true);
}
                                       

function imp_get_addresses ($user, $server) {
  global $address_table;
  
  /* post: returns a 2d array of addresses where each
           element is an array in which element 0 is the address,
	   element 1 is the nickname, and element 2 is the fullname.
	   it returns false on failure.
  */
  
  if (!enterOracle(&$conn, &$cursor, "SELECT address, nickname, fullname from $address_table where username='$user@$server' order by nickname"))
    return false;
  
  while (Ora_Fetch($cursor))
    $result[count($result)] = array(0=> Ora_GetColumn($cursor, 0), Ora_GetColumn($cursor, 1), Ora_GetColumn($cursor, 2));
  
  return leaveOracle($conn, $cursor, $result);
}


function imp_delete_address ($address, $user, $server) {
  global $address_table;
  
  /* post: deletes $address from the addressbook of $user@$server
           returns true on success and false on failure
  */
  
  if (!enterOracle(&$conn, &$cursor, "delete from $address_table where username='$user@$server' and address='$address'"))
    return false;
  
  if (Ora_Commit($cursor) < 0)
     return leaveOracle($conn, $cursor, false);

  return leaveOracle($conn, $cursor, true);
}


function imp_add_address ($address, $nickname, $fullname, $user, $server) {
  global $address_table;
  
  /* post: adds $address, $nickname, $fullname to the addressbook for $user@$server
           returns true on success and false on failure
  */
  
  if (!enterOracle(&$conn, &$cursor, "insert into $address_table values ('$user@$server', '$address', '$nickname', '$fullname')"))
    return false;
  
  if (Ora_Commit($cursor) < 0)
    return leaveOracle($conn, $cursor, false);
  
  return leaveOracle($conn, $cursor, true);
}


function imp_update_address ($old_address, $address, $nickname, $fullname, $user, $server) {
  global $address_table;
  
  /* post: changes the entry for $old_address to $address, $nickname, $fullname.
           returns true on success and false on failure
  */
  
  if (!enterOracle(&$conn, &$cursor, "update $address_table set address='$address', nickname='$nickname', fullname='$fullname' where username='$user@$server' and address='$old_address'"
))
    return false;
  
  if (Ora_Commit($cursor) < 0)
     return leaveOracle($conn, $cursor, false);
  
  return leaveOracle($conn, $cursor, true);
}

/* Support Functions - functions which are only used by routines in this file,
 * and which therefore can change from implementation to implementation.
 */

/* Connect to oracle and execute the statement */
function enterOracle($conn, $cursor, $sql)
{                                     
   global $db_user, $db_pass;
                                       
   $conn = Ora_Logon($db_user, $db_pass);
                                                   
   if ($conn < 0)                                  
     return leaveOracle($conn, 0, false);
                          
   $cursor = Ora_Open($conn);

   if ($cursor < 0)
     return leaveOracle($conn, $cursor, false);

   Ora_CommitOff($conn);
   
  if (Ora_Parse($cursor, $sql) < 0)
     return leaveOracle($conn, $cursor, false);

  if (Ora_Exec($cursor) < 0)
     return leaveOracle($conn, $cursor, false);

   return true;
}

/* Disconnect from Oracle and return results.. */
function leaveOracle($conn, $cursor, $result)
{
   if ($cursor)
     Ora_Close($cursor);
   Ora_Logoff($conn);
  
   return $result;
}



/* end db.lib */

?>
