<?php

/*
   
   File: lib/mysql.lib.php3
   $Author: chuck $
   $Revision: 1.16 $
   $Date: 1998/10/19 23:39:55 $
   
   IMP: Copyright 1998 Charles J. Hagenbuch <chuck@osmos.ml.org>
   
   This code is under the GNU Public License
   See the file COPYING in this directory
   
*/


/* Settings - these may be different for different backends */

$imp_db        = 'test';                /* the name of imp's db                */
$db_server     = 'localhost';           /* where the database server is        */
$db_user       = 'nobody';              /* user to connect to the database as  */
$db_pass       = '';                    /* database password, if any           */
$pref_table    = 'imp_pref';            /* the name of the prefs table         */
$address_table = 'imp_addr';            /* the name of the address table       */


/* Table Structure for MySQL version:
   
   Preferences Table:
    field:     type:        description:
    user       text         joe@imap.doe.com format username
    sig        text         signature
    fullname   text         'Joe Doe' 
    replyto    text         joe@doe.com format
    lang       varchar(30)  users's preferred language (en, es, ...)
    (possibly more to be added later)
 
   Address Table:
    field:     type:      description:
    user       text       joe@doe.com identifier of who this entry belongs to
    address    text       address@mail.server.com - the actual address
    nickname   text       any entered nickname - ie "bonnie".
    fullname   text       full name - "My Bonnie".
*/


/* Required Functions - funtions that are called by other files and therefore
 * must be present in all db.lib implementations
 */

function imp_get_from ($user, $server) {
  global $imp_db, $db_server, $db_user, $db_pass, $pref_table;
  
  /* post: returns the replyto for the database key $user@$server
           (a string), or false on failure.
  */
  
  if (!($db = mysql_pconnect($db_server, $db_user, $db_pass))) { return false; }
  if (!($imp = mysql_select_db($imp_db, $db))) { return false; }
  if (!($result = mysql_db_query($imp_db, "select replyto from $pref_table where user='$user@$server'", $db))) { return false; }
  
  return(mysql_result($result, 0, 0));
}

function imp_get_fullname ($user, $server) {
  global $imp_db, $db_server, $db_user, $db_pass, $pref_table;
  
  /* post: returns the fullname for the database key $user@$server
           (a string), or false on failure.
  */
  
  if (!($db = mysql_pconnect($db_server, $db_user, $db_pass))) { return false; }
  if (!($imp = mysql_select_db($imp_db, $db))) { return false; }
  if (!($result = mysql_db_query($imp_db, "select fullname from $pref_table where user='$user@$server'", $db))) { return false; }
  
  return(mysql_result($result, 0, 0));
}

function imp_get_signature ($user, $server) {
  global $imp_db, $db_server, $db_user, $db_pass, $pref_table;
  
  /* post: returns the signature for the database key $user@$server
           (a string), or false on failure.
  */
  
  if (!($db = mysql_pconnect($db_server, $db_user, $db_pass))) { return false; }
  if (!($imp = mysql_select_db($imp_db, $db))) { return false; }
  if (!($result = mysql_db_query($imp_db, "select sig from $pref_table where user='$user@$server'", $db))) { return false; }
  
  return(mysql_result($result, 0, 0));
}

function imp_set_from ($from, $user, $server) {
  global $imp_db, $db_server, $db_user, $db_pass, $pref_table;
  
  /* post: sets the signature to $signature for the database key $user@$server
           returns true on success and false on failure
  */

  /* There should in future be a "check_user_prefs()" function to do this.
     Until I write one, this will probably work. */
  $sql="select user from $pref_table where user='$user@server'";
  if (!($db = mysql_pconnect($db_server, $db_user, $db_pass))) { return false; }
  if (!($imp = mysql_select_db($imp_db, $db))) { return false; }
  if (!($result = mysql_db_query($imp_db, $sql, $db))) { /* New row */
    $sql = "insert into $pref_table (user, replyto) values ('$user@$server','$from')";
  } else {
    $sql = "update $pref_table set replyto='$from' where user='$user@$server'";
  }
  
/*  if (!($db = mysql_pconnect($db_server, $db_user, $db_pass))) { return false; }
  if (!($imp = mysql_select_db($imp_db, $db))) { return false; } */

  if (!($result = mysql_db_query($imp_db, $sql, $db))) { return false; }
  
  return true;
}

function imp_set_fullname ($fullname, $user, $server) {
  global $imp_db, $db_server, $db_user, $db_pass, $pref_table;
  
  /* post: sets the signature to $signature for the database key $user@$server
           returns true on success and false on failure
  */
  
  /* There should in future be a "check_user_prefs()" function to do this.
     Until I write one, this will probably work. */
  $sql="select user from $pref_table where user='$user@server'";
  if (!($db = mysql_pconnect($db_server, $db_user, $db_pass))) { return false; }
  if (!($imp = mysql_select_db($imp_db, $db))) { return false; }
  if (($result = mysql_db_query($imp_db, $sql, $db))) { /* New row */
    $sql = "update $pref_table set fullname='$fullname' where user='$user@$server'";
  } else {
    $sql = "insert into $pref_table (user, fullname) values ('$user@$server','$fullname')";
  }
  
/*
  if (!($db = mysql_pconnect($db_server, $db_user, $db_pass))) { return false; }
  if (!($imp = mysql_select_db($imp_db, $db))) { return false; }
*/
  if (!($result = mysql_db_query($imp_db, $sql, $db))) { return false; }
  
  return true;
}


function imp_get_lang ($user, $server) {
  global $imp_db, $db_server, $db_user, $db_pass, $pref_table;
  
  /* post: returns the signature for the database key $user@$server
           (a string), or false on failure.
  */
  
  if (!($db = mysql_pconnect($db_server, $db_user, $db_pass))) { return false; }
  if (!($imp = mysql_select_db($imp_db, $db))) { return false; }
  if (!($result = mysql_db_query($imp_db, "select lang from $pref_table where user='$user@$server'", $db))) { return false; }
  
  return(mysql_result($result, 0, 0));
}


function imp_set_signature ($signature, $user, $server) {
  global $imp_db, $db_server, $db_user, $db_pass, $pref_table;
  
  /* post: sets the signature to $signature for the database key $user@$server
           returns true on success and false on failure
  */
  
  if (imp_get_signature($user, $server)) {
    $sql = "update $pref_table set sig='$signature' where user='$user@$server'";
  } else {
    $sql = "insert into $pref_table (user, sig) values ('$user@$server', '$signature')";
  }
  
  if (!($db = mysql_pconnect($db_server, $db_user, $db_pass))) { return false; }
  if (!($imp = mysql_select_db($imp_db, $db))) { return false; }
  if (!($result = mysql_db_query($imp_db, $sql, $db))) { return false; }
  
  return true;
}


function imp_set_lang ($lang, $user, $server) {
  global $imp_db, $db_server, $db_user, $db_pass, $pref_table;
  
  /* post: sets the language to $lang for the database key $user@$server
           returns true on success and false on failure
  */
  
  if (imp_get_lang($user, $server) || imp_get_signature($user, $server)) {
    $sql = "update $pref_table set lang='$lang' where user='$user@$server'";
  } else {
    $sql = "insert into $pref_table (user, lang) values ('$user@$server', '$lang')";
  }
  
  if (!($db = mysql_pconnect($db_server, $db_user, $db_pass))) { return false; }
  if (!($imp = mysql_select_db($imp_db, $db))) { return false; }
  if (!($result = mysql_db_query($imp_db, $sql, $db))) { return false; }
  
  return true;
}


function imp_get_addresses ($user, $server) {
  global $imp_db, $db_server, $db_user, $db_pass, $address_table;
  
  /* post: returns a 2d array of addresses where each
           element is an array in which element 0 is the address,
	   element 1 is the nickname, and element 2 is the fullname.
	   it returns false on failure.
  */
  
  if (!($db = mysql_pconnect($db_server, $db_user, $db_pass))) { return false; }
  if (!($imp = mysql_select_db($imp_db, $db))) { return false; }
  if (!($result = mysql_db_query($imp_db, "select address, nickname, fullname from $address_table where user='$user@$server' order by nickname", $db))) { return false; }
  
  while ($rows = mysql_fetch_row($result)) {
    $return[] = $rows;
  }
  
  return($return);
}


function imp_delete_address ($address, $user, $server) {
  global $imp_db, $db_server, $db_user, $db_pass, $address_table;
  
  /* post: deletes $address from the addressbook of $user@$server
           returns true on success and false on failure
  */
  
  if (!($db = mysql_pconnect($db_server, $db_user, $db_pass))) { return false; }
  if (!($imp = mysql_select_db($imp_db, $db))) { return false; }
  if (!($result = mysql_db_query($imp_db, "delete from $address_table where user='$user@$server' and address='$address'", $db))) { return false; }
  
  return true;
}


function imp_add_address ($address, $nickname, $fullname, $user, $server) {
  global $imp_db, $db_server, $db_user, $db_pass, $address_table;
  
  /* post: adds $address, $nickname, $fullname to the addressbook for $user@$server
           returns true on success and false on failure
  */
  
  if (!($db = mysql_pconnect($db_server, $db_user, $db_pass))) { return false; }
  if (!($imp = mysql_select_db($imp_db, $db))) { return false; }
  if (!($result = mysql_db_query($imp_db, "insert into $address_table values ('$user@$server', '$address', '$nickname', '$fullname')", $db))) { return false; }
  
  return true;
}


function imp_update_address ($old_address, $address, $nickname, $fullname, $user, $server) {
  global $imp_db, $db_server, $db_user, $db_pass, $address_table;
  
  /* post: changes the entry for $old_address to $address, $nickname, $fullname.
           returns true on success and false on failure
  */
  
  if (!($db = mysql_pconnect($db_server, $db_user, $db_pass))) { return false; }
  if (!($imp = mysql_select_db($imp_db, $db))) { return false; }
  if (!($result = mysql_db_query($imp_db, "update $address_table set address='$address', nickname='$nickname', fullname='$fullname' where user='$user@$server' and address='$old_address'", $db))) { return false; }
  
  return true;
}


/* Support Functions - functions which are only used by routines in this file,
 * and which therefore can change from implementation to implementation.
 */

/* end db.lib */

?>
