<?php

/*
   File: lib/db/mysql.lib.php3
   $Author: zerodiv $
   $Revision: 1.13 $
   $Date: 1998/10/19 21:50:26 $

   IMP : Copyright 1998 Charles J. Hagenbuch chuck@osmos.ml.org

   This code is under the GNU Public License
   See the file COPYING in this directory

File Purpose:
This file contains the database support for mysql.

*/

/*
HordeMysqlDb : Defines all the interaction with the base
   horde tables.
*/

class HordeMysqlDb {
   var $user_name;
   var $password;
   var $server_name;
   var $server_port;
   var $db_name;
   var $db_connect_string;
   var $db_connection_handle;
   var $persistent_mode;
   var $connection_init;

   /* The following object api MUST be within all database objects */
   var $User;
   var $Grant;
   var $ImapServer;

   Function HordeMysqlDb() {

      $this->user_name              = '';
      $this->password               = '';
      $this->server_name            = 'localhost';
      $this->server_port            = '';
      $this->db_name                = '';
      $this->db_connect_string      = '';
      $this->db_connection_handle   = undef;
      $this->persistent_mode        = true;
      $this->connection_init        = false;

      /* The following object api MUST be within all database objects */
      $this->User                   = new HordeMysqlDb_User;

      } /* END HordeMysqlDb() */

   /* CascadeConnection() -   Cascades the connection handle down to 
                              the subobjects */
   Function CascadeConnection() {
      $this->User->db_connection_handle   = $this->db_connection_handle;
      } /* END CascadeConnection() */

   Function BuildConnectString() {

      $this->db_connect_string = $this->server_name;

      if ( $this->server_port != '' ) {
         $this->db_connect_string .= ':' . $this->port_name;
         }

      } /* END BuildConnectionString */

   Function CreateConnection() {

      $this->BuildConnectString();

      if (
         $this->persistent_mode == true &&
         $this->connection_init == false ) {

         /* Open the connection to the database */
         if ( !(
               $this->db_connection_handle =
               mysql_pconnect(
                  $this->db_connect_string,
                  $this->user_name,
                  $this->password )
               ) ) {
            return array( false, DB_INVALID_USERNAME_PASSWORD, 'Invalid username / password combonation.' );
            }

         /* Switch to the horde database for that connection */
         if ( !( $db_test = mysql_select_db(
               $this->db_name, $this->db_connection_handle )
               )  ) { 
            return array( false, DB_DATABASE_FAILED, 'Select database : ' . $this->db_name . ' failed, check for database existance, or misconfiguration' );
            }

         $this->CascadeConnection();

         return array( true, $this->db_connection_handle );

         }

      if ( 
         $this->persistent_mode == true &&
         $this->connection_init == true ) {
         $this->CascadeConnection();
         return array( $this->db_connection_handle );
         } 

      } /* END CreateConnection() */

      
   } /* END HordeMysqlDb class */

class HordeMysqlDb_User {
   var $db_connection_handle;
   var $autocreate_user;
   /*
   Function       : HordeMysqlDbUser
   Parameters     : NONE
   Return Values  : NONE
   Purpose        : To instanciate a instance of the HordeMysqlDb object.
   */
   Function HordeMysqlDb_User() {
      $this->db_connection_handle   = undef;
      $this->autocreate_user        = false;
      } /* END HordeMysqlDb_User() */

   /*
   Function       : Verify
   Parameters     : (HordeUser)
   Return Values  :                    
      TRUE                             
      FALSE, Error Id
   Purpose        : To verify a users access to the horde system.
   */
   Function Verify( $ThisUser ) {

      /* Make sure the database handle is available */
      if ( $this->db_connection_handle == undef ) {
         return array( false, DB_NOT_CONNECTED, 'No connection available to object.' );
         }

      list( $return_val, $TempUser ) = $this->Get( $ThisUser );
      if ( $return_val == false ) {
         /* User not found and or another error */
         list( $return_val, $error_code, $reason )
            = $this->Get( $ThisUser );
         if ( $error_code == DB_NO_MATCH_FOUND
               && $this->autocreate_user == true ) {
            /* Auto create the user */
            $this->Add( $ThisUser );
            return true;
            }
         } /* End if NOT found and other error */

      if ( $TempUser->login_deny == true ) {
         return array( false, DENY_LOGIN, 'Your account has been locked out.' );
         }

      } /* END Verify() */

   /*
   Function       : Get
   Parameters     : (HordeUser)
   Return Values  :                       
      (HordeUser) $ThisUser               
      FALSE, ERROR_ID
   Purpose        : Finds a user with the attributes that are passed in.
   */
   Function Get( $ThisUser ) {

      /* Make sure the database handle is available */
      if ( $this->db_connection_handle == undef ) {
         return array( false, DB_NOT_CONNECTED, 'No connection available to object.' );
         }

      /* Build up the query string */
      $query_string = '';
      $query_string .= 'SELECT
                        user_id, user_name, user_password,
                        login_deny FROM horde_user_table';
      $more_than_one = false;

      if ( $ThisUser->user_id ) {
         $query_string .= 'user_id = ' . $ThisUser->user_id;
         $more_than_one = true;
         }

      if ( $more_than_one == true ) { $query_string .= ' AND'; }

      if ( $ThisUser->user_name ) {
         $query_string .= 'user_name = "' . $user_name . '"';
         $more_than_one = true;
         }

      if ( $more_than_one == true ) { $query_string .= ' AND'; }

      if ( $ThisUser->password ) {
         $query_string .= 'password = "' . $password . '"';
         $more_than_one = true;
         }

      $query_string .= ';';

      if ( ! $result_handle = mysql_db_query( $this->db_connection_handle, $query_string ) )
         {
         return array( false, DB_QUERY_FAILED, 'Database query of : ' . $query_string . ' failed.' );
         }
      $ResultObj = new HordeUser;
      if ( ! (
               list( $user_id, $user_name, $password, $login_deny )
               = mysql_fetch_row( $result_handle )) ){
         return array( false, DB_NO_MATCH_FOUND, 'NO Match found.' );
         }

      $ResultObject->user_id     = $user_id;
      $ResultObject->user_name   = $user_name;
      $ResultObject->password    = $password;
      $ResultObject->login_deny  = $login_deny;

      return array( true, $ResultObject );

      } /* END Get() */

   /*
   Function       : Add
   Parameters     : (HordeUser)
   Return Values  :                       
      TRUE,  (hordeuser)                                
      FALSE, ERROR_ID
   Purpose        : Adds a user with the attributes defined in the
                    $ThisUser that is passed in.
   */
   Function Add( $ThisUser ) {

      /* Make sure the database handle is available */
      if ( $this->db_connection_handle == undef ) {
         return array( false, DB_NOT_CONNECTED, 'No connection available to the object.' );
         }

      $query_string = '';
      $query_string =
         'INSERT INTO horde_user_table
            ( horde_user_name, horde_password, login_deny ) VALUES (';
      if ( $ThisUser->user_name == '' ) {
         return array( false, DB_INSERT_FAILED, 'NO user name provided' );
         } else {
         $query_string .=  "'" . $ThisUser->user_name . "', ";
         }
      if ( $ThisUser->user_password == '' ) {
         return array( false, DB_INSERT_FAILED, 'NO password provided' );
         } else {
         $query_string .= "'" . $ThisUser->user_password . "', ";
         }
      if ( $ThisUser->login_deny == undef
            || $ThisUser->login_deny == true  ) {
         $ThisUser->login_deny = 1;
         } else { 
         $ThisUser->login_deny = 0;
         }
      $query_string .= $ThisUser->login_deny;
      $query_string .= ' )';
      /*
      echo( '<BR><code><pre>' . $query_string . '</pre></code><BR><BR>' );             
      */
      if ( ! ( $result_handle = mysql_query(
            $query_string,
            $this->db_connection_handle
             ) ) ) {
         return array( false, DB_INSERT_FAILED, 'Insert to table failed.' );
         } else {
         return array( true, $ThisUser );
         }
      } /* END Add() */

   /*
   Function       : Modify
   Parameters     : (HordeUser->user_id), (HordeUser) 
   Return Values  :                       
      TRUE                                
      FALSE, ERROR_ID
   Purpose        : Modify the user_id(x)'s member data to contain
                    the new data provided within the
                    passed in object
   */
   Function Modify( $user_id, $ThisUser ) {

      /* Make sure the database handle is available */
      if ( $this->db_connection_handle == undef ) {
         return array( false, DB_NOT_CONNECTED, 'NO connection available to the object' );
         }
      if ( $user_id != '' ) { 
         } else {
         return array( false, DB_QUERY_FAILED, 'Please provide a user id.' );
         }
      $query_string = '';
      $more_than_one = false;
      $query_string = 'UPDATE horde_user_table SET ';
      if ( $ThisUser->user_name != '' ) {
         $query_string .= " horde_user_name = '" . $ThisUser->user_name . "'";
      }
      if ( $ThisUser->user_password != '' ) {
         $query_string .= ", horde_password = '" . $ThisUser->user_password . "'";
      }
      if ( $ThisUser->login_deny == undef
            || $ThisUser->login_deny == true  ) {
         $query_string .= ", login_deny = 1";
         } else { 
         $query_string .= ", login_deny = 0";
         }
      if ( $ThisUser->user_id != '' ) {
         $query_string .= ', horde_user_id = ' . $ThisUser->user_id;
      }
      $query_string .= " where horde_user_id = $user_id";
      if ( ! ( $result_handle = mysql_query(
            $query_string,
            $this->db_connection_handle
             ) ) ) {
         return array( false, DB_QUERY_FAILED, 'Query Failed : ' . $query_string );
         }
     
      return array( true, $ThisUser );
      } /* END Modify */

   /*
   Function       : Delete
   Parameters     : (HordeUser->user_id)
   Return Values  :
      TRUE
      FALSE, ERROR_ID
   Purpose        : To delete a user_id(x)'s data from the database.
   */
   Function Delete( $user_id ) {

      /* Make sure the database handle is available */
      if ( $this->db_connection_handle == undef ) {
         return array( false, DB_NOT_CONNECTED );
         }

      } /* END Delete */

   /*
   Function       : ListAll
   Parameters     : NONE
   Return Values  : Array of HordeUser objects
   Purpose        : To list all of the users within the system.
   */
   Function ListAll() {

      /* Make sure the database handle is available */
      if ( $this->db_connection_handle == undef ) {
         return array( false, DB_NOT_CONNECTED );
         }
      $query_string = '';
      $query_string =
         'SELECT horde_user_id, horde_user_name, horde_password, login_deny FROM horde_user_table ORDER BY horde_user_id';
      
      if ( ! ( $result_handle = mysql_query(
            $query_string,
            $this->db_connection_handle
             ) ) ) {
         return array( false, DB_QUERY_FAILED, 'Query Failed' );
         }
     
      $i = 0; 
      $ResultArray   = array();
      $ResultObj     = new HordeUser;

      while( list( $user_id, $user_name, $password, $login_deny ) = mysql_fetch_row( $result_handle ) ) {
         /* Loop through the output and build the array */
         $ResultObj->user_id     = undef;
         $ResultObj->user_name   = undef;
         $ResultObj->password    = undef;
         $ResultObj->login_deny  = undef;
         $ResultObj->user_id     = $user_id;
         $ResultObj->user_name   = $user_name;
         $ResultObj->password    = $password;
         $ResultObj->login_deny  = $login_deny;
         $ResultArray[ $i ] = $ResultObj;
         $i++;
      }
      return array( true, $i, $ResultArray );
      } /* END List All */

   }

?>
