<?php

/*
  
  File: prefs.php3
  $Author: chuck $
  $Revision: 1.20 $
  $Date: 1998/10/09 03:01:39 $
  
  IMP: Copyright 1998 Charles J. Hagenbuch <chuck@osmos.ml.org>
  
  This code is under the GNU Public License
  See the file COPYING in this directory
  
*/
  
  require( './lib/imp.lib.php3' );         /* IMPlib is the IMP function library  */
  require( './config/defaults.php3' );     /* Defaults configuration file */
  if ($default->ssl->enabled) { include( './lib/ssl_lib.php3' ); }
  error_reporting($default->error_level);  /* set error level from imp.lib.php3   */
  require($default->db_lib);               /* DBlib is the db backend library     */
  
  /* send headers to ensure that the page will reload correctly. */
  header( 'Cache-Control: no-cache, must-revalidate' );
  header( 'Pragma: no-cache' );
  header( 'Expires: 0' );
  
  /* retrieve authentication information from cookies */
  $user    = getuser();
  $pass    = getpass();
  $server  = getsrvr();
  $port    = getport();
  $folders = getfldr();
  $mailbox = '';
  
  /* proceed only with a valid login */
  $mbox = validate_login($server, $port, $mailbox, $user, $pass);
  
  
  /* Run through the action handlers */
  if (isset($actionID)) {
    switch($actionID) {
      case NO_ACTION:
        break;
      
      case UPDATE_SIGNATURE:
        if (isset($signature)) {
	  if (!(imp_set_signature($signature, $user, $server))) {
	    $errormsg = '<tr><th>An error occured; your signature was not updated.</th></tr>';
	  }
	}
	break;
	
      case UPDATE_LANG:
        if (isset($lang)) {
	  if (!(imp_set_lang($lang, $user, $server))) {
	    $errormsg = '<tr><th>An error occured; your language was not updated.</th></tr>';
	  }
	}
	break;
    }
  }
  
  $cur_lang = imp_get_lang($user, $server);
  if (!isset($cur_lang)) { $cur_lang = ''; }
  
  $langs = '<select name=lang>';
  while (list($key, $val) = each($default->lang)) {
    if ($key == $cur_lang) { $sel = ' SELECTED'; }
    else { $sel = ''; }
    $langs .= "<option value=\"$key\" $sel>$val</option>\n";
  }
  $langs .= '</select>';
  
  $title = "IMP Preferences";
  $no_table_frame = false;
  $sidebar = false;
  require( "$default->include_dir/generic-header.inc" );
  require( "$default->include_dir/prefs.php3-signature.inc" );
  require( "$default->include_dir/prefs.php3-lang.inc" );
  require( "$default->include_dir/generic-footer.inc" );
?>
