<?php

/*
   
   File : lib/signature_lib.php3
   $Author: paudley $
   $Revision: 1.5 $
   $Date: 1998/10/01 20:20:22 $
   
   IMP : Copyright 1998 Patrick C. Audley paudley@blackcat.ca
   
   This code is under the GNU Public License
   See the file COPYING in this directory

*/

$sig_light_bg = "dddddd";
$sig_med_bg   = "cccccc";
$sig_good_bg  = "99ff99";
$sig_bad_bg   = "ff9999";

  
function mime_action_ximpsignature( $mime ) {
  global $default, $mbox, $sig_good_bg;
  $ret = "\n<table vspace=0 hspace=0 cellpadding=0 cellspacing=0 border=0><tr><td>$mime->icon Message Signature &nbsp &nbsp</td>";

  /* 
   * We need to fetch the contents to check for signature errors.
   */

  $mime->fetch_contents();

  $sig = new signature_rc;
  $sig->sig = $mime->contents;
  $sig->data = imap_fetchbody($mbox,$mime->index,1);

  signature_verify_syntax( &$sig );
  
  if( $sig->valid_syntax ) {
    $ret .= "<td bgcolor=$sig_good_bg width=200><center><a href=view.php3?mailbox=" . urlencode($mime->mailbox) . "&index=$mime->index&bodypart=$mime->partno&actionID=" . VIEW_ATTACH . ">Check Signature</a></center></td>";
  } else {
    $ret .= $sig->error_syntax;
  }

  return $ret."</tr></table>\n";
}

function mime_view_ximpsignature( $mime ) {
  global $mbox;
  $mime->fetch_contents();

  $sig = new signature_rc;
  $sig->sig = $mime->contents;
  $sig->data = imap_fetchbody($mbox,$mime->index,1);

  signature_verify_syntax( &$sig );
  signature_verify_pkcs7( &$sig );

  return signature_display( &$sig );
}

class cert {
  var $dn = "";
  var $depth = 0;
  var $valid = false;
 
  var $country = "";
  var $region = "";
  var $locality = "";
  var $organization = "";
  var $org_unit = "";
  var $common_name = "";
  var $email = "";
  var $other = "";

  var $error = 0;
  var $error_text = "";

  function parse_dn( $dn ) {
    $this->dn = $dn;
    $fields = split("/",$dn);
    for( $f=0; $f<@count($fields); $f++ ) {
      if( strlen($fields[$f]) == 0 ) continue;
      ereg('^([^=]+)=(.*)',$fields[$f],$field);
      switch( $field[1] ) {
	case "C":     $this->country = $field[2]; break;
	case "ST":    $this->region = $field[2]; break;
	case "L":     $this->locality = $field[2]; break;
	case "O":     $this->organization = $field[2]; break;
	case "OU":    $this->org_unit = $field[2]; break;
	case "CN":    $this->common_name = $field[2]; break;
	case "Email": $this->email = $field[2]; break;
        default:      $this->other = "$field[1]=$field[2]\n"; break;
      }
    }
  }

  function parse_return( $rc ) {
    $this->valid = false;
    switch( true ) {

      /* Valid cert */
      case ereg( "^verify return:1$*",$rc): 
	{
	  $this->valid = true;
	  $this->error_text = "valid";
	} break;

      /* Specific errors with custom error messages */
      /*
      case ereg( "^vlerify.*",$rc):
	{
	  $this->valid = false;
	  $this->error = 99;
	  $this->error_text = "FOO";
	} break;
      */
	
      /* All other errors... */
      default:
	{
	  $this->valid = false;
	  $error = split(":",$rc);
	  $code  = split("=",$error[1]);
	  switch( $error[0] ) {
	    case "verify error":
	      {
		$this->error = $code[1];
		$this->error_text = $error[2];
	      } break;
  	    default:
	      {
		$this->error = strlen($code[1])>0 ? $code[1] : "999";
		$this->error_text = strlen($error[2])>0 ? $error[2] : "unknown error";
	      } break;
	  }
	} break;
    }
  }
}

class signature_rc {
  var $error = "";
  var $error_syntax = "";
  var $error_certs = "";
  var $error_hash = "";
  var $sig = "";
  var $data = "";
  var $valid_certs = false;
  var $valid_syntax = false;
  var $valid_hash = false;
  var $certs = array();
  var $p7verify_output = array();
}

function signature_verify_syntax( $sig_rc ) {
  global $default, $sig_light_bg, $sig_med_bg, $sig_good_bg, $sig_bad_bg;
  
  /*
   *  Netscape returns any errors on the client side as error:<errorstring>, instead of the 
   * signature.  We check these and return explanatory text to the user.
   *
   */

  $a = split(":",$sig_rc->sig);
  $sig_rc->valid_syntax = false;

  if( $a[0]=="error" ) {
    $sig_rc->error_syntax .= "<td bgcolor=$sig_bad_bg width=400><img src=".$default->root_url."/graphics/mime_broken.gif border=0> <b>";

    switch( strtolower($a[1]) ) {
      case "internalerror":
	{
	  $sig_rc->error_syntax .= "
internalError</b><br>

This signatures is invalid.  Netscape returned an <b>Internal
Error</b> instead of an actual signature.  This is usually caused by
Netscape not being able to verify the signing cert.  You can check for
this problem by clicking on the <i>lock icon</i> on the Netscape
toolbar.  Select <i>Yours</i> from the left menu.  Highlight the cert
you used to sign with and click the <i>Verify</i> button on the right.

";
	} break;
      case "userCancel":
	{
	  $sig_rc->error_syntax .= "
userCancel</b><br>

This signatures is invalid.  Netscape returned a <b>User Cancel
Error</b> instead of an actual signature.  This is caused by the
sender clicking on the Cancel button instead of selecting a valid
certificate.

";
	} break;      
      case "noMatchingCert":
	{
	  $sig_rc->error_syntax .= "
noMatchingCert</b><br>

This signatures is invalid.  Netscape returned a <b>No Matching
Certificate Error</b> instead of an actual signature.  This is caused
by the sender not having a certificate that we recognize as valid.

";
	} break;      
    default:	
      $sig_rc->error_syntax .= $a[1];
    }
    $sig_rc->error_syntax .= "</b></td>";

    $sig_rc->valid_syntax = false;
    $sig_rc->valid_certs = false;

    return $sig_rc;
  }

  $sig_rc->valid_syntax = true;
  $sig_rc->error_syntax = "";
}

function signature_verify_pkcs7( $sig_rc ) {
  global $default, $sig_light_bg, $sig_med_bg, $sig_good_bg, $sig_bad_bg;

  if( !$sig_rc->valid_syntax ) { $sig_rc->valid = false; return $sig_rc; }

  if( isset($default->path_to_p7verify) && strlen($default->path_to_p7verify)>0 ) {
    /*
     *   See README.signatures in the main imp distribution.
     */
    
    /* Write out the contents and the signature */
    $sign_name = "/tmp/imp.sign.".date("Y-M-D_H:i:s")."__".md5($sig_rc->sig);
    $data_name = "/tmp/imp.data.".date("Y-M-D_H:i:s")."__".md5($sig_rc->sig);
    
    $sign_fh = fopen( $sign_name, "w" );
    $pkcs7_sig ="-----BEGIN PKCS7-----\n$sig_rc->sig\n-----END PKCS7-----\n";
    fwrite( $sign_fh, $pkcs7_sig );
    fclose( $sign_fh );
    
    $data_fh = fopen( $data_name, "w" );
    $raw_data = $sig_rc->data;
    fwrite( $data_fh, $raw_data );
    fclose( $data_fh );

    $pipe = popen( "$default->path_to_p7verify -d $data_name $sign_name 2>&1","r");
    $data = array();
    while( ($rc=fgets($pipe,8192)) )
      $data[]=$rc;
    pclose( $pipe );

    unlink( $sign_name );
    unlink( $data_name );

    $sig_rc->p7verify_output = $data;
    $sig_rc->certs = array();
    $sig_rc->valid_certs = true;

    $words = array();

    for($i=0; $i<@count($data); $i++) {

      switch( true ) {
	
	case ereg('^depth.*',$data[$i] ):  {
	  $words = explode(" ",$data[$i] );
	  
	  $cert = new cert;
	  $cert->parse_dn(ereg_replace("^depth=[0-9] +","",$data[$i]));
	  $cert->depth = ereg_replace('[^0-9]','',$words[0]);
	  
	  $next = $data[$i+1];
	  if( ereg('^verify.*',$next) ) {
	    $i++;
	    $cert->parse_return( $next );
	  }

	  $sig_rc->certs[] = $cert;

	  if( !$cert->valid ) {
	    $sig_rc->valid_certs = false;
	    $sig_rc->error_certs = $cert->error;
	  }
	  
	} break;
	
	case ereg('^done',$data[$i]): {
	  $sig_rc->valid_hash = true;
	} break;

	case ereg('.*signature failure.*',$data[$i]): {
	  $sig_rc->valid_hash = false;
	  $sig_rc->error_hash = "MD5 in signature doesn't match that of message.";
	} break;
	
      }
    }
  }
  return $sig_rc;
}

function signature_display( $sig_rc ) {
  global $default, $sig_light_bg, $sig_med_bg, $sig_good_bg, $sig_bad_bg;

  $ret  = "<table border=0 cellspacing=3 cellpadding=2 cols=3>\n";
  $ret .= "<caption><b> S i g n a t u r e &nbsp &nbsp I n f o r m a t i o n </b></caption>\n";

  if( !$sig_rc->valid_syntax ) {
    $ret .= "<tr><td bgcolor=$sig_med_bg> Syntax Error in Signature </td>$sig_rc->error_syntax</table>\n";
    return $ret;
  }

  $ret .= "<tr><th bgcolor=$sig_light_bg><b>Signature</b></th><td colspan=4 bgcolor=";
  if( !$sig_rc->valid_hash ) {
    $ret .= "$sig_bad_bg><b><i>INVALID:</b></i><br> $sig->error_hash </td></tr></table>\n";
  } else {
    $ret .= "$sig_good_bg><center><b>VALID</i></center></td></tr>\n";
  }

  $n = @count($sig_rc->certs);
  for($i=0;$i<$n;$i++) {
    $cert = $sig_rc->certs[$i];
    $ret .= "<tr><th bgcolor=$sig_light_bg>";
    switch( $cert->depth ) {
      
      case ($n-1): /* The highest cert is the client cert */
	$ret .= "Sender's Cert"; break;
      
      case ($n-2): /* The direct issuer cert */
	$ret .= "Issuer's Cert"; break;
      
      case 0: /* The root cert (if not one of the above) */
	$ret .= "Root CA Cert"; break;
      
    default: /* All the intermediate signers */
      $ret .= "Signer #$i"; break;
    }
    $ret .= "
</td><td bgcolor=$sig_med_bg><table cellspacing=3 cellpadding=2>\n
 <tr><td bgcolor=$sig_light_bg>Country             </td><td>$cert->country           </td></td>
 <tr><td bgcolor=$sig_light_bg>Region              </td><td>$cert->region            </td></td>
 <tr><td bgcolor=$sig_light_bg>Locality            </td><td>$cert->locality          </td></td>
 <tr><td bgcolor=$sig_light_bg>Organization        </td><td>$cert->organization      </td></td>
 <tr><td bgcolor=$sig_light_bg>Organizational Unit </td><td>$cert->org_unit          </td></td>
 <tr><td bgcolor=$sig_light_bg>Common Name         </td><td>$cert->common_name       </td></td>
 <tr><td bgcolor=$sig_light_bg>Email               </td><td>$cert->email             </td></td>
";
      if( strlen($cert->other) > 0 ) $ret .= "
 <tr><td bgcolor=$sig_light_bg>Other               </td><td>$cert->other             </td></td>
";
      $ret .= "</tr></table></td>
<td colspan=2 bgcolor=";

    if( $cert->valid )
      $ret .= "$sig_good_bg><center><b>VALID</b></center></td></tr>";
    else
      $ret .= "$sig_bad_bg><center><b><i>INVALID</i></center><br><br> Error #$cert->error: </b><br> $cert->error_text</td></tr>";
    $ret .= "
  </td></tr>
";     
  }
  $ret .= "</table>";
  return $ret;
}


?>
