<?php

/*
   
   File: lib/imp.lib.php3
   $Author: paudley $
   $Revision: 1.21 $
   $Date: 1998/10/01 18:20:16 $
   
   IMP: Copyright 1998 Patrick C. Audley paudley@blackcat.ca
   
   This code is under the GNU Public License
   See the file COPYING in this directory
   
*/

#include( "./lib/debug/mime_debug.php3" );  /* Include mime debugging code, use with decompose() */

require ('./lib/signatures_lib.php3');   /* Verification of S/MIME and IMP sigs */

$mime_types = array (
		     1 => "text", "text" => 1,
		     2 => "mail", "mail" => 2,
		     3 => "application", "application" => 3,
		     5 => "image", "image" => 5
		     );

$mime_encoding = array (
			0 => "7bit", "7bit" => 0,
			1 => "8bit", "8bit" => 1,
			2 => "binary", "binary" => 2,
			3 => "base64", "base64" => 3,
			4 => "quoted-printable", "quoted-printable" => 4,
			5 => "unknown", "unknown" => 5
			);

$mime_actions = array (
		       "application/x-gzip" => array("action" => "default",
						     "view" => false,
						     "download" => true,
						     "icon" => "mime_compressed.gif" ),
		       "application/x-imp-signature" => array("action" => "function",
							      "function" => "mime_action_ximpsignature",
							      "view" => false,
							      "view_function" => "mime_view_ximpsignature",
							      "download" => false,
							      "icon" => "mime_imp_signature.gif" ),
		       "application/" => array("action" => "default",
					       "view" => false,
					       "download" => true,
					       "icon" => "mime_text.gif" ),
		       "image/" => array("action" => "default",
					 "view" => true,
					 "download" => true,
					 "icon" => "mime_image.gif" ),
		       "mail/" => array("action" => "default",
					"view" => true,
					"download" => true,
					"icon" => "mime_mail.gif" ),
		       "text/html" => array("action" => "default",
					    "view" => true,
					    "download" => true,
					    "icon" => "mime_html.gif" ),
		       "text/plain" => array("action" => "default",
					     "view" => true,
					     "download" => true,
					     "icon" => "mime_text.gif" ),
		       "/" => array("action" => "default",
				    "view" => true,
				    "download" => true,
				    "icon" => "mime_text.gif" )
		       );

class mime_part_data {
  var $icon;
  var $text;
  var $type;
  var $type_text;
  var $size;
  var $name;
  var $ksize;
  var $encoding;
  var $encoding_text;
  var $subtype;
  var $charset;  
  var $desc;
  var $action = false;
  var $contents = false;
  var $mailbox;
  var $index;
  var $partno;
  
  function set_imap_data( $mailbox, $index, $partno ) {
    $this->mailbox = $mailbox;
    $this->index = $index;
    $this->partno = $partno;
  }
  
  function parse( $part ) {
    global $mime_types, $mime_encoding;

#    decompose( $part ); /* Use with mime_debug */

    isset($part->type)        ? $this->type = $part->type        : $this->type = 1;
    isset($part->subtype)     ? $this->subtype = $part->subtype  : $this->subtype = "plain";
    isset($part->bytes)       ? $this->size = $part->bytes       : $this->size = 0;
    isset($part->description) ? $this->desc = $part->description : $this->desc = "";
    
    $this->size <= 0          ? $this->ksize = 0                : $this->ksize = sprintf("%0.2f",$this->size / 1024);

    $this->subtype = strtolower($this->subtype);
    $this->charset="";
    $this->name="";

    if( isset($part->parameters) && is_array($part->parameters) )
      for( $i=0; $i<@count($part->parameters); $i++ ) {
	$parm = $part->parameters[$i];
	switch( strtolower($parm->attribute) ) {
	  case "charset":
	    $this->charset = $parm->value; break;
	  case "name":
	    $this->name = $parm->value; break;
	}
      }

    if( isset($part->dparameters) && is_array($part->dparameters) )
      for( $i=0; $i<@count($part->dparameters); $i++ ) {
	$parm = $part->dparameters[$i];
	switch( strtolower($parm->attribute) ) {
	  case "filename":
            /* Disposition "filename" attribute overrides general "name" attribute */
	    $this->name = $parm->value; break;
	}
      }

    if( isset($part->encoding) )
      $this->encoding = $part->encoding;
    else
      $this->encoding = 0;

    $this->encoding_text = $mime_encoding[ $this->encoding ];
    $this->type_text = $mime_types[$this->type];
    $this->text = " <i>$this->type_text/$this->subtype</i> ";
    if( $this->desc != "" ) { $this->text .= "\"$this->desc\" "; }

    $this->get_action();
  }
  
  function get_action() {
    global $mime_actions;
    if( !$this->action ) {
      
      if( isset( $mime_actions["$this->type_text/$this->subtype"] ) ) { 
	$this->action = $mime_actions["$this->type_text/$this->subtype"]; }
      elseif( isset( $mime_actions["$this->type_text/"] ) ) 
	$this->action = $mime_actions["$this->type_text/"];
      elseif( isset( $mime_actions["/"] ) ) 
	$this->action = $mime_actions["/"];
      else $this->action = array("action" => "unknown","icon" => "mime_unknown.gif");
      
      $this->icon = $this->img_tag();
    }
  }

  function fetch_contents() {
    global $mbox;
    if( !$this->contents ) {
      $this->contents = imap_fetchbody ($mbox, $this->index, $this->partno+1);
    }
  }

  function set_type( $type ) {
    global $mime_types;
    if( is_string( $type ) ) {
      $this->type_text = $type;
      $this->type = $mime_types[$type];
    } else {
      $this->type = $type;
      $this->type_text = $mime_types[$type];
    }
  }
  function set_subtype( $subtype ) { $this->subtype = strtolower($subtype); }
  function set_type_full( $tag ) {
    global $mime_types;
    $a = split("/",$tag);
    $this->type_text = $a[0];
    $this->type = $mime_types[$this->type_text];
    $this->subtype = $a[1];
    $this->get_action();
  }
    
  function img_tag() {
    global $default;
    $icon = $this->action["icon"];
    $ret = "";
    if( $icon != "" ) 
      $ret = "<img src=".$default->root_url."/graphics/$icon border=0 alt=\"".$this->type_text."/".$this->subtype."\">";
    
    /* Comment in the following lines to see the type/subtype for assigning new icons */ 
#          $ret .= "
#      <font color=green>$this->type_text/$this->subtype</font>
#      <font color=blue>".$this->action["icon"]."</font>
#      <font color=red>".$this->action["action"]."</font>
#      <font color=yellow>".$this->name."</font>
#      <br>\n";
    /* End Debugging Lines */
	
    return $ret;
  }
  
  function display() {
    global $default;
    $ret = "\n";
    switch( $this->action["action"] ) {

      case "function":
	{
	  eval( "\$ret=".$this->action["function"].'($this);' );
	} break;

      case "default":
      default:
	{
	  if( $this->action["view"] )
	    $ret .= "<a href=view.php3?mailbox=" . urlencode($this->mailbox) . "&index=$this->index&bodypart=$this->partno&actionID=" . VIEW_ATTACH . ">$this->icon $this->name</a>";
	  else
	    $ret .= "$this->icon $this->name";
	  
	  $ret .= " <b>$this->ksize kB</b> ";
	  $ret .= $this->encoding_text." ";
	  if( $this->action["download"] ) 
	    $ret .= "<a href=$default->root_url" . "/view.php3?mailbox=" . urlencode($this->mailbox) . "&index=$this->index&bodypart=$this->partno&actionID=" . DOWNLOAD_ATTACH . ">(download)</a>";
	  $ret .= "<br>\n";
	} break;

    }
    return $ret;
  }
}

?>
