<?php

/*
   
   File : lib/horde.lib.php3
   $Author: zerodiv $
   $Revision: 1.21 $
   $Date: 1998/10/07 16:42:32 $
   
   IMP : Copyright 1998 Charles J. Hagenbuch chuck@osmos.ml.org
   
   This code is under the GNU Public License
   See the file COPYING in this directory

File Purpose:
This file contains the base classes and their descendents for 
the interoperability of the horde. 

*/

/* ------------------------------------------------------------ */

/* Experimental / Votile classes :
DO NOT DEPEND ON THESE NOT CHANGING
*/

/*
Defines for types of imap servers.
*/
/* MS_EXCHANGE_IMAP : Ms Exchange imap service. */
define( "MS_EXCHANGE_IMAP", 		1001 );
/* CYRUS_IMAP       : The cyrus imap server. */
define( "CYRUS_IMAP", 				2001 );
/* UNKNOWN_IMAP     : Otherwise known as RFC 822. */
define( "UKNOWN_IMAP",				9999 );

class HordeUser {
   var $user_id;
   var $user_name;
   var $password;
   var $deny_login;

   Function HordeUser() {
      $this->user_id             = -1;
      $this->user_name           = '';
      $this->password            = '';
      $this->deny_login          = true;
      }
   }

class HordeGrant {

	var $read;
	var $write;
	var $modify;
	var $with_grant_option;

	Function HordeGrant() {
		$this->read 					= false;
		$this->write 					= false;
		$this->modify					= false;
		$this->public					= false;
		$this->with_grant_option	= false;
		}
	}

class HordeImapServer {
   var $horde_user_id;
   var $user_name;
   var $password;
   var $server;
   var $server_type_id;
   Function HordeImapServer() {
      $this->horde_user_id        = -1;
      $this->user_name            = '';
      $this->password             = '';
      $this->server               = '';
      $this->server_type_id       = UNKNOWN_IMAP;
      }
   }

class HordeAdminPrivlage {
   var $priv_id;
   var $name;
   var $state_tag;
   var $icon_url;
   var $alt_text;
   var $description;
   Function HordeAdminPrivlage() {
      $this->priv_id             = -1;
      $this->name                = '';
      $this->state_tag           = '';
      $this->icon_url            = '';
      $this->alt_text            = '';
      $this->description         = '';
      }
   }

/* ------------------------------------------------------------ */



/* ------------------------------------------------------------ */
/*
BASE Classes :

Classes that are common to all or some of the horde.

*/
class HtmlDocument {
   
   /* Html Configuration Elements */
   var $bg_file;                    /* url to a background image */
   var $bg_color;                   /* background color */
   var $text_color;                 /* text color */
   var $link_color;                 /* link color */
   var $vlink_color;                /* vlink color */
   var $alink_color;                /* alink color */
   
   function generate_body() {
      echo( '<body' );
      if ( $this->bg_file != '')    { echo( ' background="'     . $this->bg_file . '"'  ); }
      if ( $this->bg_color )        { echo( ' bgcolor="'        . $this->bg_color . '"' ); }
      if ( $this->text_color )      { echo( ' text="'           . $this->text_color . '"' ); }
      if ( $this->link_color )      { echo( ' link="'           . $this->link_color . '"' ); }
      if ( $this->vlink_color )     { echo( ' vlink="'          . $this->vlink_color . '"' ); }
      if ( $this->alink_color )     { echo( ' alink="'          . $this->alink_color . '"' ); }
      echo( ">\n" );
   } /* END function generate_body() */
   
}

class HordeConfigForm {
   var $full_colspan;

   Function gen_single_item( $item_content, $align_left = true, $fullspan = false, $text_color ) {
   global $default;
   if ( $text_color == undef ) { $default->text_on_light; }
   $td = '<td';
   $align = '';
   if ( $align_left == true ) {
   $align = ' align="left"';
   }
   if ( $align_left == false ) {
   $align = ' align="right"';
   }
   $span = '';
   if ( $fullspan == true ) {
   $span = ' colspan="' . $this->full_colspan . '"';
   }
   $td .= $align . $span . '>';
   echo( $td );
   echo( '<font face="Arial,Helvetica" color="' . $text_color . '">' );
   echo( $item_content );
   echo( '</font>' );
   echo( '</td>' );
   }
   /* gen_textbox --- compat --- */
   Function gen_textbox( $english_name, $item_name, $item_value, $desc, $size ) {
      $this->gen_text_option( $english_name, $item_name, $size, $item_value, $desc );
   }
      
   Function gen_text_option(
      $item_english_name,  $item_name,
      $item_size = 15,          $item_value = '', 
      $item_desc
      ) {
   global $default;
   echo( '<tr bgcolor="' . $default->light_bg . '">' );
   $this->gen_single_item( '<b>' . $item_english_name . '</b>' );
   $this->gen_single_item(
      '<input type="text" name="' . $item_name . 
      '" size="' . $item_size . '" value="' . $item_value . '">',
      true );
   echo( '</tr>' );
   echo( '<tr bgcolor="' . $default->light_bg . '">' );
   $this->gen_single_item( '<ul><li><b>' . $item_desc . '</b></ul>' );
   echo( '</tr>' );
   echo( "\n" );
   }

   Function gen_doc_config( $tag, $base_obj ) {
      $this->gen_textbox(
      'Background Color :',
      'html_' . $tag . '_bg_color',
      $base_obj->bg_color,
      'The color for the background.',
      15
   );
      $this->gen_textbox(
      'Background File :',
      'html_' . $tag . '_bg_file',
      $base_obj->bg_file,
      'The image file for the background.',
      50
   );
      $this->gen_textbox(
      'Text color :',
      'html_' . $tag . '_text_color',
      $base_obj->text_color,
      'The text color.',
      15
   );
      $this->gen_textbox(
      'Link color :',
      'html_' . $tag . '_link_color',
      $base_obj->link_color,
      'The hyperlink color',
      15
   );
      $this->gen_textbox(
      'Visted link color :',
      'html_' . $tag . '_vlink_color',
      $base_obj->vlink_color,
      'The visted hyperlink color.',
      15
   );
      $this->gen_textbox(
      'Active link color :',
      'html_' . $tag . '_alink_color',
      $base_obj->alink_color,
      'Active hyperlink color.',
      15
   );

   }

   Function gen_title_bar( $title_text, $colspan ) {

   global $default;

   echo( '<tr bgcolor="' . $default->dark_bg . '">' );
   $this->gen_single_item(
      '<font size="+2">' . $title_text . '</font>', undef, true,
      $default->text_on_dark );
   echo( '</tr>' );
   echo( "\n" );

   }

Function gen_true_false(
      $human_text, $options_name,
      $option_value, $description ) {
   $options_array    = Array( "True", "False" );
   $options_values   = Array( true, false );

   $this->gen_selectbox(
      $human_text,
      $options_name,
      $options_array,
      $options_values,
      $option_value,
      $description
   );

   }
Function gen_selectbox(
   $human_text, $options_name,
   $options_array, $options_values,
   $option_value, $description )
   {
   global $default;
   echo( '<TR bgcolor="' . $default->light_bg . '">' );
   $this->gen_single_item( '<B>' . $human_text . '</B>' );
   
   /* Construct The Select Item */
   $select_item = '';
   $select_item .= '<SELECT NAME="' . $options_name . '">';
   
   for( $i = 0; $i < count( $options_array ); $i++ )
      {
      if ( $options_values[ $i ] == $option_value )
         {
         $select_item .=
         '<OPTION VALUE="' . $options_values[ $i ] . '" SELECTED>' . $options_array[ $i ];
         } else {
         $select_item .=
         '<OPTION VALUE="' . $options_values[ $i ] . '">' . $options_array[ $i ];
         }
    }
   $select_item .= '</SELECT>';
   $this->gen_single_item( $select_item, true );
   echo( '</TR>' );
   echo( '<TR bgcolor="' . $default->light_bg . '">' );
   $this->gen_single_item( '<ul><li><b>' . $description . '</b></ul>' );
   echo( '</TR>' );
   }

   Function gen_submit_reset( $submit_text = undef, $reset_text = undef) {
   global $default;
   echo( '<tr bgcolor="' . $default->light_bg . '">' );
   $this->gen_single_item( '<center><input type="submit"></center>', undef );
   for( $i = 2; $i < $this->full_colspan; $i++) {
         echo( '<td></td>' );
      }
   $this->gen_single_item( '<center><input type="reset"></center>', undef );
   echo( '</tr>' );
   echo( "\n" );
   }

   Function gen_action_tag( $action_tag ) {
   echo( '<input type="hidden" name="action" value="' . $action_tag . '">' );
   }

   Function gen_sect_title( $title_text ) {
   global $default;
   echo( '<tr bgcolor="' . $default->dark_bg . '">' );
   $this->gen_single_item(
      '<B>' . $title_text . '</B>', undef, true, $default->text_on_dark
      );
   echo( '</tr>' );
   }

   Function gen_sect_subtitle( $title_text ) {
   global $default;
   echo( '<tr bgcolor="' . $default->item_bg . '">' );
   $this->gen_single_item( '<b>' . $title_text . '</b>', undef, true, $default->text_light_dark );
   echo( '</tr>' . "\n" );
   }

   Function gen_attr_value_title( ) {
   global $default;
   echo( '<tr bgcolor="' . $default->nav_bg . '">' );
   $this->gen_single_item( '<center><b>[- Attribute -]</b></center>' );
   $this->gen_single_item( '<center><b>[- Value -]</b></center>' );
   echo( '</tr>' );
   echo( "\n" );
   }
}


/* -- END Base Classes -- */
/* ------------------------------------------------------------ */

/* ------------------------------------------------------------ */
/*

IMP Objects :

The configuration objects / objects that the IMP module shares to
the horde.

*/
class ImpDefaults {
  
  /* Html Configuration */
  
  /* Colors organized by general element. Hopefully, one should be able
     to set these, and have IMP follow them to create a whole new color scheme */
  
  var $dark_bg;
  var $light_bg;
  var $text_bg;
  var $item_bg;
  var $new_item_bg;
  var $nav_bg;
  
  /* impmain frame colors */
  var $body;                            /* HtmlDocument : configures the impmain frame colors */
  
  /* impmenu (sidebar) frame colors */
  var $sidebar;                         /* HtmlDocument : configures the impmenu frame colors */
  
  /* URL Configuraton */
  var $graphics_url;                    /* imp specfic graphics */
  var $root_url;                        /* imp base url */
  
  /* Files Configuration */
  var $include_dir;                     /* the directory all of the includes live in */
  
  /* IMAP Configuration */
  var $server;                    /* default IMAP server to connect to */
  var $folders;                        /* default directory to look in for mail folders     */
  
  var $secure;               /* Use SSL for cookies if it is a secure connection  */

  /* Cyrus Configuration */
  var $cyrus;
  
  /* Imp Server Configuration */
  var $user_change_server;          /* set false to force use of the default server      */
  var $user_change_folder;          /* set false to force use of the default folder dir  */
  var $user_use_filemgr;            /* Ftp file management system */
  var $user_use_addressbook;        /* Address book on / off flag */
 
  /* Imp Client Configuration */
  var $max_messages_page;     /* max number of messages to display in one page in mailbox.php3  */
  
  /* Imp Debugging Configuration */
  var $error_level = 1;                 /* level of error_reporting()  */

  /* Local Server Authentication */
  var $local_host_name;

  /* Imp Folder Configuration */
  /*    - Controls the file management module. */
  var $user_home_dirs;

  /* SSL Certificate Configuration */
  var $ssl;

  /* Logging Configuration */
  var $log;

  /* MIME attachment status in summaries? */
  var $fetch_mime_info;

  /* Allow people to see the naked message? */
  var $view_message_source;

  /* The string to prepend to wrapped lines. */
  var $wrap_string;

  /* Constructor */
  Function ImpDefaults() {
    $this->body     = new HtmlDocument;
    $this->sidebar  = new HtmlDocument;
    $this->ssl      = new SSLDefaults;
    $this->log      = new LogDefaults;
    $this->cyrus    = new CyrusDefaults;
    
    $this->wrap_string       = "+";
    $this->fetch_mime_info   = true;
    $this->view_message_source = true;
    $this->max_messages_page = 50;
    $this->root_url          = '';
    $this->graphics_url      = $this->root_url . '/graphics';
    $this->user_home_dirs    = Array();
    
  }
  
}

/* USER Defaults */

class ImpUserDefaults {
  /* Html Configuration */
  var $body;                       /* HtmlDocument : body frame configuration */
  
  /* Imp Client Configuration */
  var $max_messages_page;          /* max number of messages to display in one page in mailbox.php3  */
  
  Function ImpUserDefaults() {
     $this->body = new HtmlDocument;
  }
  
}

class ImpUserSignature {
   var $horde_user_id;
   var $signature;
   Function ImpUserSignature() {
      $this->horde_user_id          = -1;
      $this->signature              = '';
      }
   }

class ImpUser {
   var $user;
   var $signature;
   
   Function ImpUser() {
      $this->user          = new HordeUser;
      $this->signature     = new ImpUserSignature;
      }
   }

class SSLDefaults {
  
  /* SSL Certificate Configuration */
  
  /* set to true to enable ssl cert checking */

  var $check_cert;
  var $enabled;

  /* If this is set to true, only allow access to people who present
     a client cert that is issued by someone in the list of issuers. */

  var $client_auth_required;

  /*  A array of DNs from issuers that we recognize.
  
     Ex:
	$issuers = array(
          "/C=CA/ST=BC/L=Vancouver/O=GT Group Telecom Inc./OU=Ecommerce/CN=admin valkyrie 01/Email=webmaster@blackcat.ca"=>true
	);
  
    As these are generally tricky to get from netscape, if you set 
     $snoop_dn = true; both DNs are displayed.                       */

  var $issuers;
  var $snoop_dn;

  Function SSLDefaults() {
    $this->client_auth_required = false;
    $this->enabled = false;
    $this->check_cert = false;
    $this->snoop_dn = false;    
  }
}

class LogDefaults {

  /* Logging Configuration */
  
  var $enabled;

  Function LogDefaults() {
    $this->enabled = false;
  }
}

class CyrusDefaults {

  /* Cyrus imap server configuration. */

  var $enabled;

  /* !!!!!!  This setting is only of value to people who:
   *   a) use cyrus
   *   b) ONLY use ssl certs for auth
   * & c) have enough resources to support all the accounts it might create.
   *
   *    Setting this to true will cause an account to be created for each user
   *  who logs in with a valid cert.  This useful if you issue certs and want to 
   *  offer webmail only to people you issue certs to (ex: company intranet).
   */
  var $auto_create;

  /*  These need if auto_create is set.  They are the username and password of
   * an imap account that has admin priviledges.
   */
  var $admin_user;
  var $admin_pass;

  Function CyrusDefaults() {
    $this->enabled = false;
    $this->auto_create = false;
    $this->admin_user = "";
    $this->admin_pass = "";
  }

}

/* -- END IMP Objects -- */
/* ------------------------------------------------------------ */
?>
