<?php

/*
  
  File: compose.php3
  $Author: chuck $
  $Revision: 1.49 $
  $Date: 1998/10/09 03:01:39 $
  
  IMP: Copyright 1998 Charles J. Hagenbuch <chuck@osmos.ml.org>
  
  This code is under the GNU Public License
  See the file COPYING in this directory
  
*/
  
  /* obtain the -0400 or whatever it is for your offset for the date header */
  function gm_offset() {
    $offset = ((date("H") - gmdate("H")));
    if ($offset >= 0) { return sprintf("+%02d", $offset) . "00"; }
    else { return sprintf("-%02d", -$offset) . "00"; }
  }

 /* function that interfaces to sendmail, so from address and all headers
  * are set correctly
  */
  
  function mailfrom($user, $server, $to, $from, $subject, $hdrs, $message) {
    global $default;
    
    $mail = popen("$default->path_to_sendmail -t -f '$user@$server'", 'w');
    
    $result  = fputs($mail, "To: $to\n");
    $result += fputs($mail, "From: $from\n");
    $result += fputs($mail, $hdrs);
    $result += fputs($mail, "Subject: $subject\n\n");
    $result += fputs($mail, $message);
    
    pclose($mail);
    
    if ($result > 0) { return 1; }
    else { return 0; }
  }
  
  
  require ('./lib/imp.lib.php3');          /* IMPlib is the IMP function library  */
  require ('./config/defaults.php3');      /* Defaults configuration file         */
  if ($default->ssl->enabled) { include( './lib/ssl_lib.php3' ); }
  require ('./lib/mime_lib.php3');         /* Mime lib for composing mime messages*/
  require ('./lib/signatures_lib.php3');   /* Verification of S/MIME and IMP sigs */
  require ($default->db_lib);              /* DBlib is the db backend library     */
  error_reporting($default->error_level);  /* set error level from imp.lib.php3   */
  
  /* send headers to ensure that the page will reload correctly. */
  header( 'Cache-Control: no-cache, must-revalidate' );
  header( 'Pragma: no-cache' );
  header( 'Expires: 0' );
  
  $user    = getuser();
  $pass    = getpass();
  $server  = getsrvr();
  $port    = getport();
  $folders = getfldr();
  if (!isset($mailbox)) { $mailbox = 'INBOX'; }
  $get_sig = true;
  
  /* login */
  $mbox = validate_login($server, $port, $mailbox, $user, $pass);
  
  /* array to translate string actions into the appropriate integer ID */
  $actions[ 'Send Message' ]     = SEND_MESSAGE;
  $actions[ 'Postpone Message' ] = POSTPONE_MESSAGE;
  
  /* Run through action handlers */
  
  if (isset($actionID)) {
    /* translate non-int values into the correct int */
    if (strcspn($actionID, '0123456789')) { $actionID = $actions[$actionID]; }
    
    switch ($actionID) {
      case NO_ACTION:
        status('Message Composition');
        $ACTION_TEXT = 'Message Composition';
        break;
      
      case REPLY:
	if ($mailbox && $index && $bodypart) {
	  $h = imap_header($mbox, $index);
	  if ($h->reply_toaddress) { $to = chop(htmlentities($h->reply_toaddress)); }
	  else { $to = chop(htmlentities($h->fromaddress )); }
	  
	  $msg  = 'Quoting ' . chop(htmlentities($h->fromaddress)) . ":\n\n&gt; ";
	  $msg .= htmlentities(wrap_message(imap_fetchbody($mbox, $index, $bodypart), 75, "\n> "));
	  $msg .= "\n";
	  
	  if (!eregi("^re:", $h->subject)) { $subject = 'Re: ' . chop(htmlentities($h->subject)); }
	  else { $subject = chop(htmlentities($h->subject)); }
	  
	  $ACTION_TEXT = 'Reply: ' . chop( htmlentities( $h->subject ) );
	}
	break;
      
      case REPLY_ALL:
        if ($mailbox && $index && $bodypart) {
	  $h = imap_header($mbox, $index);
	  if ($h->reply_toaddress) { $reply = chop(htmlentities($h->reply_toaddress)); }
	  else { $reply = chop(htmlentities($h->fromaddress )); }
	  
	  /* build up the reply to all addresses */
	  if ($reply != chop(htmlentities($h->fromaddress ))) { $to = $reply . ',' . chop(htmlentities($h->fromaddress )); }
	  else { $to = $reply; }
	  if ( $reply != chop(htmlentities($h->toaddress )) ) { $to .= "," . chop(htmlentities($h->toaddress )); }
	  if (isset($h->ccaddress)) { $to .= ',' . chop(htmlentities($h->ccaddress )); }
	  
	  $msg  = 'Quoting ' . chop(htmlentities($h->fromaddress)) . ":\n\n&gt; ";
	  $msg .= htmlentities(wrap_message(imap_fetchbody($mbox, $index, $bodypart), 75, "\n> "));
	  $msg .= "\n";
	  
	  if (!eregi("^re:", $h->subject)) { $subject = 'Re: ' . chop(htmlentities($h->subject)); }
	  else { $subject = chop(htmlentities($h->subject)); }
	  
	  $ACTION_TEXT = 'Reply to all: ' . chop( htmlentities( $h->subject ) );
	  
	}
	break;
      
      case FORWARD:
        if ($mailbox && $index && $bodypart) {
	  $h = imap_header($mbox, $index);
	  if ($h->reply_toaddress) { $from = chop(htmlentities($h->reply_toaddress)); }
	  else { $from = chop(htmlentities($h->fromaddress )); }
	  
	  $msg  = "\n----- Forwarded message from $from -----\n";
	  
	  if ($h->date) { $msg .= 'Date: ' . chop(htmlentities($h->date)) . "\n"; }
	  if ($h->fromaddress) { $msg .= 'From: ' . chop(htmlentities($h->fromaddress)) . "\n"; }
	  if ($h->reply_toaddress) { $msg .= 'Reply-To: ' . chop(htmlentities($h->reply_toaddress)) . "\n"; }
	  if ($h->subject) { $msg .= 'Subject: ' . chop(htmlentities($h->subject)) . "\n"; }
	  if ($h->toaddress) { $msg .= 'To: ' . chop(htmlentities($h->toaddress)) . "\n"; }
	  $msg .= "\n";
	  $msg .= htmlentities(wrap_message(imap_fetchbody($mbox, $index, $bodypart)));
	  $msg .= "\n----- End forwarded message -----\n";
	  
	  $subject = 'Fwd: ' . chop(htmlentities($h->subject));
	  $ACTION_TEXT = 'Forward: ' . chop( htmlentities( $h->subject ) );
	}
	break;

      case SEND_MESSAGE:

        if ($to && $message) {

	  if( $deliver_signed == "yes" ) {

	    $sig = new signature_rc;
	    $sig->sig = $signature;
	    $sig->data = $message;

	    signature_verify_syntax( &$sig );
	    signature_verify_pkcs7( &$sig );
	    
	    echo signature_display( &$sig );

	    /* Check the check syntax and (if they have p7verify) the validity */
	    $valid = true;
	    if( !$sig->valid_syntax )
	      $valid = false;
	    if( $valid
		&& !isset($default->path_to_p7verify)
		&& strlen($default->path_to_p7verify)
		&& ( !$sig->valid_certs || !$sig->valid_hash ) 
	      )
	      $valid = false;

	    if( !$valid ) {
	      echo "<h2><font color=red>Signature validation Failed. </font> Message <u>NOT</u> Sent!<h2>";
	      
	      $get_sig = false;
	      $msg = $message;
	      if ($file_upload_size > 0) {
		unlink($file_upload);
		/* Delete the attachment the user tried to send. */
	      }
	      echo "&nbsp &nbsp</td></tr></table>\n";
	      $ACTION_TEXT = '';
	      break;
	    }
	  }
  	  
	  /* somehow need to verify email addresses */
	  
	  // move these checks into javascript expand function
	  if ( !eregi('@', $to) ) { $to .= "@$server"; }
	  if ( (strlen($cc) > 0) && !eregi('@', $cc) ) { $cc .= "@$server"; }
	  
	  $mime = new mime_message;
	  $mime->init( $message.$signature );
	  
	  $text_part = new mime_part;
	  $text_part->contents = wrap_message($message, 80, "\n");
	  $mime->add_begin_part( $text_part );
	  
	  if( $deliver_signed == "yes" ) {
	    /* Added the mime part for the signature */
	      if( !empty($signature) ) {
		$sig_part = new mime_part;
		$sig_part->type = "APPLICATION";
		$sig_part->subtype = "X-IMP-SIGNATURE";
		$sig_part->transfer_encoding = "base64";
		$sig_part->description = "IMP/Netscape Object Signature for message body";
		$sig_part->contents = $signature;
		$mime->add_middle_part( $sig_part );
	      }
	  }
	  
	  if ($file_upload_size > 0) {
	    $fd = fopen( $file_upload, "r" );
	    $contents = fread( $fd, $file_upload_size);
	    fclose( $fd ); 
	    unlink($file_upload);
	    
	    $file_part = new mime_part;
	    $file_part->parse_full_type( $file_upload_type );
	    $file_part->transfer_encoding = "base64";
	    $file_part->name = $file_upload_name;
	    $file_part->contents = $file_upload_size < 100000 ? 
	      fill_paragraphs(base64_encode($contents), 80, "\n", '')
		: base64_encode($contents);
	    $mime->add_end_part( $file_part );
	  }
	    
	  $msg = $mime->generate();
	  
	  if (empty($from) || !$from || !$default->user_change_from) { $from = "$user@$server"; }
	  
	  $hdrs  = "Errors-To: $from\n";
	  $hdrs .= "Reply-To: $from\n";
	  if ($cc != '') { $hdrs .= "Cc: $cc\n"; }
	  $hdrs .= $mime->header();
	  
	  $hdrs .= 'X-Mailer: IMP/PHP3 Imap webMail Program ' . IMP_VERSION;
	  $hdrs .= "\n";
	  
	  if ( mailfrom($user, $server, $to, $from, $subject, $hdrs, $msg) ) {
	    status('Message sent successfully.');
	    
	    $fcc  = 'Date: ' . date("D, d M H:i:s Y ") . gm_offset() . "\n";
	    $fcc .= 'To: ' . $to . "\n";
	    $fcc .= "From: $user@$server\n";
	    $fcc .= 'Subject: ' . $subject . "\n";
	    $fcc .= $hdrs;
	    $fcc .= "\n";
	    $fcc .= $msg;

	    $preamble = $folders.$default->personal_folders;

            imap_createmailbox($mbox, "{$server:$port}$preamble"."sent-mail");
	    $fcc = ereg_replace("\n","\r\n",$fcc);
	    if ( !(imap_append($mbox, "{$server:$port}$preamble"."sent-mail", $fcc)) ) {
	      status('Message send successfully, ERROR: not saved to sent-mail');
	    }
	    
	    if( $deliver_signed == "yes" ) 
	      log_event( $user, $to, SENT_SIGNED, "Subject: $subject", md5($msg) );
	    else
	      log_event( $user, $to, SENT, "Subject: $subject", md5($msg) );

	    echo "<script language=javascript>
	            window.location=\"mailbox.php3?mailbox=$mailbox\";
		  </script>";
	    exit;
	    
	  }
	  
	  unset($to);
	  unset($cc);
	  unset($subject);
	  unset($message);
	  unset($msg);
	  
	} else {
	  status('One or more required fields was left empty.', 'red');
	  $get_sig = false;
	  $msg = $message;
	  if ($file_upload_size > 0) {
	    unlink($file_upload);
	    /* Delete the attachment the user tried to send. */
	  }
	}
      
        $ACTION_TEXT = '';
        break;
          
      case POSTPONE_MESSAGE:
        $hdrs  = "Errors-To: $user@$server\n";
	if ($to != '') { $hdrs .= "To: $to\n"; }
	if ($cc != '') { $hdrs .= "Cc: $cc\n"; }
	if ($subject != '') { $hdrs .= "Subject: $subject\n"; }
	$hdrs .= 'X-Mailer: IMP/PHP3 Imap webMail Program ' . IMP_VERSION;
	$hdrs .= "\n\n";
	
	$msg = $hdrs . $message;
	
        $preamble = $folders.$default->personal_folders;
	
        $msg = ereg_replace("\n","\r\n",$msg);
	imap_createmailbox($mbox, "{$server:$port}$preamble"."postponed-msgs");
	if ( !(imap_append($mbox, "{$server:$port}$preamble"."postponed-msgs", $msg)) ) {
          status('Error: Message Postponement failed', 'red');
	  $get_sig = false;
	}
	else {
	  status('Message Postponed');
	  unset($to);
	  unset($cc);
	  unset($subject);
	  unset($message);
	  unset($msg);
	}
        
        $ACTION_TEXT = '';
	break;
      
      default:
        $ACTION_TEXT = 'Compose a message';
	break;
    
    }
  } else { $ACTION_TEXT = 'Compose a message'; }
  if (!isset($status_sent)) { status('Message Composition'); }
  
  
  $title = 'Message Composition';
  $no_table_frame = false;
  $sidebar = false;
  require("$default->include_dir/generic-header.inc");
  
  if (!isset($msg))     { $msg = ''; }
  if (!isset($from))    { $from = ''; }
  if (!isset($to))      { $to = ''; }
  if (!isset($cc))      { $cc = ''; }
  if (!isset($subject)) { $subject = ''; }
  if ( $get_sig && $sig = imp_get_signature($user, $server)) { $msg .= "\n\n\n" . $sig; }
  
  $addresses = imp_get_addresses($user, $server);
  
  $options = '<option value=\'\'>add address:</option>';
  for ($i = 0; $i < count($addresses); $i++) {
    $options .= '<option value="' . $addresses[$i][0] . '">' . $addresses[$i][1] . ' &lt;' . $addresses[$i][0] . "&gt;\n";
  }
  
  require("$default->include_dir/compose.php3-compose.inc");
  require("$default->include_dir/generic-footer.inc");
  require("$default->include_dir/compose.php3-javascript.inc");
?>
