<?php

/*
   
   File: view.php3
   $Author: paudley $
   $Revision: 1.16 $
   $Date: 1998/10/01 09:01:14 $
   
   IMP: Copyright 1998 Charles J. Hagenbuch <chuck@osmos.ml.org>
   
   This code is under the GNU Public License
   See the file COPYING in this directory
   
*/
  
  require( './lib/imp.lib.php3' );      /* IMPlib is the IMP function library  */
  require( './config/defaults.php3' );  /* Defaults configuration file */
  require( './lib/mimetypes.php3' );    /* Mime functions */
  
  if( $default->ssl->enabled ) { include( "./lib/ssl_lib.php3" ); }

  error_reporting($default->error_level);  /* set error level from imp.lib.php3   */
  header('Expires: 120');         /* make the page expire in 2 minutes   */
  
  $user    = getuser();
  $pass    = getpass();
  $server  = getsrvr();
  $port    = getport();
  $folders = getfldr();
  if (!$mailbox) { $mailbox = "INBOX"; }
  
  $mbox = validate_login($server, $port, $mailbox, $user, $pass);
  
  
  $structure = imap_fetchstructure ($mbox,$index);
  if( !is_array($structure->parts) ) {
    $part = $structure;
    $bodyonly = true;
  } else {
    $part = $structure->parts[$bodypart];
    $bodyonly = false;
  }

#  include("./lib/debug/mime_debug.php3" );
#  decompose($part);

      
  /* Run through action handlers */
  if (isset($actionID)) {
    switch($actionID) {
      case NO_ACTION:
        break;
      
      case DOWNLOAD_ATTACH:
        $mime = new mime_part_data;
        $mime->parse( $part );

        /* This should force a save file dialog... */
        header("Content-type: application/octet-stream");
        break;
      
      case VIEW_ATTACH: {
	$mime = new mime_part_data;
	$mime->parse( $part );
	$mime->set_imap_data( $mailbox, $index, $bodypart );
	Header("content-type: text/html");
	if( isset($mime->action["view_function"]) ) {
	  $title = "MIME Attachment View";
	  require("$default->include_dir/generic-header.inc");
	  eval( "echo ".$mime->action["view_function"].'(\$mime);' );
	  require("$default->include_dir/generic-footer.inc");
	  exit;
	}
	  
        if (($mime->subtype == 'jpeg') || ($mime->subtype == 'gif')) {
	  header("Content-type: image/$mime->subtype");
	} else {
          $mime->encoding = 1;
	  header("Content-type: text/plain");
	}
      } break;
      
      case VIEW_SOURCE:
        if( !$default->view_message_source ) {
          echo "Not Authorized.";
        } else {
          header("Content-type: text/plain");
          echo imap_fetchheader ($mbox, $index ) . "\n" . imap_body ($mbox, $index );
          imap_close($mbox);
          exit; 
        }
        break;
    }
  }
  
  header("Content-Disposition: inline; filename=$mime->name");

  if( !$bodyonly ) {
    $bodypart++;
    $body = imap_fetchbody ($mbox, $index, $bodypart);
  } else {
    $body = imap_body($mbox,$index);
  }
  
  if ($mime->encoding == 3) { echo imap_base64($body); }
  else { echo $body; }
  
  imap_close($mbox);
?>
