<?php

/*
  
  File: prefs.php3
  $Author: paudley $
  $Revision: 1.15 $
  $Date: 1998/10/01 23:29:46 $
  
  IMP: Copyright 1998 Charles J. Hagenbuch <chuck@osmos.ml.org>
  
  This code is under the GNU Public License
  See the file COPYING in this directory
  
*/
  
  require( './lib/imp.lib.php3' );         /* IMPlib is the IMP function library  */
  require( './config/defaults.php3' );     /* Defaults configuration file */
  if ($default->ssl->enabled) { include( './lib/ssl_lib.php3' ); }
  error_reporting($default->error_level);  /* set error level from imp.lib.php3   */
  require($default->db_lib);               /* DBlib is the db backend library     */
  header('Expires: 120');                  /* make the page expire in 2 minutes   */
  
  /* retrieve authentication information from cookies */
  $user    = getuser();
  $pass    = getpass();
  $server  = getsrvr();
  $port    = getport();
  $folders = getfldr();
  $mailbox = '';
  
  /* proceed only with a valid login */
  $mbox = validate_login($server, $port, $mailbox, $user, $pass);
  
  
  /* Run through the action handlers */
  if (isset($actionID)) {
    switch($actionID) {
      case NO_ACTION:
        break;
      
      case UPDATE_SIGNATURE:
        if ($signature) {
	  if (!(imp_set_signature($signature, $user, $server))) {
	    $errormsg = '<tr><th>An error occured; your signature was not updated.</th></tr>';
	  }
	}
	break;
    }
  }
  
  $title = "IMP Preferences";
  $no_table_frame = false;
  $sidebar = false;
  require( "$default->include_dir/generic-header.inc" );
  require( "$default->include_dir/prefs.php3-signature.inc" );
  require( "$default->include_dir/generic-footer.inc" );
?>
